/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.commons.codec.digest.DigestUtils;
import ai.org.apache.poi.EncryptedDocumentException;
import ai.org.apache.poi.POIDocument;
import ai.org.apache.poi.ddf.EscherBSERecord;
import ai.org.apache.poi.ddf.EscherBitmapBlip;
import ai.org.apache.poi.ddf.EscherBlipRecord;
import ai.org.apache.poi.ddf.EscherMetafileBlip;
import ai.org.apache.poi.ddf.EscherRecord;
import ai.org.apache.poi.hpsf.ClassID;
import ai.org.apache.poi.hssf.OldExcelFormatException;
import ai.org.apache.poi.hssf.model.DrawingManager2;
import ai.org.apache.poi.hssf.model.HSSFFormulaParser;
import ai.org.apache.poi.hssf.model.InternalSheet;
import ai.org.apache.poi.hssf.model.InternalWorkbook;
import ai.org.apache.poi.hssf.model.RecordStream;
import ai.org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import ai.org.apache.poi.hssf.record.BackupRecord;
import ai.org.apache.poi.hssf.record.DrawingGroupRecord;
import ai.org.apache.poi.hssf.record.ExtendedFormatRecord;
import ai.org.apache.poi.hssf.record.FontRecord;
import ai.org.apache.poi.hssf.record.LabelRecord;
import ai.org.apache.poi.hssf.record.LabelSSTRecord;
import ai.org.apache.poi.hssf.record.NameRecord;
import ai.org.apache.poi.hssf.record.RecalcIdRecord;
import ai.org.apache.poi.hssf.record.Record;
import ai.org.apache.poi.hssf.record.RecordFactory;
import ai.org.apache.poi.hssf.record.UnknownRecord;
import ai.org.apache.poi.hssf.record.aggregates.RecordAggregate;
import ai.org.apache.poi.hssf.record.common.UnicodeString;
import ai.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import ai.org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import ai.org.apache.poi.hssf.usermodel.HSSFDataFormat;
import ai.org.apache.poi.hssf.usermodel.HSSFFont;
import ai.org.apache.poi.hssf.usermodel.HSSFName;
import ai.org.apache.poi.hssf.usermodel.HSSFObjectData;
import ai.org.apache.poi.hssf.usermodel.HSSFPalette;
import ai.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import ai.org.apache.poi.hssf.usermodel.HSSFPictureData;
import ai.org.apache.poi.hssf.usermodel.HSSFRow;
import ai.org.apache.poi.hssf.usermodel.HSSFShape;
import ai.org.apache.poi.hssf.usermodel.HSSFShapeContainer;
import ai.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai.org.apache.poi.hssf.util.CellReference;
import ai.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai.org.apache.poi.poifs.filesystem.EntryUtils;
import ai.org.apache.poi.poifs.filesystem.FilteringDirectoryNode;
import ai.org.apache.poi.poifs.filesystem.Ole10Native;
import ai.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai.org.apache.poi.ss.formula.FormulaShifter;
import ai.org.apache.poi.ss.formula.SheetNameFormatter;
import ai.org.apache.poi.ss.formula.udf.AggregatingUDFFinder;
import ai.org.apache.poi.ss.formula.udf.IndexedUDFFinder;
import ai.org.apache.poi.ss.formula.udf.UDFFinder;
import ai.org.apache.poi.ss.usermodel.Row;
import ai.org.apache.poi.ss.usermodel.Sheet;
import ai.org.apache.poi.ss.usermodel.Workbook;
import ai.org.apache.poi.ss.util.CellRangeAddress;
import ai.org.apache.poi.ss.util.WorkbookUtil;
import ai.org.apache.poi.util.Configurator;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndian;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSSFWorkbook
extends POIDocument
implements Workbook {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final int MAX_STYLES = 4030;
    private static final int DEBUG = 1;
    public static final int INITIAL_CAPACITY = Configurator.getIntValue("HSSFWorkbook.SheetInitialCapacity", 3);
    private InternalWorkbook workbook;
    protected List<HSSFSheet> _sheets;
    private ArrayList<HSSFName> names;
    private Hashtable<Short, HSSFFont> fonts;
    private boolean preserveNodes;
    private HSSFDataFormat formatter;
    private Row.MissingCellPolicy missingCellPolicy = HSSFRow.RETURN_NULL_AND_BLANK;
    private static POILogger log = POILogFactory.getLogger(HSSFWorkbook.class);
    private UDFFinder _udfFinder = new IndexedUDFFinder(UDFFinder.DEFAULT);
    private static final String[] WORKBOOK_DIR_ENTRY_NAMES = new String[]{"Workbook", "WORKBOOK", "BOOK"};

    public static HSSFWorkbook create(InternalWorkbook internalWorkbook) {
        return new HSSFWorkbook(internalWorkbook);
    }

    public HSSFWorkbook() {
        this(InternalWorkbook.createWorkbook());
    }

    private HSSFWorkbook(InternalWorkbook internalWorkbook) {
        super((DirectoryNode)null);
        this.workbook = internalWorkbook;
        this._sheets = new ArrayList<HSSFSheet>(INITIAL_CAPACITY);
        this.names = new ArrayList(INITIAL_CAPACITY);
    }

    public HSSFWorkbook(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem, true);
    }

    public HSSFWorkbook(POIFSFileSystem pOIFSFileSystem, boolean bl) throws IOException {
        this(pOIFSFileSystem.getRoot(), pOIFSFileSystem, bl);
    }

    public static String getWorkbookDirEntryName(DirectoryNode directoryNode) {
        for (int i = 0; i < WORKBOOK_DIR_ENTRY_NAMES.length; ++i) {
            String string = WORKBOOK_DIR_ENTRY_NAMES[i];
            try {
                directoryNode.getEntry(string);
                return string;
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
        }
        try {
            directoryNode.getEntry("EncryptedPackage");
            throw new EncryptedDocumentException("The supplied spreadsheet seems to be an Encrypted .xlsx file. It must be decrypted before use by XSSF, it cannot be used by HSSF");
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                directoryNode.getEntry("Book");
                throw new OldExcelFormatException("The supplied spreadsheet seems to be Excel 5.0/7.0 (BIFF5) format. POI only supports BIFF8 format (from Excel versions 97/2000/XP/2003)");
            }
            catch (FileNotFoundException fileNotFoundException2) {
                throw new IllegalArgumentException("The supplied POIFSFileSystem does not contain a BIFF8 'Workbook' entry. Is it really an excel file?");
            }
        }
    }

    public HSSFWorkbook(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem, boolean bl) throws IOException {
        this(directoryNode, bl);
    }

    public HSSFWorkbook(DirectoryNode directoryNode, boolean bl) throws IOException {
        super(directoryNode);
        String string = HSSFWorkbook.getWorkbookDirEntryName(directoryNode);
        this.preserveNodes = bl;
        if (!bl) {
            this.directory = null;
        }
        this._sheets = new ArrayList<HSSFSheet>(INITIAL_CAPACITY);
        this.names = new ArrayList(INITIAL_CAPACITY);
        DocumentInputStream documentInputStream = directoryNode.createDocumentInputStream(string);
        List<Record> list = RecordFactory.createRecords(documentInputStream);
        this.workbook = InternalWorkbook.createWorkbook(list);
        this.setPropertiesFromWorkbook(this.workbook);
        int n = this.workbook.getNumRecords();
        this.convertLabelRecords(list, n);
        RecordStream recordStream = new RecordStream(list, n);
        while (recordStream.hasNext()) {
            try {
                InternalSheet internalSheet = InternalSheet.createSheet(recordStream);
                this._sheets.add(new HSSFSheet(this, internalSheet));
            }
            catch (InternalSheet.UnsupportedBOFType unsupportedBOFType) {
                log.log(5, "Unsupported BOF found of type " + unsupportedBOFType.getType());
            }
        }
        for (int i = 0; i < this.workbook.getNumNames(); ++i) {
            NameRecord nameRecord = this.workbook.getNameRecord(i);
            HSSFName hSSFName = new HSSFName(this, nameRecord, this.workbook.getNameCommentRecord(nameRecord));
            this.names.add(hSSFName);
        }
    }

    public HSSFWorkbook(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public HSSFWorkbook(InputStream inputStream, boolean bl) throws IOException {
        this(new POIFSFileSystem(inputStream), bl);
    }

    private void setPropertiesFromWorkbook(InternalWorkbook internalWorkbook) {
        this.workbook = internalWorkbook;
    }

    private void convertLabelRecords(List<Record> list, int n) {
        if (log.check(1)) {
            log.log(1, "convertLabelRecords called");
        }
        for (int i = n; i < list.size(); ++i) {
            Record record = list.get(i);
            if (record.getSid() != 516) continue;
            LabelRecord labelRecord = (LabelRecord)record;
            list.remove(i);
            LabelSSTRecord labelSSTRecord = new LabelSSTRecord();
            int n2 = this.workbook.addSSTString(new UnicodeString(labelRecord.getValue()));
            labelSSTRecord.setRow(labelRecord.getRow());
            labelSSTRecord.setColumn(labelRecord.getColumn());
            labelSSTRecord.setXFIndex(labelRecord.getXFIndex());
            labelSSTRecord.setSSTIndex(n2);
            list.add(i, labelSSTRecord);
        }
        if (log.check(1)) {
            log.log(1, "convertLabelRecords exit");
        }
    }

    @Override
    public Row.MissingCellPolicy getMissingCellPolicy() {
        return this.missingCellPolicy;
    }

    @Override
    public void setMissingCellPolicy(Row.MissingCellPolicy missingCellPolicy) {
        this.missingCellPolicy = missingCellPolicy;
    }

    @Override
    public void setSheetOrder(String string, int n) {
        int n2 = this.getSheetIndex(string);
        this._sheets.add(n, this._sheets.remove(n2));
        this.workbook.setSheetOrder(string, n);
        FormulaShifter formulaShifter = FormulaShifter.createForSheetShift(n2, n);
        for (HSSFSheet hSSFSheet : this._sheets) {
            hSSFSheet.getSheet().updateFormulasAfterCellShift(formulaShifter, -1);
        }
        this.workbook.updateNamesAfterCellShift(formulaShifter);
    }

    private void validateSheetIndex(int n) {
        int n2 = this._sheets.size() - 1;
        if (n < 0 || n > n2) {
            String string = "(0.." + n2 + ")";
            if (n2 == -1) {
                string = "(no sheets)";
            }
            throw new IllegalArgumentException("Sheet index (" + n + ") is out of range " + string);
        }
    }

    @Override
    public void setSelectedTab(int n) {
        this.validateSheetIndex(n);
        int n2 = this._sheets.size();
        for (int i = 0; i < n2; ++i) {
            this.getSheetAt(i).setSelected(i == n);
        }
        this.workbook.getWindowOne().setNumSelectedTabs((short)1);
    }

    @Deprecated
    public void setSelectedTab(short s) {
        this.setSelectedTab((int)s);
    }

    public void setSelectedTabs(int[] nArray) {
        int n;
        for (n = 0; n < nArray.length; ++n) {
            this.validateSheetIndex(nArray[n]);
        }
        n = this._sheets.size();
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != i) continue;
                bl = true;
                break;
            }
            this.getSheetAt(i).setSelected(bl);
        }
        this.workbook.getWindowOne().setNumSelectedTabs((short)nArray.length);
    }

    @Override
    public void setActiveSheet(int n) {
        this.validateSheetIndex(n);
        int n2 = this._sheets.size();
        for (int i = 0; i < n2; ++i) {
            this.getSheetAt(i).setActive(i == n);
        }
        this.workbook.getWindowOne().setActiveSheetIndex(n);
    }

    @Override
    public int getActiveSheetIndex() {
        return this.workbook.getWindowOne().getActiveSheetIndex();
    }

    @Deprecated
    public short getSelectedTab() {
        return (short)this.getActiveSheetIndex();
    }

    @Override
    public void setFirstVisibleTab(int n) {
        this.workbook.getWindowOne().setFirstVisibleTab(n);
    }

    @Deprecated
    public void setDisplayedTab(short s) {
        this.setFirstVisibleTab(s);
    }

    @Override
    public int getFirstVisibleTab() {
        return this.workbook.getWindowOne().getFirstVisibleTab();
    }

    @Deprecated
    public short getDisplayedTab() {
        return (short)this.getFirstVisibleTab();
    }

    @Override
    public void setSheetName(int n, String string) {
        if (string == null) {
            throw new IllegalArgumentException("sheetName must not be null");
        }
        if (this.workbook.doesContainsSheetName(string, n)) {
            throw new IllegalArgumentException("The workbook already contains a sheet with this name");
        }
        this.validateSheetIndex(n);
        this.workbook.setSheetName(n, string);
    }

    @Override
    public String getSheetName(int n) {
        this.validateSheetIndex(n);
        return this.workbook.getSheetName(n);
    }

    @Override
    public boolean isHidden() {
        return this.workbook.getWindowOne().getHidden();
    }

    @Override
    public void setHidden(boolean bl) {
        this.workbook.getWindowOne().setHidden(bl);
    }

    @Override
    public boolean isSheetHidden(int n) {
        this.validateSheetIndex(n);
        return this.workbook.isSheetHidden(n);
    }

    @Override
    public boolean isSheetVeryHidden(int n) {
        this.validateSheetIndex(n);
        return this.workbook.isSheetVeryHidden(n);
    }

    @Override
    public void setSheetHidden(int n, boolean bl) {
        this.validateSheetIndex(n);
        this.workbook.setSheetHidden(n, bl);
    }

    @Override
    public void setSheetHidden(int n, int n2) {
        this.validateSheetIndex(n);
        WorkbookUtil.validateSheetState(n2);
        this.workbook.setSheetHidden(n, n2);
    }

    @Override
    public int getSheetIndex(String string) {
        return this.workbook.getSheetIndex(string);
    }

    @Override
    public int getSheetIndex(Sheet sheet) {
        for (int i = 0; i < this._sheets.size(); ++i) {
            if (this._sheets.get(i) != sheet) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public int getExternalSheetIndex(int n) {
        return this.workbook.checkExternSheet(n);
    }

    @Deprecated
    public String findSheetNameFromExternSheet(int n) {
        return this.workbook.findSheetFirstNameFromExternSheet(n);
    }

    @Deprecated
    public String resolveNameXText(int n, int n2) {
        return this.workbook.resolveNameXText(n, n2);
    }

    @Override
    public HSSFSheet createSheet() {
        HSSFSheet hSSFSheet = new HSSFSheet(this);
        this._sheets.add(hSSFSheet);
        this.workbook.setSheetName(this._sheets.size() - 1, "Sheet" + (this._sheets.size() - 1));
        boolean bl = this._sheets.size() == 1;
        hSSFSheet.setSelected(bl);
        hSSFSheet.setActive(bl);
        return hSSFSheet;
    }

    @Override
    public HSSFSheet cloneSheet(int n) {
        this.validateSheetIndex(n);
        HSSFSheet hSSFSheet = this._sheets.get(n);
        String string = this.workbook.getSheetName(n);
        HSSFSheet hSSFSheet2 = hSSFSheet.cloneSheet(this);
        hSSFSheet2.setSelected(false);
        hSSFSheet2.setActive(false);
        String string2 = this.getUniqueSheetName(string);
        int n2 = this._sheets.size();
        this._sheets.add(hSSFSheet2);
        this.workbook.setSheetName(n2, string2);
        int n3 = this.findExistingBuiltinNameRecordIdx(n, (byte)13);
        if (n3 != -1) {
            NameRecord nameRecord = this.workbook.cloneFilter(n3, n2);
            HSSFName hSSFName = new HSSFName(this, nameRecord);
            this.names.add(hSSFName);
        }
        return hSSFSheet2;
    }

    private String getUniqueSheetName(String string) {
        String string2;
        String string3;
        int n = 2;
        String string4 = string;
        int n2 = string.lastIndexOf(40);
        if (n2 > 0 && string.endsWith(")")) {
            string3 = string.substring(n2 + 1, string.length() - ")".length());
            try {
                n = Integer.parseInt(string3.trim());
                string4 = string.substring(0, n2).trim();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        do {
            int n3 = ++n;
            ++n;
            string3 = Integer.toString(n3);
        } while (this.workbook.getSheetIndex(string2 = string4.length() + string3.length() + 2 < 31 ? string4 + " (" + string3 + ")" : string4.substring(0, 31 - string3.length() - 2) + "(" + string3 + ")") != -1);
        return string2;
    }

    @Override
    public HSSFSheet createSheet(String string) {
        if (string == null) {
            throw new IllegalArgumentException("sheetName must not be null");
        }
        if (this.workbook.doesContainsSheetName(string, this._sheets.size())) {
            throw new IllegalArgumentException("The workbook already contains a sheet of this name");
        }
        HSSFSheet hSSFSheet = new HSSFSheet(this);
        this.workbook.setSheetName(this._sheets.size(), string);
        this._sheets.add(hSSFSheet);
        boolean bl = this._sheets.size() == 1;
        hSSFSheet.setSelected(bl);
        hSSFSheet.setActive(bl);
        return hSSFSheet;
    }

    @Override
    public int getNumberOfSheets() {
        return this._sheets.size();
    }

    @Deprecated
    public int getSheetIndexFromExternSheetIndex(int n) {
        return this.workbook.getFirstSheetIndexFromExternSheetIndex(n);
    }

    private HSSFSheet[] getSheets() {
        HSSFSheet[] hSSFSheetArray = new HSSFSheet[this._sheets.size()];
        this._sheets.toArray(hSSFSheetArray);
        return hSSFSheetArray;
    }

    @Override
    public HSSFSheet getSheetAt(int n) {
        this.validateSheetIndex(n);
        return this._sheets.get(n);
    }

    @Override
    public HSSFSheet getSheet(String string) {
        HSSFSheet hSSFSheet = null;
        for (int i = 0; i < this._sheets.size(); ++i) {
            String string2 = this.workbook.getSheetName(i);
            if (!string2.equalsIgnoreCase(string)) continue;
            hSSFSheet = this._sheets.get(i);
        }
        return hSSFSheet;
    }

    @Override
    public void removeSheetAt(int n) {
        this.validateSheetIndex(n);
        boolean bl = this.getSheetAt(n).isActive();
        boolean bl2 = this.getSheetAt(n).isSelected();
        this._sheets.remove(n);
        this.workbook.removeSheet(n);
        int n2 = this._sheets.size();
        if (n2 < 1) {
            return;
        }
        int n3 = n;
        if (n3 >= n2) {
            n3 = n2 - 1;
        }
        if (bl) {
            this.setActiveSheet(n3);
        }
        if (bl2) {
            boolean bl3 = false;
            for (int i = 0; i < n2; ++i) {
                if (!this.getSheetAt(i).isSelected()) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                this.setSelectedTab(n3);
            }
        }
    }

    public void setBackupFlag(boolean bl) {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        backupRecord.setBackup(bl ? (short)1 : 0);
    }

    public boolean getBackupFlag() {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        return backupRecord.getBackup() != 0;
    }

    @Override
    @Deprecated
    public void setRepeatingRowsAndColumns(int n, int n2, int n3, int n4, int n5) {
        HSSFSheet hSSFSheet = this.getSheetAt(n);
        CellRangeAddress cellRangeAddress = null;
        CellRangeAddress cellRangeAddress2 = null;
        if (n4 != -1) {
            cellRangeAddress = new CellRangeAddress(n4, n5, -1, -1);
        }
        if (n2 != -1) {
            cellRangeAddress2 = new CellRangeAddress(-1, -1, n2, n3);
        }
        hSSFSheet.setRepeatingRows(cellRangeAddress);
        hSSFSheet.setRepeatingColumns(cellRangeAddress2);
    }

    int findExistingBuiltinNameRecordIdx(int n, byte by) {
        for (int i = 0; i < this.names.size(); ++i) {
            NameRecord nameRecord = this.workbook.getNameRecord(i);
            if (nameRecord == null) {
                throw new RuntimeException("Unable to find all defined names to iterate over");
            }
            if (!nameRecord.isBuiltInName() || nameRecord.getBuiltInName() != by || nameRecord.getSheetNumber() - 1 != n) continue;
            return i;
        }
        return -1;
    }

    HSSFName createBuiltInName(byte by, int n) {
        NameRecord nameRecord = this.workbook.createBuiltInName(by, n + 1);
        HSSFName hSSFName = new HSSFName(this, nameRecord, null);
        this.names.add(hSSFName);
        return hSSFName;
    }

    HSSFName getBuiltInName(byte by, int n) {
        int n2 = this.findExistingBuiltinNameRecordIdx(n, by);
        if (n2 < 0) {
            return null;
        }
        return this.names.get(n2);
    }

    @Override
    public HSSFFont createFont() {
        this.workbook.createNewFont();
        short s = (short)(this.getNumberOfFonts() - 1);
        if (s > 3) {
            s = (short)(s + 1);
        }
        if (s == Short.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum number of fonts was exceeded");
        }
        return this.getFontAt(s);
    }

    @Override
    public HSSFFont findFont(short s, short s2, short s3, String string, boolean bl, boolean bl2, short s4, byte by) {
        for (short s5 = 0; s5 <= this.getNumberOfFonts(); s5 = (short)(s5 + 1)) {
            HSSFFont hSSFFont;
            if (s5 == 4 || (hSSFFont = this.getFontAt(s5)).getBoldweight() != s || hSSFFont.getColor() != s2 || hSSFFont.getFontHeight() != s3 || !hSSFFont.getFontName().equals(string) || hSSFFont.getItalic() != bl || hSSFFont.getStrikeout() != bl2 || hSSFFont.getTypeOffset() != s4 || hSSFFont.getUnderline() != by) continue;
            return hSSFFont;
        }
        return null;
    }

    @Override
    public short getNumberOfFonts() {
        return (short)this.workbook.getNumberOfFontRecords();
    }

    @Override
    public HSSFFont getFontAt(short s) {
        Short s2;
        if (this.fonts == null) {
            this.fonts = new Hashtable();
        }
        if (this.fonts.containsKey(s2 = Short.valueOf(s))) {
            return this.fonts.get(s2);
        }
        FontRecord fontRecord = this.workbook.getFontRecordAt(s);
        HSSFFont hSSFFont = new HSSFFont(s, fontRecord);
        this.fonts.put(s2, hSSFFont);
        return hSSFFont;
    }

    protected void resetFontCache() {
        this.fonts = new Hashtable();
    }

    @Override
    public HSSFCellStyle createCellStyle() {
        if (this.workbook.getNumExFormats() == 4030) {
            throw new IllegalStateException("The maximum number of cell styles was exceeded. You can define up to 4000 styles in a .xls workbook");
        }
        ExtendedFormatRecord extendedFormatRecord = this.workbook.createCellXF();
        short s = (short)(this.getNumCellStyles() - 1);
        HSSFCellStyle hSSFCellStyle = new HSSFCellStyle(s, extendedFormatRecord, this);
        return hSSFCellStyle;
    }

    @Override
    public short getNumCellStyles() {
        return (short)this.workbook.getNumExFormats();
    }

    @Override
    public HSSFCellStyle getCellStyleAt(short s) {
        ExtendedFormatRecord extendedFormatRecord = this.workbook.getExFormatAt(s);
        HSSFCellStyle hSSFCellStyle = new HSSFCellStyle(s, extendedFormatRecord, this);
        return hSSFCellStyle;
    }

    @Override
    public void close() throws IOException {
        if (this.directory != null && this.directory.getNFileSystem() != null) {
            this.directory.getNFileSystem().close();
            this.directory = null;
        }
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        byte[] byArray = this.getBytes();
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem();
        ArrayList<String> arrayList = new ArrayList<String>(1);
        pOIFSFileSystem.createDocument(new ByteArrayInputStream(byArray), "Workbook");
        this.writeProperties(pOIFSFileSystem, arrayList);
        if (this.preserveNodes) {
            arrayList.addAll(Arrays.asList(WORKBOOK_DIR_ENTRY_NAMES));
            EntryUtils.copyNodes(new FilteringDirectoryNode(this.directory, arrayList), new FilteringDirectoryNode(pOIFSFileSystem.getRoot(), arrayList));
            pOIFSFileSystem.getRoot().setStorageClsid(this.directory.getStorageClsid());
        }
        pOIFSFileSystem.writeFilesystem(outputStream);
    }

    public byte[] getBytes() {
        int n;
        if (log.check(1)) {
            log.log(1, "HSSFWorkbook.getBytes()");
        }
        HSSFSheet[] hSSFSheetArray = this.getSheets();
        int n2 = hSSFSheetArray.length;
        this.workbook.preSerialize();
        for (n = 0; n < n2; ++n) {
            hSSFSheetArray[n].getSheet().preSerialize();
            hSSFSheetArray[n].preSerialize();
        }
        n = this.workbook.getSize();
        SheetRecordCollector[] sheetRecordCollectorArray = new SheetRecordCollector[n2];
        for (int i = 0; i < n2; ++i) {
            this.workbook.setSheetBof(i, n);
            SheetRecordCollector sheetRecordCollector = new SheetRecordCollector();
            hSSFSheetArray[i].getSheet().visitContainedRecords(sheetRecordCollector, n);
            n += sheetRecordCollector.getTotalSize();
            sheetRecordCollectorArray[i] = sheetRecordCollector;
        }
        byte[] byArray = new byte[n];
        int n3 = this.workbook.serialize(0, byArray);
        for (int i = 0; i < n2; ++i) {
            SheetRecordCollector sheetRecordCollector = sheetRecordCollectorArray[i];
            int n4 = sheetRecordCollector.serialize(n3, byArray);
            if (n4 != sheetRecordCollector.getTotalSize()) {
                throw new IllegalStateException("Actual serialized sheet size (" + n4 + ") differs from pre-calculated size (" + sheetRecordCollector.getTotalSize() + ") for sheet (" + i + ")");
            }
            n3 += n4;
        }
        return byArray;
    }

    @Deprecated
    public int addSSTString(String string) {
        return this.workbook.addSSTString(new UnicodeString(string));
    }

    @Deprecated
    public String getSSTString(int n) {
        return this.workbook.getSSTString(n).getString();
    }

    InternalWorkbook getWorkbook() {
        return this.workbook;
    }

    @Override
    public int getNumberOfNames() {
        int n = this.names.size();
        return n;
    }

    @Override
    public HSSFName getName(String string) {
        int n = this.getNameIndex(string);
        if (n < 0) {
            return null;
        }
        return this.names.get(n);
    }

    @Override
    public HSSFName getNameAt(int n) {
        int n2 = this.names.size();
        if (n2 < 1) {
            throw new IllegalStateException("There are no defined names in this workbook");
        }
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("Specified name index " + n + " is outside the allowable range (0.." + (n2 - 1) + ").");
        }
        return this.names.get(n);
    }

    public NameRecord getNameRecord(int n) {
        return this.getWorkbook().getNameRecord(n);
    }

    public String getNameName(int n) {
        String string = this.getNameAt(n).getNameName();
        return string;
    }

    @Override
    public void setPrintArea(int n, String string) {
        NameRecord nameRecord = this.workbook.getSpecificBuiltinRecord((byte)6, n + 1);
        if (nameRecord == null) {
            nameRecord = this.workbook.createBuiltInName((byte)6, n + 1);
        }
        String[] stringArray = COMMA_PATTERN.split(string);
        StringBuffer stringBuffer = new StringBuffer(32);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            SheetNameFormatter.appendFormat(stringBuffer, this.getSheetName(n));
            stringBuffer.append("!");
            stringBuffer.append(stringArray[i]);
        }
        nameRecord.setNameDefinition(HSSFFormulaParser.parse(stringBuffer.toString(), this, 4, n));
    }

    @Override
    public void setPrintArea(int n, int n2, int n3, int n4, int n5) {
        CellReference cellReference = new CellReference(n4, n2, true, true);
        String string = cellReference.formatAsString();
        cellReference = new CellReference(n5, n3, true, true);
        string = string + ":" + cellReference.formatAsString();
        this.setPrintArea(n, string);
    }

    @Override
    public String getPrintArea(int n) {
        NameRecord nameRecord = this.workbook.getSpecificBuiltinRecord((byte)6, n + 1);
        if (nameRecord == null) {
            return null;
        }
        return HSSFFormulaParser.toFormulaString(this, nameRecord.getNameDefinition());
    }

    @Override
    public void removePrintArea(int n) {
        this.getWorkbook().removeBuiltinRecord((byte)6, n + 1);
    }

    @Override
    public HSSFName createName() {
        NameRecord nameRecord = this.workbook.createName();
        HSSFName hSSFName = new HSSFName(this, nameRecord);
        this.names.add(hSSFName);
        return hSSFName;
    }

    @Override
    public int getNameIndex(String string) {
        for (int i = 0; i < this.names.size(); ++i) {
            String string2 = this.getNameName(i);
            if (!string2.equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    int getNameIndex(HSSFName hSSFName) {
        for (int i = 0; i < this.names.size(); ++i) {
            if (hSSFName != this.names.get(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void removeName(int n) {
        this.names.remove(n);
        this.workbook.removeName(n);
    }

    @Override
    public HSSFDataFormat createDataFormat() {
        if (this.formatter == null) {
            this.formatter = new HSSFDataFormat(this.workbook);
        }
        return this.formatter;
    }

    @Override
    public void removeName(String string) {
        int n = this.getNameIndex(string);
        this.removeName(n);
    }

    void removeName(HSSFName hSSFName) {
        int n = this.getNameIndex(hSSFName);
        this.removeName(n);
    }

    public HSSFPalette getCustomPalette() {
        return new HSSFPalette(this.workbook.getCustomPalette());
    }

    public void insertChartRecord() {
        int n = this.workbook.findFirstRecordLocBySid((short)252);
        byte[] byArray = new byte[]{15, 0, 0, -16, 82, 0, 0, 0, 0, 0, 6, -16, 24, 0, 0, 0, 1, 8, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 3, 0, 0, 0, 51, 0, 11, -16, 18, 0, 0, 0, -65, 0, 8, 0, 8, 0, -127, 1, 9, 0, 0, 8, -64, 1, 64, 0, 0, 8, 64, 0, 30, -15, 16, 0, 0, 0, 13, 0, 0, 8, 12, 0, 0, 8, 23, 0, 0, 8, -9, 0, 0, 16};
        UnknownRecord unknownRecord = new UnknownRecord(235, byArray);
        this.workbook.getRecords().add(n, unknownRecord);
    }

    public void dumpDrawingGroupRecords(boolean bl) {
        DrawingGroupRecord drawingGroupRecord = (DrawingGroupRecord)this.workbook.findFirstRecordBySid((short)235);
        drawingGroupRecord.decode();
        List<EscherRecord> list = drawingGroupRecord.getEscherRecords();
        PrintWriter printWriter = new PrintWriter(System.out);
        for (EscherRecord escherRecord : list) {
            if (bl) {
                System.out.println(escherRecord.toString());
                continue;
            }
            escherRecord.display(printWriter, 0);
        }
        printWriter.flush();
    }

    void initDrawings() {
        DrawingManager2 drawingManager2 = this.workbook.findDrawingGroup();
        if (drawingManager2 != null) {
            for (int i = 0; i < this.getNumberOfSheets(); ++i) {
                this.getSheetAt(i).getDrawingPatriarch();
            }
        } else {
            this.workbook.createDrawingGroup();
        }
    }

    @Override
    public int addPicture(byte[] object, int n) {
        short s;
        int n2;
        EscherBlipRecord escherBlipRecord;
        Object object2;
        this.initDrawings();
        byte[] byArray = DigestUtils.md5(object);
        switch (n) {
            case 3: {
                if (LittleEndian.getInt(object) == -1698247209) {
                    object2 = new byte[((byte[])object).length - 22];
                    System.arraycopy(object, 22, object2, 0, ((byte[])object).length - 22);
                    object = object2;
                }
            }
            case 2: {
                object2 = new EscherMetafileBlip();
                escherBlipRecord = object2;
                ((EscherMetafileBlip)object2).setUID(byArray);
                ((EscherMetafileBlip)object2).setPictureData((byte[])object);
                ((EscherMetafileBlip)object2).setFilter((byte)-2);
                n2 = ((EscherMetafileBlip)object2).getCompressedSize() + 58;
                s = 0;
                break;
            }
            default: {
                EscherBitmapBlip escherBitmapBlip = new EscherBitmapBlip();
                escherBlipRecord = escherBitmapBlip;
                escherBitmapBlip.setUID(byArray);
                escherBitmapBlip.setMarker((byte)-1);
                escherBitmapBlip.setPictureData((byte[])object);
                n2 = ((byte[])object).length + 25;
                s = 255;
            }
        }
        escherBlipRecord.setRecordId((short)(-4072 + n));
        switch (n) {
            case 2: {
                escherBlipRecord.setOptions((short)15680);
                break;
            }
            case 3: {
                escherBlipRecord.setOptions((short)8544);
                break;
            }
            case 4: {
                escherBlipRecord.setOptions((short)21536);
                break;
            }
            case 6: {
                escherBlipRecord.setOptions((short)28160);
                break;
            }
            case 5: {
                escherBlipRecord.setOptions((short)18080);
                break;
            }
            case 7: {
                escherBlipRecord.setOptions((short)31360);
            }
        }
        object2 = new EscherBSERecord();
        ((EscherRecord)object2).setRecordId((short)-4089);
        ((EscherRecord)object2).setOptions((short)(2 | n << 4));
        ((EscherBSERecord)object2).setBlipTypeMacOS((byte)n);
        ((EscherBSERecord)object2).setBlipTypeWin32((byte)n);
        ((EscherBSERecord)object2).setUid(byArray);
        ((EscherBSERecord)object2).setTag(s);
        ((EscherBSERecord)object2).setSize(n2);
        ((EscherBSERecord)object2).setRef(0);
        ((EscherBSERecord)object2).setOffset(0);
        ((EscherBSERecord)object2).setBlipRecord(escherBlipRecord);
        return this.workbook.addBSERecord((EscherBSERecord)object2);
    }

    public List<HSSFPictureData> getAllPictures() {
        ArrayList<HSSFPictureData> arrayList = new ArrayList<HSSFPictureData>();
        for (Record record : this.workbook.getRecords()) {
            if (!(record instanceof AbstractEscherHolderRecord)) continue;
            ((AbstractEscherHolderRecord)record).decode();
            List<EscherRecord> list = ((AbstractEscherHolderRecord)record).getEscherRecords();
            this.searchForPictures(list, arrayList);
        }
        return arrayList;
    }

    private void searchForPictures(List<EscherRecord> list, List<HSSFPictureData> list2) {
        for (EscherRecord escherRecord : list) {
            EscherBlipRecord escherBlipRecord;
            if (escherRecord instanceof EscherBSERecord && (escherBlipRecord = ((EscherBSERecord)escherRecord).getBlipRecord()) != null) {
                HSSFPictureData hSSFPictureData = new HSSFPictureData(escherBlipRecord);
                list2.add(hSSFPictureData);
            }
            this.searchForPictures(escherRecord.getChildRecords(), list2);
        }
    }

    protected static Map<String, ClassID> getOleMap() {
        HashMap<String, ClassID> hashMap = new HashMap<String, ClassID>();
        hashMap.put("PowerPoint Document", ClassID.PPT_SHOW);
        for (String string : WORKBOOK_DIR_ENTRY_NAMES) {
            hashMap.put(string, ClassID.XLS_WORKBOOK);
        }
        return hashMap;
    }

    public int addOlePackage(POIFSFileSystem pOIFSFileSystem, String string, String string2, String string3) throws IOException {
        DirectoryNode directoryNode = pOIFSFileSystem.getRoot();
        Map<String, ClassID> map = HSSFWorkbook.getOleMap();
        for (Map.Entry<String, ClassID> entry : map.entrySet()) {
            if (!directoryNode.hasEntry(entry.getKey())) continue;
            directoryNode.setStorageClsid(entry.getValue());
            break;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        pOIFSFileSystem.writeFilesystem(byteArrayOutputStream);
        return this.addOlePackage(byteArrayOutputStream.toByteArray(), string, string2, string3);
    }

    public int addOlePackage(byte[] byArray, String string, String string2, String string3) throws IOException {
        Object object;
        if (this.directory == null) {
            this.directory = new POIFSFileSystem().getRoot();
            this.preserveNodes = true;
        }
        int n = 0;
        DirectoryEntry directoryEntry = null;
        do {
            if (this.directory.hasEntry((String)(object = "MBD" + HexDump.toHex(++n)))) continue;
            directoryEntry = this.directory.createDirectory((String)object);
            directoryEntry.setStorageClsid(ClassID.OLE10_PACKAGE);
        } while (directoryEntry == null);
        object = new byte[]{1, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        directoryEntry.createDocument("\u0001Ole", new ByteArrayInputStream((byte[])object));
        Ole10Native ole10Native = new Ole10Native(string, string2, string3, byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ole10Native.writeOut(byteArrayOutputStream);
        directoryEntry.createDocument("\u0001Ole10Native", new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        return n;
    }

    @Override
    public int linkExternalWorkbook(String string, Workbook workbook) {
        return this.workbook.linkExternalWorkbook(string, workbook);
    }

    public boolean isWriteProtected() {
        return this.workbook.isWriteProtected();
    }

    public void writeProtectWorkbook(String string, String string2) {
        this.workbook.writeProtectWorkbook(string, string2);
    }

    public void unwriteProtectWorkbook() {
        this.workbook.unwriteProtectWorkbook();
    }

    public List<HSSFObjectData> getAllEmbeddedObjects() {
        ArrayList<HSSFObjectData> arrayList = new ArrayList<HSSFObjectData>();
        for (int i = 0; i < this.getNumberOfSheets(); ++i) {
            this.getAllEmbeddedObjects(this.getSheetAt(i), arrayList);
        }
        return arrayList;
    }

    private void getAllEmbeddedObjects(HSSFSheet hSSFSheet, List<HSSFObjectData> list) {
        HSSFPatriarch hSSFPatriarch = hSSFSheet.getDrawingPatriarch();
        if (null == hSSFPatriarch) {
            return;
        }
        this.getAllEmbeddedObjects(hSSFPatriarch, list);
    }

    private void getAllEmbeddedObjects(HSSFShapeContainer hSSFShapeContainer, List<HSSFObjectData> list) {
        for (HSSFShape hSSFShape : hSSFShapeContainer.getChildren()) {
            if (hSSFShape instanceof HSSFObjectData) {
                list.add((HSSFObjectData)hSSFShape);
                continue;
            }
            if (!(hSSFShape instanceof HSSFShapeContainer)) continue;
            this.getAllEmbeddedObjects((HSSFShapeContainer)((Object)hSSFShape), list);
        }
    }

    @Override
    public HSSFCreationHelper getCreationHelper() {
        return new HSSFCreationHelper(this);
    }

    UDFFinder getUDFFinder() {
        return this._udfFinder;
    }

    @Override
    public void addToolPack(UDFFinder uDFFinder) {
        AggregatingUDFFinder aggregatingUDFFinder = (AggregatingUDFFinder)this._udfFinder;
        aggregatingUDFFinder.add(uDFFinder);
    }

    @Override
    public void setForceFormulaRecalculation(boolean bl) {
        InternalWorkbook internalWorkbook = this.getWorkbook();
        RecalcIdRecord recalcIdRecord = internalWorkbook.getRecalcId();
        recalcIdRecord.setEngineId(0);
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        InternalWorkbook internalWorkbook = this.getWorkbook();
        RecalcIdRecord recalcIdRecord = (RecalcIdRecord)internalWorkbook.findFirstRecordBySid((short)449);
        return recalcIdRecord != null && recalcIdRecord.getEngineId() != 0;
    }

    public boolean changeExternalReference(String string, String string2) {
        return this.workbook.changeExternalReference(string, string2);
    }

    public DirectoryNode getRootDirectory() {
        return this.directory;
    }

    private static final class SheetRecordCollector
    implements RecordAggregate.RecordVisitor {
        private List<Record> _list = new ArrayList<Record>(128);
        private int _totalSize = 0;

        public int getTotalSize() {
            return this._totalSize;
        }

        public void visitRecord(Record record) {
            this._list.add(record);
            this._totalSize += record.getRecordSize();
        }

        public int serialize(int n, byte[] byArray) {
            int n2 = 0;
            int n3 = this._list.size();
            for (int i = 0; i < n3; ++i) {
                Record record = this._list.get(i);
                n2 += record.serialize(n + n2, byArray);
            }
            return n2;
        }
    }
}

