/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.ddf.EscherBoolProperty;
import ai.org.apache.poi.ddf.EscherChildAnchorRecord;
import ai.org.apache.poi.ddf.EscherClientAnchorRecord;
import ai.org.apache.poi.ddf.EscherContainerRecord;
import ai.org.apache.poi.ddf.EscherOptRecord;
import ai.org.apache.poi.ddf.EscherProperty;
import ai.org.apache.poi.ddf.EscherRGBProperty;
import ai.org.apache.poi.ddf.EscherSimpleProperty;
import ai.org.apache.poi.ddf.EscherSpRecord;
import ai.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import ai.org.apache.poi.hssf.record.ObjRecord;
import ai.org.apache.poi.hssf.usermodel.HSSFAnchor;
import ai.org.apache.poi.hssf.usermodel.HSSFChildAnchor;
import ai.org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import ai.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import ai.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class HSSFShape {
    public static final int LINEWIDTH_ONE_PT = 12700;
    public static final int LINEWIDTH_DEFAULT = 9525;
    public static final int LINESTYLE__COLOR_DEFAULT = 0x8000040;
    public static final int FILL__FILLCOLOR_DEFAULT = 0x8000009;
    public static final boolean NO_FILL_DEFAULT = true;
    public static final int LINESTYLE_SOLID = 0;
    public static final int LINESTYLE_DASHSYS = 1;
    public static final int LINESTYLE_DOTSYS = 2;
    public static final int LINESTYLE_DASHDOTSYS = 3;
    public static final int LINESTYLE_DASHDOTDOTSYS = 4;
    public static final int LINESTYLE_DOTGEL = 5;
    public static final int LINESTYLE_DASHGEL = 6;
    public static final int LINESTYLE_LONGDASHGEL = 7;
    public static final int LINESTYLE_DASHDOTGEL = 8;
    public static final int LINESTYLE_LONGDASHDOTGEL = 9;
    public static final int LINESTYLE_LONGDASHDOTDOTGEL = 10;
    public static final int LINESTYLE_NONE = -1;
    public static final int LINESTYLE_DEFAULT = -1;
    private HSSFShape parent;
    HSSFAnchor anchor;
    private HSSFPatriarch _patriarch;
    private final EscherContainerRecord _escherContainer;
    private final ObjRecord _objRecord;
    private final EscherOptRecord _optRecord;
    public static final int NO_FILLHITTEST_TRUE = 0x110000;
    public static final int NO_FILLHITTEST_FALSE = 65536;

    public HSSFShape(EscherContainerRecord escherContainerRecord, ObjRecord objRecord) {
        this._escherContainer = escherContainerRecord;
        this._objRecord = objRecord;
        this._optRecord = (EscherOptRecord)escherContainerRecord.getChildById((short)-4085);
        this.anchor = HSSFAnchor.createAnchorFromEscher(escherContainerRecord);
    }

    public HSSFShape(HSSFShape hSSFShape, HSSFAnchor hSSFAnchor) {
        this.parent = hSSFShape;
        this.anchor = hSSFAnchor;
        this._escherContainer = this.createSpContainer();
        this._optRecord = (EscherOptRecord)this._escherContainer.getChildById((short)-4085);
        this._objRecord = this.createObjRecord();
    }

    protected abstract EscherContainerRecord createSpContainer();

    protected abstract ObjRecord createObjRecord();

    protected abstract void afterRemove(HSSFPatriarch var1);

    void setShapeId(int n) {
        EscherSpRecord escherSpRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        escherSpRecord.setShapeId(n);
        CommonObjectDataSubRecord commonObjectDataSubRecord = (CommonObjectDataSubRecord)this._objRecord.getSubRecords().get(0);
        commonObjectDataSubRecord.setObjectId((short)(n % 1024));
    }

    int getShapeId() {
        return ((EscherSpRecord)this._escherContainer.getChildById((short)-4086)).getShapeId();
    }

    abstract void afterInsert(HSSFPatriarch var1);

    protected EscherContainerRecord getEscherContainer() {
        return this._escherContainer;
    }

    protected ObjRecord getObjRecord() {
        return this._objRecord;
    }

    protected EscherOptRecord getOptRecord() {
        return this._optRecord;
    }

    public HSSFShape getParent() {
        return this.parent;
    }

    public HSSFAnchor getAnchor() {
        return this.anchor;
    }

    public void setAnchor(HSSFAnchor hSSFAnchor) {
        int n = 0;
        int n2 = -1;
        if (this.parent == null) {
            if (hSSFAnchor instanceof HSSFChildAnchor) {
                throw new IllegalArgumentException("Must use client anchors for shapes directly attached to sheet.");
            }
            EscherClientAnchorRecord escherClientAnchorRecord = (EscherClientAnchorRecord)this._escherContainer.getChildById((short)-4080);
            if (null != escherClientAnchorRecord) {
                for (n = 0; n < this._escherContainer.getChildRecords().size(); ++n) {
                    if (this._escherContainer.getChild(n).getRecordId() != -4080 || n == this._escherContainer.getChildRecords().size() - 1) continue;
                    n2 = this._escherContainer.getChild(n + 1).getRecordId();
                }
                this._escherContainer.removeChildRecord(escherClientAnchorRecord);
            }
        } else {
            if (hSSFAnchor instanceof HSSFClientAnchor) {
                throw new IllegalArgumentException("Must use child anchors for shapes attached to groups.");
            }
            EscherChildAnchorRecord escherChildAnchorRecord = (EscherChildAnchorRecord)this._escherContainer.getChildById((short)-4081);
            if (null != escherChildAnchorRecord) {
                for (n = 0; n < this._escherContainer.getChildRecords().size(); ++n) {
                    if (this._escherContainer.getChild(n).getRecordId() != -4081 || n == this._escherContainer.getChildRecords().size() - 1) continue;
                    n2 = this._escherContainer.getChild(n + 1).getRecordId();
                }
                this._escherContainer.removeChildRecord(escherChildAnchorRecord);
            }
        }
        if (-1 == n2) {
            this._escherContainer.addChildRecord(hSSFAnchor.getEscherAnchor());
        } else {
            this._escherContainer.addChildBefore(hSSFAnchor.getEscherAnchor(), n2);
        }
        this.anchor = hSSFAnchor;
    }

    public int getLineStyleColor() {
        EscherRGBProperty escherRGBProperty = (EscherRGBProperty)this._optRecord.lookup(448);
        return escherRGBProperty == null ? 0x8000040 : escherRGBProperty.getRgbColor();
    }

    public void setLineStyleColor(int n) {
        this.setPropertyValue(new EscherRGBProperty(448, n));
    }

    public void setLineStyleColor(int n, int n2, int n3) {
        int n4 = n3 << 16 | n2 << 8 | n;
        this.setPropertyValue(new EscherRGBProperty(448, n4));
    }

    public int getFillColor() {
        EscherRGBProperty escherRGBProperty = (EscherRGBProperty)this._optRecord.lookup(385);
        return escherRGBProperty == null ? 0x8000009 : escherRGBProperty.getRgbColor();
    }

    public void setFillColor(int n) {
        this.setPropertyValue(new EscherRGBProperty(385, n));
    }

    public void setFillColor(int n, int n2, int n3) {
        int n4 = n3 << 16 | n2 << 8 | n;
        this.setPropertyValue(new EscherRGBProperty(385, n4));
    }

    public int getLineWidth() {
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)this._optRecord.lookup(459);
        return escherSimpleProperty == null ? 9525 : escherSimpleProperty.getPropertyValue();
    }

    public void setLineWidth(int n) {
        this.setPropertyValue(new EscherSimpleProperty(459, n));
    }

    public int getLineStyle() {
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)this._optRecord.lookup(462);
        if (null == escherSimpleProperty) {
            return -1;
        }
        return escherSimpleProperty.getPropertyValue();
    }

    public void setLineStyle(int n) {
        this.setPropertyValue(new EscherSimpleProperty(462, n));
        if (this.getLineStyle() != 0) {
            this.setPropertyValue(new EscherSimpleProperty(471, 0));
            if (this.getLineStyle() == -1) {
                this.setPropertyValue(new EscherBoolProperty(511, 524288));
            } else {
                this.setPropertyValue(new EscherBoolProperty(511, 524296));
            }
        }
    }

    public boolean isNoFill() {
        EscherBoolProperty escherBoolProperty = (EscherBoolProperty)this._optRecord.lookup(447);
        return escherBoolProperty == null ? true : escherBoolProperty.getPropertyValue() == 0x110000;
    }

    public void setNoFill(boolean bl) {
        this.setPropertyValue(new EscherBoolProperty(447, bl ? 0x110000 : 65536));
    }

    protected void setPropertyValue(EscherProperty escherProperty) {
        this._optRecord.setEscherProperty(escherProperty);
    }

    public void setFlipVertical(boolean bl) {
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherContainer().getChildById((short)-4086);
        if (bl) {
            escherSpRecord.setFlags(escherSpRecord.getFlags() | 0x80);
        } else {
            escherSpRecord.setFlags(escherSpRecord.getFlags() & 0x7FFFFF7F);
        }
    }

    public void setFlipHorizontal(boolean bl) {
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherContainer().getChildById((short)-4086);
        if (bl) {
            escherSpRecord.setFlags(escherSpRecord.getFlags() | 0x40);
        } else {
            escherSpRecord.setFlags(escherSpRecord.getFlags() & 0x7FFFFFBF);
        }
    }

    public boolean isFlipVertical() {
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherContainer().getChildById((short)-4086);
        return (escherSpRecord.getFlags() & 0x80) != 0;
    }

    public boolean isFlipHorizontal() {
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherContainer().getChildById((short)-4086);
        return (escherSpRecord.getFlags() & 0x40) != 0;
    }

    public int getRotationDegree() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)this.getOptRecord().lookup(4);
        if (null == escherSimpleProperty) {
            return 0;
        }
        try {
            LittleEndian.putInt(escherSimpleProperty.getPropertyValue(), byteArrayOutputStream);
            return LittleEndian.getShort(byteArrayOutputStream.toByteArray(), 2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    public void setRotationDegree(short s) {
        this.setPropertyValue(new EscherSimpleProperty(4, s << 16));
    }

    public int countOfAllChildren() {
        return 1;
    }

    protected abstract HSSFShape cloneShape();

    protected void setPatriarch(HSSFPatriarch hSSFPatriarch) {
        this._patriarch = hSSFPatriarch;
    }

    public HSSFPatriarch getPatriarch() {
        return this._patriarch;
    }

    protected void setParent(HSSFShape hSSFShape) {
        this.parent = hSSFShape;
    }
}

