/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.hssf.record.CellValueRecordInterface;
import ai.org.apache.poi.hssf.record.ExtendedFormatRecord;
import ai.org.apache.poi.hssf.record.RowRecord;
import ai.org.apache.poi.hssf.usermodel.HSSFCell;
import ai.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import ai.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai.org.apache.poi.ss.SpreadsheetVersion;
import ai.org.apache.poi.ss.usermodel.Cell;
import ai.org.apache.poi.ss.usermodel.CellStyle;
import ai.org.apache.poi.ss.usermodel.Row;
import ai.org.apache.poi.util.Configurator;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSSFRow
implements Row {
    public static final int INITIAL_CAPACITY = Configurator.getIntValue("HSSFRow.ColInitialCapacity", 5);
    private int rowNum;
    private HSSFCell[] cells;
    private RowRecord row;
    private HSSFWorkbook book;
    private HSSFSheet sheet;

    HSSFRow(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n) {
        this(hSSFWorkbook, hSSFSheet, new RowRecord(n));
    }

    HSSFRow(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, RowRecord rowRecord) {
        this.book = hSSFWorkbook;
        this.sheet = hSSFSheet;
        this.row = rowRecord;
        this.setRowNum(rowRecord.getRowNumber());
        this.cells = new HSSFCell[rowRecord.getLastCol() + INITIAL_CAPACITY];
        rowRecord.setEmpty();
    }

    public HSSFCell createCell(short s) {
        return this.createCell((int)s);
    }

    public HSSFCell createCell(short s, int n) {
        return this.createCell((int)s, n);
    }

    @Override
    public HSSFCell createCell(int n) {
        return this.createCell(n, 3);
    }

    @Override
    public HSSFCell createCell(int n, int n2) {
        short s = (short)n;
        if (n > Short.MAX_VALUE) {
            s = (short)(65535 - n);
        }
        HSSFCell hSSFCell = new HSSFCell(this.book, this.sheet, this.getRowNum(), s, n2);
        this.addCell(hSSFCell);
        this.sheet.getSheet().addValueRecord(this.getRowNum(), hSSFCell.getCellValueRecord());
        return hSSFCell;
    }

    @Override
    public void removeCell(Cell cell) {
        if (cell == null) {
            throw new IllegalArgumentException("cell must not be null");
        }
        this.removeCell((HSSFCell)cell, true);
    }

    private void removeCell(HSSFCell hSSFCell, boolean bl) {
        int n = hSSFCell.getColumnIndex();
        if (n < 0) {
            throw new RuntimeException("Negative cell indexes not allowed");
        }
        if (n >= this.cells.length || hSSFCell != this.cells[n]) {
            throw new RuntimeException("Specified cell is not from this row");
        }
        if (hSSFCell.isPartOfArrayFormulaGroup()) {
            hSSFCell.notifyArrayFormulaChanging();
        }
        this.cells[n] = null;
        if (bl) {
            CellValueRecordInterface cellValueRecordInterface = hSSFCell.getCellValueRecord();
            this.sheet.getSheet().removeValueRecord(this.getRowNum(), cellValueRecordInterface);
        }
        if (hSSFCell.getColumnIndex() + 1 == this.row.getLastCol()) {
            this.row.setLastCol(this.calculateNewLastCellPlusOne(this.row.getLastCol()));
        }
        if (hSSFCell.getColumnIndex() == this.row.getFirstCol()) {
            this.row.setFirstCol(this.calculateNewFirstCell(this.row.getFirstCol()));
        }
    }

    protected void removeAllCells() {
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            this.removeCell(this.cells[i], true);
        }
        this.cells = new HSSFCell[INITIAL_CAPACITY];
    }

    HSSFCell createCellFromRecord(CellValueRecordInterface cellValueRecordInterface) {
        HSSFCell hSSFCell = new HSSFCell(this.book, this.sheet, cellValueRecordInterface);
        this.addCell(hSSFCell);
        short s = cellValueRecordInterface.getColumn();
        if (this.row.isEmpty()) {
            this.row.setFirstCol(s);
            this.row.setLastCol(s + 1);
        } else if (s < this.row.getFirstCol()) {
            this.row.setFirstCol(s);
        } else if (s > this.row.getLastCol()) {
            this.row.setLastCol(s + 1);
        }
        return hSSFCell;
    }

    @Override
    public void setRowNum(int n) {
        int n2 = SpreadsheetVersion.EXCEL97.getLastRowIndex();
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("Invalid row number (" + n + ") outside allowable range (0.." + n2 + ")");
        }
        this.rowNum = n;
        if (this.row != null) {
            this.row.setRowNumber(n);
        }
    }

    @Override
    public int getRowNum() {
        return this.rowNum;
    }

    @Override
    public HSSFSheet getSheet() {
        return this.sheet;
    }

    protected int getOutlineLevel() {
        return this.row.getOutlineLevel();
    }

    public void moveCell(HSSFCell hSSFCell, short s) {
        if (this.cells.length > s && this.cells[s] != null) {
            throw new IllegalArgumentException("Asked to move cell to column " + s + " but there's already a cell there");
        }
        if (!this.cells[hSSFCell.getColumnIndex()].equals(hSSFCell)) {
            throw new IllegalArgumentException("Asked to move a cell, but it didn't belong to our row");
        }
        this.removeCell(hSSFCell, false);
        hSSFCell.updateCellNum(s);
        this.addCell(hSSFCell);
    }

    private void addCell(HSSFCell hSSFCell) {
        int n = hSSFCell.getColumnIndex();
        if (n >= this.cells.length) {
            HSSFCell[] hSSFCellArray = this.cells;
            int n2 = hSSFCellArray.length * 3 / 2 + 1;
            if (n2 < n + 1) {
                n2 = n + INITIAL_CAPACITY;
            }
            this.cells = new HSSFCell[n2];
            System.arraycopy(hSSFCellArray, 0, this.cells, 0, hSSFCellArray.length);
        }
        this.cells[n] = hSSFCell;
        if (this.row.isEmpty() || n < this.row.getFirstCol()) {
            this.row.setFirstCol((short)n);
        }
        if (this.row.isEmpty() || n >= this.row.getLastCol()) {
            this.row.setLastCol((short)(n + 1));
        }
    }

    private HSSFCell retrieveCell(int n) {
        if (n < 0 || n >= this.cells.length) {
            return null;
        }
        return this.cells[n];
    }

    public HSSFCell getCell(short s) {
        int n = s & 0xFFFF;
        return this.getCell(n);
    }

    @Override
    public HSSFCell getCell(int n) {
        return this.getCell(n, this.book.getMissingCellPolicy());
    }

    @Override
    public HSSFCell getCell(int n, Row.MissingCellPolicy missingCellPolicy) {
        HSSFCell hSSFCell = this.retrieveCell(n);
        if (missingCellPolicy == RETURN_NULL_AND_BLANK) {
            return hSSFCell;
        }
        if (missingCellPolicy == RETURN_BLANK_AS_NULL) {
            if (hSSFCell == null) {
                return hSSFCell;
            }
            if (hSSFCell.getCellType() == 3) {
                return null;
            }
            return hSSFCell;
        }
        if (missingCellPolicy == CREATE_NULL_AS_BLANK) {
            if (hSSFCell == null) {
                return this.createCell(n, 3);
            }
            return hSSFCell;
        }
        throw new IllegalArgumentException("Illegal policy " + missingCellPolicy + " (" + missingCellPolicy.id + ")");
    }

    @Override
    public short getFirstCellNum() {
        if (this.row.isEmpty()) {
            return -1;
        }
        return (short)this.row.getFirstCol();
    }

    @Override
    public short getLastCellNum() {
        if (this.row.isEmpty()) {
            return -1;
        }
        return (short)this.row.getLastCol();
    }

    @Override
    public int getPhysicalNumberOfCells() {
        int n = 0;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void setHeight(short s) {
        if (s == -1) {
            this.row.setHeight((short)-32513);
            this.row.setBadFontHeight(false);
        } else {
            this.row.setBadFontHeight(true);
            this.row.setHeight(s);
        }
    }

    @Override
    public void setZeroHeight(boolean bl) {
        this.row.setZeroHeight(bl);
    }

    @Override
    public boolean getZeroHeight() {
        return this.row.getZeroHeight();
    }

    @Override
    public void setHeightInPoints(float f) {
        if (f == -1.0f) {
            this.row.setHeight((short)-32513);
        } else {
            this.row.setBadFontHeight(true);
            this.row.setHeight((short)(f * 20.0f));
        }
    }

    @Override
    public short getHeight() {
        short s = this.row.getHeight();
        s = (s & 0x8000) != 0 ? this.sheet.getSheet().getDefaultRowHeight() : (short)(s & Short.MAX_VALUE);
        return s;
    }

    @Override
    public float getHeightInPoints() {
        return (float)this.getHeight() / 20.0f;
    }

    protected RowRecord getRowRecord() {
        return this.row;
    }

    private int calculateNewLastCellPlusOne(int n) {
        int n2 = n - 1;
        HSSFCell hSSFCell = this.retrieveCell(n2);
        while (hSSFCell == null) {
            if (n2 < 0) {
                return 0;
            }
            hSSFCell = this.retrieveCell(--n2);
        }
        return n2 + 1;
    }

    private int calculateNewFirstCell(int n) {
        int n2 = n + 1;
        HSSFCell hSSFCell = this.retrieveCell(n2);
        while (hSSFCell == null) {
            if (n2 <= this.cells.length) {
                return 0;
            }
            hSSFCell = this.retrieveCell(++n2);
        }
        return n2;
    }

    @Override
    public boolean isFormatted() {
        return this.row.getFormatted();
    }

    @Override
    public HSSFCellStyle getRowStyle() {
        if (!this.isFormatted()) {
            return null;
        }
        short s = this.row.getXFIndex();
        ExtendedFormatRecord extendedFormatRecord = this.book.getWorkbook().getExFormatAt(s);
        return new HSSFCellStyle(s, extendedFormatRecord, this.book);
    }

    public void setRowStyle(HSSFCellStyle hSSFCellStyle) {
        this.row.setFormatted(true);
        this.row.setXFIndex(hSSFCellStyle.getIndex());
    }

    @Override
    public void setRowStyle(CellStyle cellStyle) {
        this.setRowStyle((HSSFCellStyle)cellStyle);
    }

    @Override
    public Iterator<Cell> cellIterator() {
        return new CellIterator();
    }

    @Override
    public Iterator iterator() {
        return this.cellIterator();
    }

    public int compareTo(Object object) {
        HSSFRow hSSFRow = (HSSFRow)object;
        if (this.getRowNum() == hSSFRow.getRowNum()) {
            return 0;
        }
        if (this.getRowNum() < hSSFRow.getRowNum()) {
            return -1;
        }
        if (this.getRowNum() > hSSFRow.getRowNum()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HSSFRow)) {
            return false;
        }
        HSSFRow hSSFRow = (HSSFRow)object;
        return this.getRowNum() == hSSFRow.getRowNum();
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CellIterator
    implements Iterator<Cell> {
        int thisId = -1;
        int nextId = -1;

        public CellIterator() {
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextId < HSSFRow.this.cells.length;
        }

        @Override
        public Cell next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            HSSFCell hSSFCell = HSSFRow.this.cells[this.nextId];
            this.thisId = this.nextId;
            this.findNext();
            return hSSFCell;
        }

        @Override
        public void remove() {
            if (this.thisId == -1) {
                throw new IllegalStateException("remove() called before next()");
            }
            ((HSSFRow)HSSFRow.this).cells[this.thisId] = null;
        }

        private void findNext() {
            int n;
            for (n = this.nextId + 1; n < HSSFRow.this.cells.length && HSSFRow.this.cells[n] == null; ++n) {
            }
            this.nextId = n;
        }
    }
}

