/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai.org.apache.poi.ddf.EscherBSERecord;
import ai.org.apache.poi.ddf.EscherBlipRecord;
import ai.org.apache.poi.ddf.EscherComplexProperty;
import ai.org.apache.poi.ddf.EscherContainerRecord;
import ai.org.apache.poi.ddf.EscherOptRecord;
import ai.org.apache.poi.ddf.EscherRecord;
import ai.org.apache.poi.ddf.EscherSimpleProperty;
import ai.org.apache.poi.hssf.model.InternalWorkbook;
import ai.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import ai.org.apache.poi.hssf.record.EscherAggregate;
import ai.org.apache.poi.hssf.record.ObjRecord;
import ai.org.apache.poi.hssf.usermodel.HSSFAnchor;
import ai.org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import ai.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import ai.org.apache.poi.hssf.usermodel.HSSFPictureData;
import ai.org.apache.poi.hssf.usermodel.HSSFShape;
import ai.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai.org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import ai.org.apache.poi.ss.usermodel.Picture;
import ai.org.apache.poi.ss.util.ImageUtils;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class HSSFPicture
extends HSSFSimpleShape
implements Picture {
    private static POILogger logger = POILogFactory.getLogger(HSSFPicture.class);
    public static final int PICTURE_TYPE_EMF = 2;
    public static final int PICTURE_TYPE_WMF = 3;
    public static final int PICTURE_TYPE_PICT = 4;
    public static final int PICTURE_TYPE_JPEG = 5;
    public static final int PICTURE_TYPE_PNG = 6;
    public static final int PICTURE_TYPE_DIB = 7;

    public HSSFPicture(EscherContainerRecord escherContainerRecord, ObjRecord objRecord) {
        super(escherContainerRecord, objRecord);
    }

    public HSSFPicture(HSSFShape hSSFShape, HSSFAnchor hSSFAnchor) {
        super(hSSFShape, hSSFAnchor);
        super.setShapeType(75);
        CommonObjectDataSubRecord commonObjectDataSubRecord = (CommonObjectDataSubRecord)this.getObjRecord().getSubRecords().get(0);
        commonObjectDataSubRecord.setObjectType((short)8);
    }

    public int getPictureIndex() {
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)this.getOptRecord().lookup(260);
        if (null == escherSimpleProperty) {
            return -1;
        }
        return escherSimpleProperty.getPropertyValue();
    }

    public void setPictureIndex(int n) {
        this.setPropertyValue(new EscherSimpleProperty(260, false, true, n));
    }

    protected EscherContainerRecord createSpContainer() {
        EscherContainerRecord escherContainerRecord = super.createSpContainer();
        EscherOptRecord escherOptRecord = (EscherOptRecord)escherContainerRecord.getChildById((short)-4085);
        escherOptRecord.removeEscherProperty(462);
        escherOptRecord.removeEscherProperty(511);
        escherContainerRecord.removeChildRecord((EscherRecord)escherContainerRecord.getChildById((short)-4083));
        return escherContainerRecord;
    }

    public void resize() {
        this.resize(Double.MAX_VALUE);
    }

    public void resize(double d) {
        this.resize(d, d);
    }

    public void resize(double d, double d2) {
        HSSFClientAnchor hSSFClientAnchor = this.getClientAnchor();
        hSSFClientAnchor.setAnchorType(2);
        HSSFClientAnchor hSSFClientAnchor2 = this.getPreferredSize(d, d2);
        int n = hSSFClientAnchor.getRow1() + (hSSFClientAnchor2.getRow2() - hSSFClientAnchor2.getRow1());
        int n2 = hSSFClientAnchor.getCol1() + (hSSFClientAnchor2.getCol2() - hSSFClientAnchor2.getCol1());
        hSSFClientAnchor.setCol2((short)n2);
        hSSFClientAnchor.setDx2(hSSFClientAnchor2.getDx2());
        hSSFClientAnchor.setRow2(n);
        hSSFClientAnchor.setDy2(hSSFClientAnchor2.getDy2());
    }

    public HSSFClientAnchor getPreferredSize() {
        return this.getPreferredSize(1.0);
    }

    public HSSFClientAnchor getPreferredSize(double d) {
        return this.getPreferredSize(d, d);
    }

    public HSSFClientAnchor getPreferredSize(double d, double d2) {
        ImageUtils.setPreferredSize(this, d, d2);
        return this.getClientAnchor();
    }

    public Dimension getImageDimension() {
        InternalWorkbook internalWorkbook = this.getPatriarch().getSheet().getWorkbook().getWorkbook();
        EscherBSERecord escherBSERecord = internalWorkbook.getBSERecord(this.getPictureIndex());
        byte[] byArray = escherBSERecord.getBlipRecord().getPicturedata();
        byte by = escherBSERecord.getBlipTypeWin32();
        return ImageUtils.getImageDimension(new ByteArrayInputStream(byArray), by);
    }

    public HSSFPictureData getPictureData() {
        InternalWorkbook internalWorkbook = this.getPatriarch().getSheet().getWorkbook().getWorkbook();
        EscherBSERecord escherBSERecord = internalWorkbook.getBSERecord(this.getPictureIndex());
        EscherBlipRecord escherBlipRecord = escherBSERecord.getBlipRecord();
        return new HSSFPictureData(escherBlipRecord);
    }

    void afterInsert(HSSFPatriarch hSSFPatriarch) {
        EscherAggregate escherAggregate = hSSFPatriarch._getBoundAggregate();
        escherAggregate.associateShapeToObjRecord((EscherRecord)this.getEscherContainer().getChildById((short)-4079), this.getObjRecord());
        EscherBSERecord escherBSERecord = hSSFPatriarch.getSheet().getWorkbook().getWorkbook().getBSERecord(this.getPictureIndex());
        escherBSERecord.setRef(escherBSERecord.getRef() + 1);
    }

    public String getFileName() {
        EscherComplexProperty escherComplexProperty = (EscherComplexProperty)this.getOptRecord().lookup(261);
        return null == escherComplexProperty ? "" : new String(escherComplexProperty.getComplexData(), Charset.forName("UTF-16LE")).trim();
    }

    public void setFileName(String string) {
        try {
            EscherComplexProperty escherComplexProperty = new EscherComplexProperty(261, true, string.getBytes("UTF-16LE"));
            this.setPropertyValue(escherComplexProperty);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.log(7, "Unsupported encoding: UTF-16LE");
        }
    }

    public void setShapeType(int n) {
        throw new IllegalStateException("Shape type can not be changed in " + this.getClass().getSimpleName());
    }

    protected HSSFShape cloneShape() {
        EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
        byte[] byArray = this.getEscherContainer().serialize();
        escherContainerRecord.fillFields(byArray, 0, new DefaultEscherRecordFactory());
        ObjRecord objRecord = (ObjRecord)this.getObjRecord().cloneViaReserialise();
        return new HSSFPicture(escherContainerRecord, objRecord);
    }

    public HSSFClientAnchor getClientAnchor() {
        HSSFAnchor hSSFAnchor = this.getAnchor();
        return hSSFAnchor instanceof HSSFClientAnchor ? (HSSFClientAnchor)hSSFAnchor : null;
    }

    public HSSFSheet getSheet() {
        return this.getPatriarch().getSheet();
    }
}

