/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.hssf.record.PaletteRecord;
import ai.org.apache.poi.hssf.util.HSSFColor;

public final class HSSFPalette {
    private PaletteRecord _palette;

    protected HSSFPalette(PaletteRecord paletteRecord) {
        this._palette = paletteRecord;
    }

    public HSSFColor getColor(short s) {
        if (s == 64) {
            return HSSFColor.AUTOMATIC.getInstance();
        }
        byte[] byArray = this._palette.getColor(s);
        if (byArray != null) {
            return new CustomColor(s, byArray);
        }
        return null;
    }

    public HSSFColor getColor(int n) {
        return this.getColor((short)n);
    }

    public HSSFColor findColor(byte by, byte by2, byte by3) {
        byte[] byArray = this._palette.getColor(8);
        short s = 8;
        while (byArray != null) {
            if (byArray[0] == by && byArray[1] == by2 && byArray[2] == by3) {
                return new CustomColor(s, byArray);
            }
            s = (short)(s + 1);
            byArray = this._palette.getColor(s);
        }
        return null;
    }

    public HSSFColor findSimilarColor(byte by, byte by2, byte by3) {
        return this.findSimilarColor(this.unsignedInt(by), this.unsignedInt(by2), this.unsignedInt(by3));
    }

    public HSSFColor findSimilarColor(int n, int n2, int n3) {
        HSSFColor hSSFColor = null;
        int n4 = Integer.MAX_VALUE;
        byte[] byArray = this._palette.getColor(8);
        short s = 8;
        while (byArray != null) {
            int n5 = Math.abs(n - this.unsignedInt(byArray[0])) + Math.abs(n2 - this.unsignedInt(byArray[1])) + Math.abs(n3 - this.unsignedInt(byArray[2]));
            if (n5 < n4) {
                n4 = n5;
                hSSFColor = this.getColor(s);
            }
            s = (short)(s + 1);
            byArray = this._palette.getColor(s);
        }
        return hSSFColor;
    }

    private int unsignedInt(byte by) {
        return 0xFF & by;
    }

    public void setColorAtIndex(short s, byte by, byte by2, byte by3) {
        this._palette.setColor(s, by, by2, by3);
    }

    public HSSFColor addColor(byte by, byte by2, byte by3) {
        byte[] byArray = this._palette.getColor(8);
        for (short s = 8; s < 64; s = (short)(s + 1)) {
            if (byArray == null) {
                this.setColorAtIndex(s, by, by2, by3);
                return this.getColor(s);
            }
            byArray = this._palette.getColor(s);
        }
        throw new RuntimeException("Could not find free color index");
    }

    private static final class CustomColor
    extends HSSFColor {
        private short _byteOffset;
        private byte _red;
        private byte _green;
        private byte _blue;

        public CustomColor(short s, byte[] byArray) {
            this(s, byArray[0], byArray[1], byArray[2]);
        }

        private CustomColor(short s, byte by, byte by2, byte by3) {
            this._byteOffset = s;
            this._red = by;
            this._green = by2;
            this._blue = by3;
        }

        public short getIndex() {
            return this._byteOffset;
        }

        public short[] getTriplet() {
            return new short[]{(short)(this._red & 0xFF), (short)(this._green & 0xFF), (short)(this._blue & 0xFF)};
        }

        public String getHexString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getGnumericPart(this._red));
            stringBuffer.append(':');
            stringBuffer.append(this.getGnumericPart(this._green));
            stringBuffer.append(':');
            stringBuffer.append(this.getGnumericPart(this._blue));
            return stringBuffer.toString();
        }

        private String getGnumericPart(byte by) {
            String string;
            if (by == 0) {
                string = "0";
            } else {
                int n = by & 0xFF;
                n = n << 8 | n;
                string = Integer.toHexString(n).toUpperCase();
                while (string.length() < 4) {
                    string = "0" + string;
                }
            }
            return string;
        }
    }
}

