/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.hssf.model.HSSFFormulaParser;
import ai.org.apache.poi.hssf.model.InternalWorkbook;
import ai.org.apache.poi.hssf.record.NameCommentRecord;
import ai.org.apache.poi.hssf.record.NameRecord;
import ai.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import ai.org.apache.poi.ss.usermodel.Name;

public final class HSSFName
implements Name {
    private HSSFWorkbook _book;
    private NameRecord _definedNameRec;
    private NameCommentRecord _commentRec;

    HSSFName(HSSFWorkbook hSSFWorkbook, NameRecord nameRecord) {
        this(hSSFWorkbook, nameRecord, null);
    }

    HSSFName(HSSFWorkbook hSSFWorkbook, NameRecord nameRecord, NameCommentRecord nameCommentRecord) {
        this._book = hSSFWorkbook;
        this._definedNameRec = nameRecord;
        this._commentRec = nameCommentRecord;
    }

    public String getSheetName() {
        int n = this._definedNameRec.getExternSheetNumber();
        return this._book.getWorkbook().findSheetFirstNameFromExternSheet(n);
    }

    public String getNameName() {
        return this._definedNameRec.getNameText();
    }

    public void setNameName(String string) {
        HSSFName.validateName(string);
        InternalWorkbook internalWorkbook = this._book.getWorkbook();
        this._definedNameRec.setNameText(string);
        int n = this._definedNameRec.getSheetNumber();
        for (int i = internalWorkbook.getNumNames() - 1; i >= 0; --i) {
            NameRecord nameRecord = internalWorkbook.getNameRecord(i);
            if (nameRecord == this._definedNameRec || !nameRecord.getNameText().equalsIgnoreCase(string) || n != nameRecord.getSheetNumber()) continue;
            String string2 = "The " + (n == 0 ? "workbook" : "sheet") + " already contains this name: " + string;
            this._definedNameRec.setNameText(string + "(2)");
            throw new IllegalArgumentException(string2);
        }
        if (this._commentRec != null) {
            String string3 = this._commentRec.getNameText();
            this._commentRec.setNameText(string);
            this._book.getWorkbook().updateNameCommentRecordCache(this._commentRec);
        }
    }

    private static void validateName(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException("Name cannot be blank");
        }
        char c = string.charAt(0);
        if (c != '_' && !Character.isLetter(c) || string.indexOf(32) != -1) {
            throw new IllegalArgumentException("Invalid name: '" + string + "'; Names must begin with a letter or underscore and not contain spaces");
        }
    }

    public String getReference() {
        return this.getRefersToFormula();
    }

    public void setReference(String string) {
        this.setRefersToFormula(string);
    }

    public void setRefersToFormula(String string) {
        Ptg[] ptgArray = HSSFFormulaParser.parse(string, this._book, 4, this.getSheetIndex());
        this._definedNameRec.setNameDefinition(ptgArray);
    }

    public String getRefersToFormula() {
        if (this._definedNameRec.isFunctionName()) {
            throw new IllegalStateException("Only applicable to named ranges");
        }
        Ptg[] ptgArray = this._definedNameRec.getNameDefinition();
        if (ptgArray.length < 1) {
            return null;
        }
        return HSSFFormulaParser.toFormulaString(this._book, ptgArray);
    }

    void setNameDefinition(Ptg[] ptgArray) {
        this._definedNameRec.setNameDefinition(ptgArray);
    }

    public boolean isDeleted() {
        Ptg[] ptgArray = this._definedNameRec.getNameDefinition();
        return Ptg.doesFormulaReferToDeletedCell(ptgArray);
    }

    public boolean isFunctionName() {
        return this._definedNameRec.isFunctionName();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(this._definedNameRec.getNameText());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void setSheetIndex(int n) {
        int n2 = this._book.getNumberOfSheets() - 1;
        if (n < -1 || n > n2) {
            throw new IllegalArgumentException("Sheet index (" + n + ") is out of range" + (n2 == -1 ? "" : " (0.." + n2 + ")"));
        }
        this._definedNameRec.setSheetNumber(n + 1);
    }

    public int getSheetIndex() {
        return this._definedNameRec.getSheetNumber() - 1;
    }

    public String getComment() {
        if (this._commentRec != null && this._commentRec.getCommentText() != null && this._commentRec.getCommentText().length() > 0) {
            return this._commentRec.getCommentText();
        }
        return this._definedNameRec.getDescriptionText();
    }

    public void setComment(String string) {
        this._definedNameRec.setDescriptionText(string);
        if (this._commentRec != null) {
            this._commentRec.setCommentText(string);
        }
    }

    public void setFunction(boolean bl) {
        this._definedNameRec.setFunction(bl);
    }
}

