/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.hssf.record.DVRecord;
import ai.org.apache.poi.hssf.usermodel.DVConstraint;
import ai.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai.org.apache.poi.ss.usermodel.DataValidation;
import ai.org.apache.poi.ss.usermodel.DataValidationConstraint;
import ai.org.apache.poi.ss.util.CellRangeAddressList;

public final class HSSFDataValidation
implements DataValidation {
    private String _prompt_title;
    private String _prompt_text;
    private String _error_title;
    private String _error_text;
    private int _errorStyle = 0;
    private boolean _emptyCellAllowed = true;
    private boolean _suppress_dropdown_arrow = false;
    private boolean _showPromptBox = true;
    private boolean _showErrorBox = true;
    private CellRangeAddressList _regions;
    private DVConstraint _constraint;

    public HSSFDataValidation(CellRangeAddressList cellRangeAddressList, DataValidationConstraint dataValidationConstraint) {
        this._regions = cellRangeAddressList;
        this._constraint = (DVConstraint)dataValidationConstraint;
    }

    public DataValidationConstraint getValidationConstraint() {
        return this._constraint;
    }

    public DVConstraint getConstraint() {
        return this._constraint;
    }

    public CellRangeAddressList getRegions() {
        return this._regions;
    }

    public void setErrorStyle(int n) {
        this._errorStyle = n;
    }

    public int getErrorStyle() {
        return this._errorStyle;
    }

    public void setEmptyCellAllowed(boolean bl) {
        this._emptyCellAllowed = bl;
    }

    public boolean getEmptyCellAllowed() {
        return this._emptyCellAllowed;
    }

    public void setSuppressDropDownArrow(boolean bl) {
        this._suppress_dropdown_arrow = bl;
    }

    public boolean getSuppressDropDownArrow() {
        if (this._constraint.getValidationType() == 3) {
            return this._suppress_dropdown_arrow;
        }
        return false;
    }

    public void setShowPromptBox(boolean bl) {
        this._showPromptBox = bl;
    }

    public boolean getShowPromptBox() {
        return this._showPromptBox;
    }

    public void setShowErrorBox(boolean bl) {
        this._showErrorBox = bl;
    }

    public boolean getShowErrorBox() {
        return this._showErrorBox;
    }

    public void createPromptBox(String string, String string2) {
        this._prompt_title = string;
        this._prompt_text = string2;
        this.setShowPromptBox(true);
    }

    public String getPromptBoxTitle() {
        return this._prompt_title;
    }

    public String getPromptBoxText() {
        return this._prompt_text;
    }

    public void createErrorBox(String string, String string2) {
        this._error_title = string;
        this._error_text = string2;
        this.setShowErrorBox(true);
    }

    public String getErrorBoxTitle() {
        return this._error_title;
    }

    public String getErrorBoxText() {
        return this._error_text;
    }

    public DVRecord createDVRecord(HSSFSheet hSSFSheet) {
        DVConstraint.FormulaPair formulaPair = this._constraint.createFormulas(hSSFSheet);
        return new DVRecord(this._constraint.getValidationType(), this._constraint.getOperator(), this._errorStyle, this._emptyCellAllowed, this.getSuppressDropDownArrow(), this._constraint.getValidationType() == 3 && this._constraint.getExplicitListValues() != null, this._showPromptBox, this._prompt_title, this._prompt_text, this._showErrorBox, this._error_title, this._error_text, formulaPair.getFormula1(), formulaPair.getFormula2(), this._regions);
    }
}

