/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.hssf.model.HSSFFormulaParser;
import ai.org.apache.poi.hssf.record.CFRuleRecord;
import ai.org.apache.poi.hssf.record.cf.BorderFormatting;
import ai.org.apache.poi.hssf.record.cf.FontFormatting;
import ai.org.apache.poi.hssf.record.cf.PatternFormatting;
import ai.org.apache.poi.hssf.usermodel.HSSFBorderFormatting;
import ai.org.apache.poi.hssf.usermodel.HSSFFontFormatting;
import ai.org.apache.poi.hssf.usermodel.HSSFPatternFormatting;
import ai.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import ai.org.apache.poi.ss.usermodel.ConditionalFormattingRule;

public final class HSSFConditionalFormattingRule
implements ConditionalFormattingRule {
    private static final byte CELL_COMPARISON = 1;
    private final CFRuleRecord cfRuleRecord;
    private final HSSFWorkbook workbook;

    HSSFConditionalFormattingRule(HSSFWorkbook hSSFWorkbook, CFRuleRecord cFRuleRecord) {
        if (hSSFWorkbook == null) {
            throw new IllegalArgumentException("pWorkbook must not be null");
        }
        if (cFRuleRecord == null) {
            throw new IllegalArgumentException("pRuleRecord must not be null");
        }
        this.workbook = hSSFWorkbook;
        this.cfRuleRecord = cFRuleRecord;
    }

    CFRuleRecord getCfRuleRecord() {
        return this.cfRuleRecord;
    }

    private HSSFFontFormatting getFontFormatting(boolean bl) {
        FontFormatting fontFormatting = this.cfRuleRecord.getFontFormatting();
        if (fontFormatting != null) {
            this.cfRuleRecord.setFontFormatting(fontFormatting);
            return new HSSFFontFormatting(this.cfRuleRecord);
        }
        if (bl) {
            fontFormatting = new FontFormatting();
            this.cfRuleRecord.setFontFormatting(fontFormatting);
            return new HSSFFontFormatting(this.cfRuleRecord);
        }
        return null;
    }

    public HSSFFontFormatting getFontFormatting() {
        return this.getFontFormatting(false);
    }

    public HSSFFontFormatting createFontFormatting() {
        return this.getFontFormatting(true);
    }

    private HSSFBorderFormatting getBorderFormatting(boolean bl) {
        BorderFormatting borderFormatting = this.cfRuleRecord.getBorderFormatting();
        if (borderFormatting != null) {
            this.cfRuleRecord.setBorderFormatting(borderFormatting);
            return new HSSFBorderFormatting(this.cfRuleRecord);
        }
        if (bl) {
            borderFormatting = new BorderFormatting();
            this.cfRuleRecord.setBorderFormatting(borderFormatting);
            return new HSSFBorderFormatting(this.cfRuleRecord);
        }
        return null;
    }

    public HSSFBorderFormatting getBorderFormatting() {
        return this.getBorderFormatting(false);
    }

    public HSSFBorderFormatting createBorderFormatting() {
        return this.getBorderFormatting(true);
    }

    private HSSFPatternFormatting getPatternFormatting(boolean bl) {
        PatternFormatting patternFormatting = this.cfRuleRecord.getPatternFormatting();
        if (patternFormatting != null) {
            this.cfRuleRecord.setPatternFormatting(patternFormatting);
            return new HSSFPatternFormatting(this.cfRuleRecord);
        }
        if (bl) {
            patternFormatting = new PatternFormatting();
            this.cfRuleRecord.setPatternFormatting(patternFormatting);
            return new HSSFPatternFormatting(this.cfRuleRecord);
        }
        return null;
    }

    public HSSFPatternFormatting getPatternFormatting() {
        return this.getPatternFormatting(false);
    }

    public HSSFPatternFormatting createPatternFormatting() {
        return this.getPatternFormatting(true);
    }

    public byte getConditionType() {
        return this.cfRuleRecord.getConditionType();
    }

    public byte getComparisonOperation() {
        return this.cfRuleRecord.getComparisonOperation();
    }

    public String getFormula1() {
        return this.toFormulaString(this.cfRuleRecord.getParsedExpression1());
    }

    public String getFormula2() {
        byte by = this.cfRuleRecord.getConditionType();
        if (by == 1) {
            byte by2 = this.cfRuleRecord.getComparisonOperation();
            switch (by2) {
                case 1: 
                case 2: {
                    return this.toFormulaString(this.cfRuleRecord.getParsedExpression2());
                }
            }
        }
        return null;
    }

    private String toFormulaString(Ptg[] ptgArray) {
        if (ptgArray == null) {
            return null;
        }
        return HSSFFormulaParser.toFormulaString(this.workbook, ptgArray);
    }
}

