/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.hssf.record.CFRuleRecord;
import ai.org.apache.poi.hssf.record.aggregates.CFRecordsAggregate;
import ai.org.apache.poi.hssf.usermodel.HSSFConditionalFormattingRule;
import ai.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai.org.apache.poi.ss.usermodel.ConditionalFormatting;
import ai.org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import ai.org.apache.poi.ss.util.CellRangeAddress;
import ai.org.apache.poi.ss.util.Region;

public final class HSSFConditionalFormatting
implements ConditionalFormatting {
    private final HSSFWorkbook _workbook;
    private final CFRecordsAggregate cfAggregate;

    HSSFConditionalFormatting(HSSFWorkbook hSSFWorkbook, CFRecordsAggregate cFRecordsAggregate) {
        if (hSSFWorkbook == null) {
            throw new IllegalArgumentException("workbook must not be null");
        }
        if (cFRecordsAggregate == null) {
            throw new IllegalArgumentException("cfAggregate must not be null");
        }
        this._workbook = hSSFWorkbook;
        this.cfAggregate = cFRecordsAggregate;
    }

    CFRecordsAggregate getCFRecordsAggregate() {
        return this.cfAggregate;
    }

    public Region[] getFormattingRegions() {
        CellRangeAddress[] cellRangeAddressArray = this.getFormattingRanges();
        return Region.convertCellRangesToRegions(cellRangeAddressArray);
    }

    public CellRangeAddress[] getFormattingRanges() {
        return this.cfAggregate.getHeader().getCellRanges();
    }

    public void setRule(int n, HSSFConditionalFormattingRule hSSFConditionalFormattingRule) {
        this.cfAggregate.setRule(n, hSSFConditionalFormattingRule.getCfRuleRecord());
    }

    public void setRule(int n, ConditionalFormattingRule conditionalFormattingRule) {
        this.setRule(n, (HSSFConditionalFormattingRule)conditionalFormattingRule);
    }

    public void addRule(HSSFConditionalFormattingRule hSSFConditionalFormattingRule) {
        this.cfAggregate.addRule(hSSFConditionalFormattingRule.getCfRuleRecord());
    }

    public void addRule(ConditionalFormattingRule conditionalFormattingRule) {
        this.addRule((HSSFConditionalFormattingRule)conditionalFormattingRule);
    }

    public HSSFConditionalFormattingRule getRule(int n) {
        CFRuleRecord cFRuleRecord = this.cfAggregate.getRule(n);
        return new HSSFConditionalFormattingRule(this._workbook, cFRuleRecord);
    }

    public int getNumberOfRules() {
        return this.cfAggregate.getNumberOfRules();
    }

    public String toString() {
        return this.cfAggregate.toString();
    }
}

