/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.ddf.EscherClientAnchorRecord;
import ai.org.apache.poi.ddf.EscherRecord;
import ai.org.apache.poi.hssf.usermodel.HSSFAnchor;
import ai.org.apache.poi.hssf.usermodel.HSSFRow;
import ai.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai.org.apache.poi.ss.usermodel.ClientAnchor;

public final class HSSFClientAnchor
extends HSSFAnchor
implements ClientAnchor {
    private EscherClientAnchorRecord _escherClientAnchor;

    public HSSFClientAnchor(EscherClientAnchorRecord escherClientAnchorRecord) {
        this._escherClientAnchor = escherClientAnchorRecord;
    }

    public HSSFClientAnchor() {
    }

    public HSSFClientAnchor(int n, int n2, int n3, int n4, short s, int n5, short s2, int n6) {
        super(n, n2, n3, n4);
        this.checkRange(n, 0, 1023, "dx1");
        this.checkRange(n3, 0, 1023, "dx2");
        this.checkRange(n2, 0, 255, "dy1");
        this.checkRange(n4, 0, 255, "dy2");
        this.checkRange(s, 0, 255, "col1");
        this.checkRange(s2, 0, 255, "col2");
        this.checkRange(n5, 0, 65280, "row1");
        this.checkRange(n6, 0, 65280, "row2");
        this.setCol1((short)Math.min(s, s2));
        this.setCol2((short)Math.max(s, s2));
        this.setRow1((short)Math.min(n5, n6));
        this.setRow2((short)Math.max(n5, n6));
        if (s > s2) {
            this._isHorizontallyFlipped = true;
        }
        if (n5 > n6) {
            this._isVerticallyFlipped = true;
        }
    }

    public float getAnchorHeightInPoints(HSSFSheet hSSFSheet) {
        int n = this.getDy1();
        int n2 = this.getDy2();
        int n3 = Math.min(this.getRow1(), this.getRow2());
        int n4 = Math.max(this.getRow1(), this.getRow2());
        float f = 0.0f;
        if (n3 == n4) {
            f = (float)(n2 - n) / 256.0f * this.getRowHeightInPoints(hSSFSheet, n4);
        } else {
            f += (256.0f - (float)n) / 256.0f * this.getRowHeightInPoints(hSSFSheet, n3);
            for (int i = n3 + 1; i < n4; ++i) {
                f += this.getRowHeightInPoints(hSSFSheet, i);
            }
            f += (float)n2 / 256.0f * this.getRowHeightInPoints(hSSFSheet, n4);
        }
        return f;
    }

    private float getRowHeightInPoints(HSSFSheet hSSFSheet, int n) {
        HSSFRow hSSFRow = hSSFSheet.getRow(n);
        if (hSSFRow == null) {
            return hSSFSheet.getDefaultRowHeightInPoints();
        }
        return hSSFRow.getHeightInPoints();
    }

    public short getCol1() {
        return this._escherClientAnchor.getCol1();
    }

    public void setCol1(short s) {
        this.checkRange(s, 0, 255, "col1");
        this._escherClientAnchor.setCol1(s);
    }

    public void setCol1(int n) {
        this.setCol1((short)n);
    }

    public short getCol2() {
        return this._escherClientAnchor.getCol2();
    }

    public void setCol2(short s) {
        this.checkRange(s, 0, 255, "col2");
        this._escherClientAnchor.setCol2(s);
    }

    public void setCol2(int n) {
        this.setCol2((short)n);
    }

    public int getRow1() {
        return this._escherClientAnchor.getRow1();
    }

    public void setRow1(int n) {
        this.checkRange(n, 0, 65536, "row1");
        this._escherClientAnchor.setRow1(Integer.valueOf(n).shortValue());
    }

    public int getRow2() {
        return this._escherClientAnchor.getRow2();
    }

    public void setRow2(int n) {
        this.checkRange(n, 0, 65536, "row2");
        this._escherClientAnchor.setRow2(Integer.valueOf(n).shortValue());
    }

    public void setAnchor(short s, int n, int n2, int n3, short s2, int n4, int n5, int n6) {
        this.checkRange(this.getDx1(), 0, 1023, "dx1");
        this.checkRange(this.getDx2(), 0, 1023, "dx2");
        this.checkRange(this.getDy1(), 0, 255, "dy1");
        this.checkRange(this.getDy2(), 0, 255, "dy2");
        this.checkRange(this.getCol1(), 0, 255, "col1");
        this.checkRange(this.getCol2(), 0, 255, "col2");
        this.checkRange(this.getRow1(), 0, 65280, "row1");
        this.checkRange(this.getRow2(), 0, 65280, "row2");
        this.setCol1(s);
        this.setRow1(n);
        this.setDx1(n2);
        this.setDy1(n3);
        this.setCol2(s2);
        this.setRow2(n4);
        this.setDx2(n5);
        this.setDy2(n6);
    }

    public boolean isHorizontallyFlipped() {
        return this._isHorizontallyFlipped;
    }

    public boolean isVerticallyFlipped() {
        return this._isVerticallyFlipped;
    }

    protected EscherRecord getEscherAnchor() {
        return this._escherClientAnchor;
    }

    protected void createEscherAnchor() {
        this._escherClientAnchor = new EscherClientAnchorRecord();
    }

    public int getAnchorType() {
        return this._escherClientAnchor.getFlag();
    }

    public void setAnchorType(int n) {
        this._escherClientAnchor.setFlag(Integer.valueOf(n).shortValue());
    }

    private void checkRange(int n, int n2, int n3, String string) {
        if (n < n2 || n > n3) {
            throw new IllegalArgumentException(string + " must be between " + n2 + " and " + n3 + ", but was: " + n);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        HSSFClientAnchor hSSFClientAnchor = (HSSFClientAnchor)object;
        return hSSFClientAnchor.getCol1() == this.getCol1() && hSSFClientAnchor.getCol2() == this.getCol2() && hSSFClientAnchor.getDx1() == this.getDx1() && hSSFClientAnchor.getDx2() == this.getDx2() && hSSFClientAnchor.getDy1() == this.getDy1() && hSSFClientAnchor.getDy2() == this.getDy2() && hSSFClientAnchor.getRow1() == this.getRow1() && hSSFClientAnchor.getRow2() == this.getRow2() && hSSFClientAnchor.getAnchorType() == this.getAnchorType();
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public int getDx1() {
        return this._escherClientAnchor.getDx1();
    }

    public void setDx1(int n) {
        this._escherClientAnchor.setDx1(Integer.valueOf(n).shortValue());
    }

    public int getDy1() {
        return this._escherClientAnchor.getDy1();
    }

    public void setDy1(int n) {
        this._escherClientAnchor.setDy1(Integer.valueOf(n).shortValue());
    }

    public int getDy2() {
        return this._escherClientAnchor.getDy2();
    }

    public void setDy2(int n) {
        this._escherClientAnchor.setDy2(Integer.valueOf(n).shortValue());
    }

    public int getDx2() {
        return this._escherClientAnchor.getDx2();
    }

    public void setDx2(int n) {
        this._escherClientAnchor.setDx2(Integer.valueOf(n).shortValue());
    }
}

