/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.hssf.model.InternalWorkbook;
import ai.org.apache.poi.hssf.record.ExtendedFormatRecord;
import ai.org.apache.poi.hssf.record.FontRecord;
import ai.org.apache.poi.hssf.record.FormatRecord;
import ai.org.apache.poi.hssf.record.StyleRecord;
import ai.org.apache.poi.hssf.usermodel.HSSFDataFormat;
import ai.org.apache.poi.hssf.usermodel.HSSFFont;
import ai.org.apache.poi.hssf.usermodel.HSSFPalette;
import ai.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai.org.apache.poi.hssf.util.HSSFColor;
import ai.org.apache.poi.ss.usermodel.CellStyle;
import ai.org.apache.poi.ss.usermodel.Font;
import ai.org.apache.poi.ss.usermodel.Workbook;
import java.util.List;

public final class HSSFCellStyle
implements CellStyle {
    private ExtendedFormatRecord _format = null;
    private short _index = 0;
    private InternalWorkbook _workbook = null;
    private static ThreadLocal<Short> lastDateFormat = new ThreadLocal<Short>(){

        @Override
        protected Short initialValue() {
            return (short)Short.MIN_VALUE;
        }
    };
    private static ThreadLocal<List<FormatRecord>> lastFormats = new ThreadLocal();
    private static ThreadLocal<String> getDataFormatStringCache = new ThreadLocal();

    protected HSSFCellStyle(short s, ExtendedFormatRecord extendedFormatRecord, HSSFWorkbook hSSFWorkbook) {
        this(s, extendedFormatRecord, hSSFWorkbook.getWorkbook());
    }

    protected HSSFCellStyle(short s, ExtendedFormatRecord extendedFormatRecord, InternalWorkbook internalWorkbook) {
        this._workbook = internalWorkbook;
        this._index = s;
        this._format = extendedFormatRecord;
    }

    public short getIndex() {
        return this._index;
    }

    public HSSFCellStyle getParentStyle() {
        short s = this._format.getParentIndex();
        if (s == 0 || s == 4095) {
            return null;
        }
        return new HSSFCellStyle(s, this._workbook.getExFormatAt(s), this._workbook);
    }

    public void setDataFormat(short s) {
        this._format.setFormatIndex(s);
    }

    public short getDataFormat() {
        return this._format.getFormatIndex();
    }

    public String getDataFormatString() {
        if (getDataFormatStringCache.get() != null && lastDateFormat.get().shortValue() == this.getDataFormat() && this._workbook.getFormats().equals(lastFormats.get())) {
            return getDataFormatStringCache.get();
        }
        lastFormats.set(this._workbook.getFormats());
        lastDateFormat.set(this.getDataFormat());
        getDataFormatStringCache.set(this.getDataFormatString(this._workbook));
        return getDataFormatStringCache.get();
    }

    public String getDataFormatString(Workbook workbook) {
        HSSFDataFormat hSSFDataFormat = new HSSFDataFormat(((HSSFWorkbook)workbook).getWorkbook());
        short s = this.getDataFormat();
        return s == -1 ? "General" : hSSFDataFormat.getFormat(this.getDataFormat());
    }

    public String getDataFormatString(InternalWorkbook internalWorkbook) {
        HSSFDataFormat hSSFDataFormat = new HSSFDataFormat(internalWorkbook);
        return hSSFDataFormat.getFormat(this.getDataFormat());
    }

    public void setFont(Font font) {
        this.setFont((HSSFFont)font);
    }

    public void setFont(HSSFFont hSSFFont) {
        this._format.setIndentNotParentFont(true);
        short s = hSSFFont.getIndex();
        this._format.setFontIndex(s);
    }

    public short getFontIndex() {
        return this._format.getFontIndex();
    }

    public HSSFFont getFont(Workbook workbook) {
        return ((HSSFWorkbook)workbook).getFontAt(this.getFontIndex());
    }

    public void setHidden(boolean bl) {
        this._format.setIndentNotParentCellOptions(true);
        this._format.setHidden(bl);
    }

    public boolean getHidden() {
        return this._format.isHidden();
    }

    public void setLocked(boolean bl) {
        this._format.setIndentNotParentCellOptions(true);
        this._format.setLocked(bl);
    }

    public boolean getLocked() {
        return this._format.isLocked();
    }

    public void setAlignment(short s) {
        this._format.setIndentNotParentAlignment(true);
        this._format.setAlignment(s);
    }

    public short getAlignment() {
        return this._format.getAlignment();
    }

    public void setWrapText(boolean bl) {
        this._format.setIndentNotParentAlignment(true);
        this._format.setWrapText(bl);
    }

    public boolean getWrapText() {
        return this._format.getWrapText();
    }

    public void setVerticalAlignment(short s) {
        this._format.setVerticalAlignment(s);
    }

    public short getVerticalAlignment() {
        return this._format.getVerticalAlignment();
    }

    public void setRotation(short s) {
        if (s != 255) {
            if (s < 0 && s >= -90) {
                s = (short)(90 - s);
            } else if (s < -90 || s > 90) {
                throw new IllegalArgumentException("The rotation must be between -90 and 90 degrees, or 0xff");
            }
        }
        this._format.setRotation(s);
    }

    public short getRotation() {
        short s = this._format.getRotation();
        if (s == 255) {
            return s;
        }
        if (s > 90) {
            s = (short)(90 - s);
        }
        return s;
    }

    public void setIndention(short s) {
        this._format.setIndent(s);
    }

    public short getIndention() {
        return this._format.getIndent();
    }

    public void setBorderLeft(short s) {
        this._format.setIndentNotParentBorder(true);
        this._format.setBorderLeft(s);
    }

    public short getBorderLeft() {
        return this._format.getBorderLeft();
    }

    public void setBorderRight(short s) {
        this._format.setIndentNotParentBorder(true);
        this._format.setBorderRight(s);
    }

    public short getBorderRight() {
        return this._format.getBorderRight();
    }

    public void setBorderTop(short s) {
        this._format.setIndentNotParentBorder(true);
        this._format.setBorderTop(s);
    }

    public short getBorderTop() {
        return this._format.getBorderTop();
    }

    public void setBorderBottom(short s) {
        this._format.setIndentNotParentBorder(true);
        this._format.setBorderBottom(s);
    }

    public short getBorderBottom() {
        return this._format.getBorderBottom();
    }

    public void setLeftBorderColor(short s) {
        this._format.setLeftBorderPaletteIdx(s);
    }

    public short getLeftBorderColor() {
        return this._format.getLeftBorderPaletteIdx();
    }

    public void setRightBorderColor(short s) {
        this._format.setRightBorderPaletteIdx(s);
    }

    public short getRightBorderColor() {
        return this._format.getRightBorderPaletteIdx();
    }

    public void setTopBorderColor(short s) {
        this._format.setTopBorderPaletteIdx(s);
    }

    public short getTopBorderColor() {
        return this._format.getTopBorderPaletteIdx();
    }

    public void setBottomBorderColor(short s) {
        this._format.setBottomBorderPaletteIdx(s);
    }

    public short getBottomBorderColor() {
        return this._format.getBottomBorderPaletteIdx();
    }

    public void setFillPattern(short s) {
        this._format.setAdtlFillPattern(s);
    }

    public short getFillPattern() {
        return this._format.getAdtlFillPattern();
    }

    private void checkDefaultBackgroundFills() {
        if (this._format.getFillForeground() == 64) {
            if (this._format.getFillBackground() != 65) {
                this.setFillBackgroundColor((short)65);
            }
        } else if (this._format.getFillBackground() == 65 && this._format.getFillForeground() != 64) {
            this.setFillBackgroundColor((short)64);
        }
    }

    public void setFillBackgroundColor(short s) {
        this._format.setFillBackground(s);
        this.checkDefaultBackgroundFills();
    }

    public short getFillBackgroundColor() {
        short s = this._format.getFillBackground();
        if (s == 65) {
            return 64;
        }
        return s;
    }

    public HSSFColor getFillBackgroundColorColor() {
        HSSFPalette hSSFPalette = new HSSFPalette(this._workbook.getCustomPalette());
        return hSSFPalette.getColor(this.getFillBackgroundColor());
    }

    public void setFillForegroundColor(short s) {
        this._format.setFillForeground(s);
        this.checkDefaultBackgroundFills();
    }

    public short getFillForegroundColor() {
        return this._format.getFillForeground();
    }

    public HSSFColor getFillForegroundColorColor() {
        HSSFPalette hSSFPalette = new HSSFPalette(this._workbook.getCustomPalette());
        return hSSFPalette.getColor(this.getFillForegroundColor());
    }

    public String getUserStyleName() {
        StyleRecord styleRecord = this._workbook.getStyleRecord(this._index);
        if (styleRecord == null) {
            return null;
        }
        if (styleRecord.isBuiltin()) {
            return null;
        }
        return styleRecord.getName();
    }

    public void setUserStyleName(String string) {
        StyleRecord styleRecord = this._workbook.getStyleRecord(this._index);
        if (styleRecord == null) {
            styleRecord = this._workbook.createStyleRecord(this._index);
        }
        if (styleRecord.isBuiltin() && this._index <= 20) {
            throw new IllegalArgumentException("Unable to set user specified style names for built in styles!");
        }
        styleRecord.setName(string);
    }

    public void setShrinkToFit(boolean bl) {
        this._format.setShrinkToFit(bl);
    }

    public boolean getShrinkToFit() {
        return this._format.getShrinkToFit();
    }

    public short getReadingOrder() {
        return this._format.getReadingOrder();
    }

    public void setReadingOrder(short s) {
        this._format.setReadingOrder(s);
    }

    public void verifyBelongsToWorkbook(HSSFWorkbook hSSFWorkbook) {
        if (hSSFWorkbook.getWorkbook() != this._workbook) {
            throw new IllegalArgumentException("This Style does not belong to the supplied Workbook. Are you trying to assign a style from one workbook to the cell of a differnt workbook?");
        }
    }

    public void cloneStyleFrom(CellStyle cellStyle) {
        if (!(cellStyle instanceof HSSFCellStyle)) {
            throw new IllegalArgumentException("Can only clone from one HSSFCellStyle to another, not between HSSFCellStyle and XSSFCellStyle");
        }
        this.cloneStyleFrom((HSSFCellStyle)cellStyle);
    }

    public void cloneStyleFrom(HSSFCellStyle hSSFCellStyle) {
        this._format.cloneStyleFrom(hSSFCellStyle._format);
        if (this._workbook != hSSFCellStyle._workbook) {
            lastDateFormat.set((short)Short.MIN_VALUE);
            lastFormats.set(null);
            getDataFormatStringCache.set(null);
            short s = (short)this._workbook.createFormat(hSSFCellStyle.getDataFormatString());
            this.setDataFormat(s);
            FontRecord fontRecord = this._workbook.createNewFont();
            fontRecord.cloneStyleFrom(hSSFCellStyle._workbook.getFontRecordAt(hSSFCellStyle.getFontIndex()));
            HSSFFont hSSFFont = new HSSFFont((short)this._workbook.getFontIndex(fontRecord), fontRecord);
            this.setFont(hSSFFont);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._format == null ? 0 : this._format.hashCode());
        n = 31 * n + this._index;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof HSSFCellStyle) {
            HSSFCellStyle hSSFCellStyle = (HSSFCellStyle)object;
            if (this._format == null ? hSSFCellStyle._format != null : !this._format.equals(hSSFCellStyle._format)) {
                return false;
            }
            return this._index == hSSFCellStyle._index;
        }
        return false;
    }
}

