/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.hssf.model.HSSFFormulaParser;
import ai.org.apache.poi.hssf.model.InternalWorkbook;
import ai.org.apache.poi.hssf.record.BlankRecord;
import ai.org.apache.poi.hssf.record.BoolErrRecord;
import ai.org.apache.poi.hssf.record.CellValueRecordInterface;
import ai.org.apache.poi.hssf.record.ExtendedFormatRecord;
import ai.org.apache.poi.hssf.record.FormulaRecord;
import ai.org.apache.poi.hssf.record.HyperlinkRecord;
import ai.org.apache.poi.hssf.record.LabelSSTRecord;
import ai.org.apache.poi.hssf.record.NumberRecord;
import ai.org.apache.poi.hssf.record.Record;
import ai.org.apache.poi.hssf.record.RecordBase;
import ai.org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import ai.org.apache.poi.hssf.record.common.UnicodeString;
import ai.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import ai.org.apache.poi.hssf.usermodel.HSSFComment;
import ai.org.apache.poi.hssf.usermodel.HSSFDateUtil;
import ai.org.apache.poi.hssf.usermodel.HSSFErrorConstants;
import ai.org.apache.poi.hssf.usermodel.HSSFHyperlink;
import ai.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import ai.org.apache.poi.hssf.usermodel.HSSFRow;
import ai.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai.org.apache.poi.ss.SpreadsheetVersion;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.ptg.ExpPtg;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import ai.org.apache.poi.ss.usermodel.Cell;
import ai.org.apache.poi.ss.usermodel.CellStyle;
import ai.org.apache.poi.ss.usermodel.Comment;
import ai.org.apache.poi.ss.usermodel.FormulaError;
import ai.org.apache.poi.ss.usermodel.Hyperlink;
import ai.org.apache.poi.ss.usermodel.RichTextString;
import ai.org.apache.poi.ss.util.CellRangeAddress;
import ai.org.apache.poi.ss.util.CellReference;
import ai.org.apache.poi.ss.util.NumberToTextConverter;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class HSSFCell
implements Cell {
    private static POILogger log = POILogFactory.getLogger(HSSFCell.class);
    private static final String FILE_FORMAT_NAME = "BIFF8";
    public static final int LAST_COLUMN_NUMBER = SpreadsheetVersion.EXCEL97.getLastColumnIndex();
    private static final String LAST_COLUMN_NAME = SpreadsheetVersion.EXCEL97.getLastColumnName();
    public static final short ENCODING_UNCHANGED = -1;
    public static final short ENCODING_COMPRESSED_UNICODE = 0;
    public static final short ENCODING_UTF_16 = 1;
    private final HSSFWorkbook _book;
    private final HSSFSheet _sheet;
    private int _cellType;
    private HSSFRichTextString _stringValue;
    private CellValueRecordInterface _record;
    private HSSFComment _comment;

    protected HSSFCell(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n, short s) {
        HSSFCell.checkBounds(s);
        this._stringValue = null;
        this._book = hSSFWorkbook;
        this._sheet = hSSFSheet;
        short s2 = hSSFSheet.getSheet().getXFIndexForColAt(s);
        this.setCellType(3, false, n, s, s2);
    }

    public HSSFSheet getSheet() {
        return this._sheet;
    }

    public HSSFRow getRow() {
        int n = this.getRowIndex();
        return this._sheet.getRow(n);
    }

    protected HSSFCell(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, int n, short s, int n2) {
        HSSFCell.checkBounds(s);
        this._cellType = -1;
        this._stringValue = null;
        this._book = hSSFWorkbook;
        this._sheet = hSSFSheet;
        short s2 = hSSFSheet.getSheet().getXFIndexForColAt(s);
        this.setCellType(n2, false, n, s, s2);
    }

    protected HSSFCell(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, CellValueRecordInterface cellValueRecordInterface) {
        this._record = cellValueRecordInterface;
        this._cellType = HSSFCell.determineType(cellValueRecordInterface);
        this._stringValue = null;
        this._book = hSSFWorkbook;
        this._sheet = hSSFSheet;
        switch (this._cellType) {
            case 1: {
                this._stringValue = new HSSFRichTextString(hSSFWorkbook.getWorkbook(), (LabelSSTRecord)cellValueRecordInterface);
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                this._stringValue = new HSSFRichTextString(((FormulaRecordAggregate)cellValueRecordInterface).getStringValue());
            }
        }
    }

    private static int determineType(CellValueRecordInterface cellValueRecordInterface) {
        if (cellValueRecordInterface instanceof FormulaRecordAggregate) {
            return 2;
        }
        Record record = (Record)((Object)cellValueRecordInterface);
        switch (record.getSid()) {
            case 515: {
                return 0;
            }
            case 513: {
                return 3;
            }
            case 253: {
                return 1;
            }
            case 517: {
                BoolErrRecord boolErrRecord = (BoolErrRecord)record;
                return boolErrRecord.isBoolean() ? 4 : 5;
            }
        }
        throw new RuntimeException("Bad cell value rec (" + cellValueRecordInterface.getClass().getName() + ")");
    }

    protected InternalWorkbook getBoundWorkbook() {
        return this._book.getWorkbook();
    }

    public int getRowIndex() {
        return this._record.getRow();
    }

    public void setCellNum(short s) {
        this._record.setColumn(s);
    }

    protected void updateCellNum(short s) {
        this._record.setColumn(s);
    }

    public short getCellNum() {
        return (short)this.getColumnIndex();
    }

    public int getColumnIndex() {
        return this._record.getColumn() & 0xFFFF;
    }

    public void setCellType(int n) {
        this.notifyFormulaChanging();
        if (this.isPartOfArrayFormulaGroup()) {
            this.notifyArrayFormulaChanging();
        }
        int n2 = this._record.getRow();
        short s = this._record.getColumn();
        short s2 = this._record.getXFIndex();
        this.setCellType(n, true, n2, s, s2);
    }

    private void setCellType(int n, boolean bl, int n2, short s, short s2) {
        if (n > 5) {
            throw new RuntimeException("I have no idea what type that is!");
        }
        switch (n) {
            case 2: {
                FormulaRecordAggregate formulaRecordAggregate;
                if (n != this._cellType) {
                    formulaRecordAggregate = this._sheet.getSheet().getRowsAggregate().createFormula(n2, s);
                } else {
                    formulaRecordAggregate = (FormulaRecordAggregate)this._record;
                    formulaRecordAggregate.setRow(n2);
                    formulaRecordAggregate.setColumn(s);
                }
                if (bl) {
                    formulaRecordAggregate.getFormulaRecord().setValue(this.getNumericCellValue());
                }
                formulaRecordAggregate.setXFIndex(s2);
                this._record = formulaRecordAggregate;
                break;
            }
            case 0: {
                NumberRecord numberRecord = null;
                numberRecord = n != this._cellType ? new NumberRecord() : (NumberRecord)this._record;
                numberRecord.setColumn(s);
                if (bl) {
                    numberRecord.setValue(this.getNumericCellValue());
                }
                numberRecord.setXFIndex(s2);
                numberRecord.setRow(n2);
                this._record = numberRecord;
                break;
            }
            case 1: {
                LabelSSTRecord labelSSTRecord;
                if (n == this._cellType) {
                    labelSSTRecord = (LabelSSTRecord)this._record;
                } else {
                    labelSSTRecord = new LabelSSTRecord();
                    labelSSTRecord.setColumn(s);
                    labelSSTRecord.setRow(n2);
                    labelSSTRecord.setXFIndex(s2);
                }
                if (bl) {
                    String string = this.convertCellValueToString();
                    int n3 = this._book.getWorkbook().addSSTString(new UnicodeString(string));
                    labelSSTRecord.setSSTIndex(n3);
                    UnicodeString unicodeString = this._book.getWorkbook().getSSTString(n3);
                    this._stringValue = new HSSFRichTextString();
                    this._stringValue.setUnicodeString(unicodeString);
                }
                this._record = labelSSTRecord;
                break;
            }
            case 3: {
                BlankRecord blankRecord = null;
                blankRecord = n != this._cellType ? new BlankRecord() : (BlankRecord)this._record;
                blankRecord.setColumn(s);
                blankRecord.setXFIndex(s2);
                blankRecord.setRow(n2);
                this._record = blankRecord;
                break;
            }
            case 4: {
                BoolErrRecord boolErrRecord = null;
                boolErrRecord = n != this._cellType ? new BoolErrRecord() : (BoolErrRecord)this._record;
                boolErrRecord.setColumn(s);
                if (bl) {
                    boolErrRecord.setValue(this.convertCellValueToBoolean());
                }
                boolErrRecord.setXFIndex(s2);
                boolErrRecord.setRow(n2);
                this._record = boolErrRecord;
                break;
            }
            case 5: {
                BoolErrRecord boolErrRecord = null;
                boolErrRecord = n != this._cellType ? new BoolErrRecord() : (BoolErrRecord)this._record;
                boolErrRecord.setColumn(s);
                if (bl) {
                    boolErrRecord.setValue((byte)15);
                }
                boolErrRecord.setXFIndex(s2);
                boolErrRecord.setRow(n2);
                this._record = boolErrRecord;
            }
        }
        if (n != this._cellType && this._cellType != -1) {
            this._sheet.getSheet().replaceValueRecord(this._record);
        }
        this._cellType = n;
    }

    public int getCellType() {
        return this._cellType;
    }

    public void setCellValue(double d) {
        if (Double.isInfinite(d)) {
            this.setCellErrorValue(FormulaError.DIV0.getCode());
        } else if (Double.isNaN(d)) {
            this.setCellErrorValue(FormulaError.NUM.getCode());
        } else {
            int n = this._record.getRow();
            short s = this._record.getColumn();
            short s2 = this._record.getXFIndex();
            switch (this._cellType) {
                default: {
                    this.setCellType(0, false, n, s, s2);
                }
                case 0: {
                    ((NumberRecord)this._record).setValue(d);
                    break;
                }
                case 2: {
                    ((FormulaRecordAggregate)this._record).setCachedDoubleResult(d);
                }
            }
        }
    }

    public void setCellValue(Date date) {
        this.setCellValue(HSSFDateUtil.getExcelDate(date, this._book.getWorkbook().isUsing1904DateWindowing()));
    }

    public void setCellValue(Calendar calendar) {
        this.setCellValue(HSSFDateUtil.getExcelDate(calendar, this._book.getWorkbook().isUsing1904DateWindowing()));
    }

    public void setCellValue(String string) {
        HSSFRichTextString hSSFRichTextString = string == null ? null : new HSSFRichTextString(string);
        this.setCellValue(hSSFRichTextString);
    }

    public void setCellValue(RichTextString richTextString) {
        HSSFRichTextString hSSFRichTextString = (HSSFRichTextString)richTextString;
        int n = this._record.getRow();
        short s = this._record.getColumn();
        short s2 = this._record.getXFIndex();
        if (hSSFRichTextString == null) {
            this.notifyFormulaChanging();
            this.setCellType(3, false, n, s, s2);
            return;
        }
        if (hSSFRichTextString.length() > SpreadsheetVersion.EXCEL97.getMaxTextLength()) {
            throw new IllegalArgumentException("The maximum length of cell contents (text) is 32,767 characters");
        }
        if (this._cellType == 2) {
            FormulaRecordAggregate formulaRecordAggregate = (FormulaRecordAggregate)this._record;
            formulaRecordAggregate.setCachedStringResult(hSSFRichTextString.getString());
            this._stringValue = new HSSFRichTextString(richTextString.getString());
            return;
        }
        if (this._cellType != 1) {
            this.setCellType(1, false, n, s, s2);
        }
        int n2 = 0;
        UnicodeString unicodeString = hSSFRichTextString.getUnicodeString();
        n2 = this._book.getWorkbook().addSSTString(unicodeString);
        ((LabelSSTRecord)this._record).setSSTIndex(n2);
        this._stringValue = hSSFRichTextString;
        this._stringValue.setWorkbookReferences(this._book.getWorkbook(), (LabelSSTRecord)this._record);
        this._stringValue.setUnicodeString(this._book.getWorkbook().getSSTString(n2));
    }

    public void setCellFormula(String string) {
        if (this.isPartOfArrayFormulaGroup()) {
            this.notifyArrayFormulaChanging();
        }
        int n = this._record.getRow();
        short s = this._record.getColumn();
        short s2 = this._record.getXFIndex();
        if (string == null) {
            this.notifyFormulaChanging();
            this.setCellType(3, false, n, s, s2);
            return;
        }
        int n2 = this._book.getSheetIndex(this._sheet);
        Ptg[] ptgArray = HSSFFormulaParser.parse(string, this._book, 0, n2);
        this.setCellType(2, false, n, s, s2);
        FormulaRecordAggregate formulaRecordAggregate = (FormulaRecordAggregate)this._record;
        FormulaRecord formulaRecord = formulaRecordAggregate.getFormulaRecord();
        formulaRecord.setOptions((short)2);
        formulaRecord.setValue(0.0);
        if (formulaRecordAggregate.getXFIndex() == 0) {
            formulaRecordAggregate.setXFIndex((short)15);
        }
        formulaRecordAggregate.setParsedExpression(ptgArray);
    }

    private void notifyFormulaChanging() {
        if (this._record instanceof FormulaRecordAggregate) {
            ((FormulaRecordAggregate)this._record).notifyFormulaChanging();
        }
    }

    public String getCellFormula() {
        if (!(this._record instanceof FormulaRecordAggregate)) {
            throw HSSFCell.typeMismatch(2, this._cellType, true);
        }
        return HSSFFormulaParser.toFormulaString(this._book, ((FormulaRecordAggregate)this._record).getFormulaTokens());
    }

    private static String getCellTypeName(int n) {
        switch (n) {
            case 3: {
                return "blank";
            }
            case 1: {
                return "text";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "error";
            }
            case 0: {
                return "numeric";
            }
            case 2: {
                return "formula";
            }
        }
        return "#unknown cell type (" + n + ")#";
    }

    private static RuntimeException typeMismatch(int n, int n2, boolean bl) {
        String string = "Cannot get a " + HSSFCell.getCellTypeName(n) + " value from a " + HSSFCell.getCellTypeName(n2) + " " + (bl ? "formula " : "") + "cell";
        return new IllegalStateException(string);
    }

    private static void checkFormulaCachedValueType(int n, FormulaRecord formulaRecord) {
        int n2 = formulaRecord.getCachedResultType();
        if (n2 != n) {
            throw HSSFCell.typeMismatch(n, n2, true);
        }
    }

    public double getNumericCellValue() {
        switch (this._cellType) {
            case 3: {
                return 0.0;
            }
            case 0: {
                return ((NumberRecord)this._record).getValue();
            }
            default: {
                throw HSSFCell.typeMismatch(0, this._cellType, false);
            }
            case 2: 
        }
        FormulaRecord formulaRecord = ((FormulaRecordAggregate)this._record).getFormulaRecord();
        HSSFCell.checkFormulaCachedValueType(0, formulaRecord);
        return formulaRecord.getValue();
    }

    public Date getDateCellValue() {
        if (this._cellType == 3) {
            return null;
        }
        double d = this.getNumericCellValue();
        if (this._book.getWorkbook().isUsing1904DateWindowing()) {
            return HSSFDateUtil.getJavaDate(d, true);
        }
        return HSSFDateUtil.getJavaDate(d, false);
    }

    public String getStringCellValue() {
        HSSFRichTextString hSSFRichTextString = this.getRichStringCellValue();
        return hSSFRichTextString.getString();
    }

    public HSSFRichTextString getRichStringCellValue() {
        switch (this._cellType) {
            case 3: {
                return new HSSFRichTextString("");
            }
            case 1: {
                return this._stringValue;
            }
            default: {
                throw HSSFCell.typeMismatch(1, this._cellType, false);
            }
            case 2: 
        }
        FormulaRecordAggregate formulaRecordAggregate = (FormulaRecordAggregate)this._record;
        HSSFCell.checkFormulaCachedValueType(1, formulaRecordAggregate.getFormulaRecord());
        String string = formulaRecordAggregate.getStringValue();
        return new HSSFRichTextString(string == null ? "" : string);
    }

    public void setCellValue(boolean bl) {
        int n = this._record.getRow();
        short s = this._record.getColumn();
        short s2 = this._record.getXFIndex();
        switch (this._cellType) {
            default: {
                this.setCellType(4, false, n, s, s2);
            }
            case 4: {
                ((BoolErrRecord)this._record).setValue(bl);
                break;
            }
            case 2: {
                ((FormulaRecordAggregate)this._record).setCachedBooleanResult(bl);
            }
        }
    }

    public void setCellErrorValue(byte by) {
        int n = this._record.getRow();
        short s = this._record.getColumn();
        short s2 = this._record.getXFIndex();
        switch (this._cellType) {
            default: {
                this.setCellType(5, false, n, s, s2);
            }
            case 5: {
                ((BoolErrRecord)this._record).setValue(by);
                break;
            }
            case 2: {
                ((FormulaRecordAggregate)this._record).setCachedErrorResult(by);
            }
        }
    }

    private boolean convertCellValueToBoolean() {
        switch (this._cellType) {
            case 4: {
                return ((BoolErrRecord)this._record).getBooleanValue();
            }
            case 1: {
                int n = ((LabelSSTRecord)this._record).getSSTIndex();
                String string = this._book.getWorkbook().getSSTString(n).getString();
                return Boolean.valueOf(string);
            }
            case 0: {
                return ((NumberRecord)this._record).getValue() != 0.0;
            }
            case 2: {
                FormulaRecord formulaRecord = ((FormulaRecordAggregate)this._record).getFormulaRecord();
                HSSFCell.checkFormulaCachedValueType(4, formulaRecord);
                return formulaRecord.getCachedBooleanValue();
            }
            case 3: 
            case 5: {
                return false;
            }
        }
        throw new RuntimeException("Unexpected cell type (" + this._cellType + ")");
    }

    private String convertCellValueToString() {
        switch (this._cellType) {
            case 3: {
                return "";
            }
            case 4: {
                return ((BoolErrRecord)this._record).getBooleanValue() ? "TRUE" : "FALSE";
            }
            case 1: {
                int n = ((LabelSSTRecord)this._record).getSSTIndex();
                return this._book.getWorkbook().getSSTString(n).getString();
            }
            case 0: {
                return NumberToTextConverter.toText(((NumberRecord)this._record).getValue());
            }
            case 5: {
                return HSSFErrorConstants.getText(((BoolErrRecord)this._record).getErrorValue());
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected cell type (" + this._cellType + ")");
            }
        }
        FormulaRecordAggregate formulaRecordAggregate = (FormulaRecordAggregate)this._record;
        FormulaRecord formulaRecord = formulaRecordAggregate.getFormulaRecord();
        switch (formulaRecord.getCachedResultType()) {
            case 4: {
                return formulaRecord.getCachedBooleanValue() ? "TRUE" : "FALSE";
            }
            case 1: {
                return formulaRecordAggregate.getStringValue();
            }
            case 0: {
                return NumberToTextConverter.toText(formulaRecord.getValue());
            }
            case 5: {
                return HSSFErrorConstants.getText(formulaRecord.getCachedErrorValue());
            }
        }
        throw new IllegalStateException("Unexpected formula result type (" + this._cellType + ")");
    }

    public boolean getBooleanCellValue() {
        switch (this._cellType) {
            case 3: {
                return false;
            }
            case 4: {
                return ((BoolErrRecord)this._record).getBooleanValue();
            }
            default: {
                throw HSSFCell.typeMismatch(4, this._cellType, false);
            }
            case 2: 
        }
        FormulaRecord formulaRecord = ((FormulaRecordAggregate)this._record).getFormulaRecord();
        HSSFCell.checkFormulaCachedValueType(4, formulaRecord);
        return formulaRecord.getCachedBooleanValue();
    }

    public byte getErrorCellValue() {
        switch (this._cellType) {
            case 5: {
                return ((BoolErrRecord)this._record).getErrorValue();
            }
            default: {
                throw HSSFCell.typeMismatch(5, this._cellType, false);
            }
            case 2: 
        }
        FormulaRecord formulaRecord = ((FormulaRecordAggregate)this._record).getFormulaRecord();
        HSSFCell.checkFormulaCachedValueType(5, formulaRecord);
        return (byte)formulaRecord.getCachedErrorValue();
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.setCellStyle((HSSFCellStyle)cellStyle);
    }

    public void setCellStyle(HSSFCellStyle hSSFCellStyle) {
        if (hSSFCellStyle == null) {
            this._record.setXFIndex((short)15);
            return;
        }
        hSSFCellStyle.verifyBelongsToWorkbook(this._book);
        short s = hSSFCellStyle.getUserStyleName() != null ? this.applyUserCellStyle(hSSFCellStyle) : hSSFCellStyle.getIndex();
        this._record.setXFIndex(s);
    }

    public HSSFCellStyle getCellStyle() {
        short s = this._record.getXFIndex();
        ExtendedFormatRecord extendedFormatRecord = this._book.getWorkbook().getExFormatAt(s);
        return new HSSFCellStyle(s, extendedFormatRecord, this._book);
    }

    protected CellValueRecordInterface getCellValueRecord() {
        return this._record;
    }

    private static void checkBounds(int n) {
        if (n < 0 || n > LAST_COLUMN_NUMBER) {
            throw new IllegalArgumentException("Invalid column index (" + n + ").  Allowable column range for " + FILE_FORMAT_NAME + " is (0.." + LAST_COLUMN_NUMBER + ") or ('A'..'" + LAST_COLUMN_NAME + "')");
        }
    }

    public void setAsActiveCell() {
        int n = this._record.getRow();
        short s = this._record.getColumn();
        this._sheet.getSheet().setActiveCellRow(n);
        this._sheet.getSheet().setActiveCellCol(s);
    }

    public String toString() {
        switch (this.getCellType()) {
            case 3: {
                return "";
            }
            case 4: {
                return this.getBooleanCellValue() ? "TRUE" : "FALSE";
            }
            case 5: {
                return ErrorEval.getText(((BoolErrRecord)this._record).getErrorValue());
            }
            case 2: {
                return this.getCellFormula();
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted(this)) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
                    return simpleDateFormat.format(this.getDateCellValue());
                }
                return String.valueOf(this.getNumericCellValue());
            }
            case 1: {
                return this.getStringCellValue();
            }
        }
        return "Unknown Cell Type: " + this.getCellType();
    }

    public void setCellComment(Comment comment) {
        if (comment == null) {
            this.removeCellComment();
            return;
        }
        comment.setRow(this._record.getRow());
        comment.setColumn(this._record.getColumn());
        this._comment = (HSSFComment)comment;
    }

    public HSSFComment getCellComment() {
        if (this._comment == null) {
            this._comment = this._sheet.findCellComment(this._record.getRow(), this._record.getColumn());
        }
        return this._comment;
    }

    public void removeCellComment() {
        HSSFComment hSSFComment = this._sheet.findCellComment(this._record.getRow(), this._record.getColumn());
        this._comment = null;
        if (null == hSSFComment) {
            return;
        }
        this._sheet.getDrawingPatriarch().removeShape(hSSFComment);
    }

    public HSSFHyperlink getHyperlink() {
        for (RecordBase recordBase : this._sheet.getSheet().getRecords()) {
            HyperlinkRecord hyperlinkRecord;
            if (!(recordBase instanceof HyperlinkRecord) || (hyperlinkRecord = (HyperlinkRecord)recordBase).getFirstColumn() != this._record.getColumn() || hyperlinkRecord.getFirstRow() != this._record.getRow()) continue;
            return new HSSFHyperlink(hyperlinkRecord);
        }
        return null;
    }

    public void setHyperlink(Hyperlink hyperlink) {
        if (hyperlink == null) {
            this.removeHyperlink();
            return;
        }
        HSSFHyperlink hSSFHyperlink = (HSSFHyperlink)hyperlink;
        hSSFHyperlink.setFirstRow(this._record.getRow());
        hSSFHyperlink.setLastRow(this._record.getRow());
        hSSFHyperlink.setFirstColumn(this._record.getColumn());
        hSSFHyperlink.setLastColumn(this._record.getColumn());
        switch (hSSFHyperlink.getType()) {
            case 1: 
            case 3: {
                hSSFHyperlink.setLabel("url");
                break;
            }
            case 4: {
                hSSFHyperlink.setLabel("file");
                break;
            }
            case 2: {
                hSSFHyperlink.setLabel("place");
            }
        }
        List<RecordBase> list = this._sheet.getSheet().getRecords();
        int n = list.size() - 1;
        list.add(n, hSSFHyperlink.record);
    }

    public void removeHyperlink() {
        Iterator<RecordBase> iterator = this._sheet.getSheet().getRecords().iterator();
        while (iterator.hasNext()) {
            HyperlinkRecord hyperlinkRecord;
            RecordBase recordBase = iterator.next();
            if (!(recordBase instanceof HyperlinkRecord) || (hyperlinkRecord = (HyperlinkRecord)recordBase).getFirstColumn() != this._record.getColumn() || hyperlinkRecord.getFirstRow() != this._record.getRow()) continue;
            iterator.remove();
            return;
        }
    }

    public int getCachedFormulaResultType() {
        if (this._cellType != 2) {
            throw new IllegalStateException("Only formula cells have cached results");
        }
        return ((FormulaRecordAggregate)this._record).getFormulaRecord().getCachedResultType();
    }

    void setCellArrayFormula(CellRangeAddress cellRangeAddress) {
        int n = this._record.getRow();
        short s = this._record.getColumn();
        short s2 = this._record.getXFIndex();
        this.setCellType(2, false, n, s, s2);
        Ptg[] ptgArray = new Ptg[]{new ExpPtg(cellRangeAddress.getFirstRow(), cellRangeAddress.getFirstColumn())};
        FormulaRecordAggregate formulaRecordAggregate = (FormulaRecordAggregate)this._record;
        formulaRecordAggregate.setParsedExpression(ptgArray);
    }

    public CellRangeAddress getArrayFormulaRange() {
        if (this._cellType != 2) {
            String string = new CellReference(this).formatAsString();
            throw new IllegalStateException("Cell " + string + " is not part of an array formula.");
        }
        return ((FormulaRecordAggregate)this._record).getArrayFormulaRange();
    }

    public boolean isPartOfArrayFormulaGroup() {
        if (this._cellType != 2) {
            return false;
        }
        return ((FormulaRecordAggregate)this._record).isPartOfArrayFormula();
    }

    void notifyArrayFormulaChanging(String string) {
        CellRangeAddress cellRangeAddress = this.getArrayFormulaRange();
        if (cellRangeAddress.getNumberOfCells() > 1) {
            throw new IllegalStateException(string);
        }
        this.getRow().getSheet().removeArrayFormula(this);
    }

    void notifyArrayFormulaChanging() {
        CellReference cellReference = new CellReference(this);
        String string = "Cell " + cellReference.formatAsString() + " is part of a multi-cell array formula. " + "You cannot change part of an array.";
        this.notifyArrayFormulaChanging(string);
    }

    private short applyUserCellStyle(HSSFCellStyle hSSFCellStyle) {
        ExtendedFormatRecord extendedFormatRecord;
        short s;
        if (hSSFCellStyle.getUserStyleName() == null) {
            throw new IllegalArgumentException("Expected user-defined style");
        }
        InternalWorkbook internalWorkbook = this._book.getWorkbook();
        short s2 = -1;
        short s3 = internalWorkbook.getNumExFormats();
        for (s = 0; s < s3; s = (short)(s + 1)) {
            extendedFormatRecord = internalWorkbook.getExFormatAt(s);
            if (extendedFormatRecord.getXFType() != 0 || extendedFormatRecord.getParentIndex() != hSSFCellStyle.getIndex()) continue;
            s2 = s;
            break;
        }
        if (s2 == -1) {
            extendedFormatRecord = internalWorkbook.createCellXF();
            extendedFormatRecord.cloneStyleFrom(internalWorkbook.getExFormatAt(hSSFCellStyle.getIndex()));
            extendedFormatRecord.setIndentionOptions((short)0);
            extendedFormatRecord.setXFType((short)0);
            extendedFormatRecord.setParentIndex(hSSFCellStyle.getIndex());
            s = s3;
        } else {
            s = s2;
        }
        return s;
    }
}

