/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class FontDetails {
    private String _fontName;
    private int _height;
    private final Map<Character, Integer> charWidths = new HashMap<Character, Integer>();

    public FontDetails(String string, int n) {
        this._fontName = string;
        this._height = n;
    }

    public String getFontName() {
        return this._fontName;
    }

    public int getHeight() {
        return this._height;
    }

    public void addChar(char c, int n) {
        this.charWidths.put(Character.valueOf(c), n);
    }

    public int getCharWidth(char c) {
        Integer n = this.charWidths.get(Character.valueOf(c));
        if (n == null) {
            return 'W' == c ? 0 : this.getCharWidth('W');
        }
        return n;
    }

    public void addChars(char[] cArray, int[] nArray) {
        for (int i = 0; i < cArray.length; ++i) {
            this.charWidths.put(Character.valueOf(cArray[i]), nArray[i]);
        }
    }

    protected static String buildFontHeightProperty(String string) {
        return "font." + string + ".height";
    }

    protected static String buildFontWidthsProperty(String string) {
        return "font." + string + ".widths";
    }

    protected static String buildFontCharactersProperty(String string) {
        return "font." + string + ".characters";
    }

    public static FontDetails create(String string, Properties properties) {
        String[] stringArray;
        String string2 = properties.getProperty(FontDetails.buildFontHeightProperty(string));
        String string3 = properties.getProperty(FontDetails.buildFontWidthsProperty(string));
        String string4 = properties.getProperty(FontDetails.buildFontCharactersProperty(string));
        if (string2 == null || string3 == null || string4 == null) {
            throw new IllegalArgumentException("The supplied FontMetrics doesn't know about the font '" + string + "', so we can't use it. Please add it to your font metrics file (see StaticFontMetrics.getFontDetails");
        }
        int n = Integer.parseInt(string2);
        FontDetails fontDetails = new FontDetails(string, n);
        String[] stringArray2 = FontDetails.split(string4, ",", -1);
        if (stringArray2.length != (stringArray = FontDetails.split(string3, ",", -1)).length) {
            throw new RuntimeException("Number of characters does not number of widths for font " + string);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray2[i].length() == 0) continue;
            fontDetails.addChar(stringArray2[i].charAt(0), Integer.parseInt(stringArray[i]));
        }
        return fontDetails;
    }

    public int getStringWidth(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n += this.getCharWidth(string.charAt(i));
        }
        return n;
    }

    private static String[] split(String string, String string2, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n2 = stringTokenizer.countTokens();
        if (n != -1 && n2 > n) {
            n2 = n;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (n != -1 && n3 == n2 - 1) {
                StringBuffer stringBuffer = new StringBuffer(string.length() * (n2 - n3) / n2);
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(stringTokenizer.nextToken());
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    stringBuffer.append(string2);
                }
                stringArray[n3] = stringBuffer.toString().trim();
                break;
            }
            stringArray[n3] = stringTokenizer.nextToken().trim();
            ++n3;
        }
        return stringArray;
    }
}

