/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.hssf.usermodel.EscherGraphics;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public final class EscherGraphics2d
extends Graphics2D {
    private EscherGraphics _escherGraphics;
    private BufferedImage _img;
    private AffineTransform _trans;
    private Stroke _stroke;
    private Paint _paint;
    private Shape _deviceclip;
    private POILogger logger = POILogFactory.getLogger(this.getClass());

    public EscherGraphics2d(EscherGraphics escherGraphics) {
        this._escherGraphics = escherGraphics;
        this.setImg(new BufferedImage(1, 1, 2));
        this.setColor(Color.black);
    }

    public void addRenderingHints(Map map) {
        this.getG2D().addRenderingHints(map);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        Paint paint = this.getPaint();
        this.setColor(this.getBackground());
        this.fillRect(n, n2, n3, n4);
        this.setPaint(paint);
    }

    public void clip(Shape shape) {
        if (this.getDeviceclip() != null) {
            Area area = new Area(this.getClip());
            if (shape != null) {
                area.intersect(new Area(shape));
            }
            shape = area;
        }
        this.setClip(shape);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.getG2D().copyArea(n, n2, n3, n4, n5, n6);
    }

    public Graphics create() {
        EscherGraphics2d escherGraphics2d = new EscherGraphics2d(this._escherGraphics);
        return escherGraphics2d;
    }

    public void dispose() {
        this.getEscherGraphics().dispose();
        this.getG2D().dispose();
        this.getImg().flush();
    }

    public void draw(Shape shape) {
        if (shape instanceof Line2D) {
            Line2D line2D = (Line2D)shape;
            int n = 0;
            if (this._stroke != null && this._stroke instanceof BasicStroke) {
                n = (int)((BasicStroke)this._stroke).getLineWidth() * 12700;
            }
            this.drawLine((int)line2D.getX1(), (int)line2D.getY1(), (int)line2D.getX2(), (int)line2D.getY2(), n);
        } else if (this.logger.check(5)) {
            this.logger.log(5, "draw not fully supported");
        }
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new Arc2D.Float(n, n2, n3, n4, n5, n6, 0));
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.fill(glyphVector.getOutline(f, f2));
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (this.logger.check(5)) {
            this.logger.log(5, "drawImage() not supported");
        }
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        if (this.logger.check(5)) {
            this.logger.log(5, "drawImage() not supported");
        }
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (this.logger.check(5)) {
            this.logger.log(5, "drawImage() not supported");
        }
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), imageObserver);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        AffineTransform affineTransform2 = (AffineTransform)this.getTrans().clone();
        this.getTrans().concatenate(affineTransform);
        this.drawImage(image, 0, 0, imageObserver);
        this.setTrans(affineTransform2);
        return true;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        BufferedImage bufferedImage2 = bufferedImageOp.filter(bufferedImage, null);
        this.drawImage(bufferedImage2, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2), null);
    }

    public void drawLine(int n, int n2, int n3, int n4, int n5) {
        this.getEscherGraphics().drawLine(n, n2, n3, n4, n5);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (this._stroke != null && this._stroke instanceof BasicStroke) {
            n5 = (int)((BasicStroke)this._stroke).getLineWidth() * 12700;
        }
        this.getEscherGraphics().drawLine(n, n2, n3, n4, n5);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.getEscherGraphics().drawOval(n, n2, n3, n4);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.getEscherGraphics().drawPolygon(nArray, nArray2, n);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (n > 0) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(nArray[0], nArray2[0]);
            for (int i = 1; i < n; ++i) {
                generalPath.lineTo(nArray[i], nArray2[i]);
            }
            this.draw(generalPath);
        }
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this._escherGraphics.drawRect(n, n2, n3, n4);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createDefaultRendering(), affineTransform);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        BufferedImage bufferedImage = new BufferedImage(renderedImage.getColorModel(), renderedImage.getData().createCompatibleWritableRaster(), false, null);
        bufferedImage.setData(renderedImage.getData());
        this.drawImage(bufferedImage, affineTransform, null);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void drawString(String string, float f, float f2) {
        this.getEscherGraphics().drawString(string, (int)f, (int)f2);
    }

    public void drawString(String string, int n, int n2) {
        this.getEscherGraphics().drawString(string, n, n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        Paint paint = this.getPaint();
        this.setColor(this.getColor());
        this.fill(textLayout.getOutline(AffineTransform.getTranslateInstance(f, f2)));
        this.setPaint(paint);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.getEscherGraphics().drawString(attributedCharacterIterator, n, n2);
    }

    public void fill(Shape shape) {
        if (this.logger.check(5)) {
            this.logger.log(5, "fill(Shape) not supported");
        }
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Float(n, n2, n3, n4, n5, n6, 2));
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this._escherGraphics.fillOval(n, n2, n3, n4);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this._escherGraphics.fillPolygon(nArray, nArray2, n);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.getEscherGraphics().fillRect(n, n2, n3, n4);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public Color getBackground() {
        return this.getEscherGraphics().getBackground();
    }

    public Shape getClip() {
        try {
            return this.getTrans().createInverse().createTransformedShape(this.getDeviceclip());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Rectangle getClipBounds() {
        if (this.getDeviceclip() != null) {
            return this.getClip().getBounds();
        }
        return null;
    }

    public Color getColor() {
        return this._escherGraphics.getColor();
    }

    public Composite getComposite() {
        return this.getG2D().getComposite();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.getG2D().getDeviceConfiguration();
    }

    public Font getFont() {
        return this.getEscherGraphics().getFont();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.getEscherGraphics().getFontMetrics(font);
    }

    public FontRenderContext getFontRenderContext() {
        this.getG2D().setTransform(this.getTrans());
        return this.getG2D().getFontRenderContext();
    }

    public Paint getPaint() {
        return this._paint;
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.getG2D().getRenderingHint(key);
    }

    public RenderingHints getRenderingHints() {
        return this.getG2D().getRenderingHints();
    }

    public Stroke getStroke() {
        return this._stroke;
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.getTrans().clone();
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        this.getG2D().setTransform(this.getTrans());
        this.getG2D().setStroke(this.getStroke());
        this.getG2D().setClip(this.getClip());
        return this.getG2D().hit(rectangle, shape, bl);
    }

    public void rotate(double d) {
        this.getTrans().rotate(d);
    }

    public void rotate(double d, double d2, double d3) {
        this.getTrans().rotate(d, d2, d3);
    }

    public void scale(double d, double d2) {
        this.getTrans().scale(d, d2);
    }

    public void setBackground(Color color) {
        this.getEscherGraphics().setBackground(color);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    public void setClip(Shape shape) {
        this.setDeviceclip(this.getTrans().createTransformedShape(shape));
    }

    public void setColor(Color color) {
        this._escherGraphics.setColor(color);
    }

    public void setComposite(Composite composite) {
        this.getG2D().setComposite(composite);
    }

    public void setFont(Font font) {
        this.getEscherGraphics().setFont(font);
    }

    public void setPaint(Paint paint) {
        if (paint != null) {
            this._paint = paint;
            if (paint instanceof Color) {
                this.setColor((Color)paint);
            }
        }
    }

    public void setPaintMode() {
        this.getEscherGraphics().setPaintMode();
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.getG2D().setRenderingHint(key, object);
    }

    public void setRenderingHints(Map map) {
        this.getG2D().setRenderingHints(map);
    }

    public void setStroke(Stroke stroke) {
        this._stroke = stroke;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.setTrans((AffineTransform)affineTransform.clone());
    }

    public void setXORMode(Color color) {
        this.getEscherGraphics().setXORMode(color);
    }

    public void shear(double d, double d2) {
        this.getTrans().shear(d, d2);
    }

    public void transform(AffineTransform affineTransform) {
        this.getTrans().concatenate(affineTransform);
    }

    public void translate(double d, double d2) {
        this.getTrans().translate(d, d2);
    }

    public void translate(int n, int n2) {
        this.getTrans().translate(n, n2);
    }

    private EscherGraphics getEscherGraphics() {
        return this._escherGraphics;
    }

    private BufferedImage getImg() {
        return this._img;
    }

    private void setImg(BufferedImage bufferedImage) {
        this._img = bufferedImage;
    }

    private Graphics2D getG2D() {
        return (Graphics2D)this._img.getGraphics();
    }

    private AffineTransform getTrans() {
        return this._trans;
    }

    private void setTrans(AffineTransform affineTransform) {
        this._trans = affineTransform;
    }

    private Shape getDeviceclip() {
        return this._deviceclip;
    }

    private void setDeviceclip(Shape shape) {
        this._deviceclip = shape;
    }
}

