/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.pivottable;

import ai.org.apache.poi.hssf.record.RecordFormatException;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class PageItemRecord
extends StandardRecord {
    public static final short sid = 182;
    private final FieldInfo[] _fieldInfos;

    public PageItemRecord(RecordInputStream recordInputStream) {
        int n = recordInputStream.remaining();
        if (n % 6 != 0) {
            throw new RecordFormatException("Bad data size " + n);
        }
        int n2 = n / 6;
        FieldInfo[] fieldInfoArray = new FieldInfo[n2];
        for (int i = 0; i < fieldInfoArray.length; ++i) {
            fieldInfoArray[i] = new FieldInfo(recordInputStream);
        }
        this._fieldInfos = fieldInfoArray;
    }

    protected void serialize(LittleEndianOutput littleEndianOutput) {
        for (int i = 0; i < this._fieldInfos.length; ++i) {
            this._fieldInfos[i].serialize(littleEndianOutput);
        }
    }

    protected int getDataSize() {
        return this._fieldInfos.length * 6;
    }

    public short getSid() {
        return 182;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SXPI]\n");
        for (int i = 0; i < this._fieldInfos.length; ++i) {
            stringBuffer.append("    item[").append(i).append("]=");
            this._fieldInfos[i].appendDebugInfo(stringBuffer);
            stringBuffer.append('\n');
        }
        stringBuffer.append("[/SXPI]\n");
        return stringBuffer.toString();
    }

    private static final class FieldInfo {
        public static final int ENCODED_SIZE = 6;
        private int _isxvi;
        private int _isxvd;
        private int _idObj;

        public FieldInfo(RecordInputStream recordInputStream) {
            this._isxvi = recordInputStream.readShort();
            this._isxvd = recordInputStream.readShort();
            this._idObj = recordInputStream.readShort();
        }

        protected void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeShort(this._isxvi);
            littleEndianOutput.writeShort(this._isxvd);
            littleEndianOutput.writeShort(this._idObj);
        }

        public void appendDebugInfo(StringBuffer stringBuffer) {
            stringBuffer.append('(');
            stringBuffer.append("isxvi=").append(HexDump.shortToHex(this._isxvi));
            stringBuffer.append(" isxvd=").append(HexDump.shortToHex(this._isxvd));
            stringBuffer.append(" idObj=").append(HexDump.shortToHex(this._idObj));
            stringBuffer.append(')');
        }
    }
}

