/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.pivottable;

import ai.org.apache.poi.hssf.record.RecordFormatException;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.StringUtil;

public final class ExtendedPivotTableViewFieldsRecord
extends StandardRecord {
    public static final short sid = 256;
    private static final int STRING_NOT_PRESENT_LEN = 65535;
    private int _grbit1;
    private int _grbit2;
    private int _citmShow;
    private int _isxdiSort;
    private int _isxdiShow;
    private int _reserved1;
    private int _reserved2;
    private String _subtotalName;

    public ExtendedPivotTableViewFieldsRecord(RecordInputStream recordInputStream) {
        this._grbit1 = recordInputStream.readInt();
        this._grbit2 = recordInputStream.readUByte();
        this._citmShow = recordInputStream.readUByte();
        this._isxdiSort = recordInputStream.readUShort();
        this._isxdiShow = recordInputStream.readUShort();
        switch (recordInputStream.remaining()) {
            case 0: {
                this._reserved1 = 0;
                this._reserved2 = 0;
                this._subtotalName = null;
                return;
            }
            case 10: {
                break;
            }
            default: {
                throw new RecordFormatException("Unexpected remaining size (" + recordInputStream.remaining() + ")");
            }
        }
        int n = recordInputStream.readUShort();
        this._reserved1 = recordInputStream.readInt();
        this._reserved2 = recordInputStream.readInt();
        if (n != 65535) {
            this._subtotalName = recordInputStream.readUnicodeLEString(n);
        }
    }

    protected void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this._grbit1);
        littleEndianOutput.writeByte(this._grbit2);
        littleEndianOutput.writeByte(this._citmShow);
        littleEndianOutput.writeShort(this._isxdiSort);
        littleEndianOutput.writeShort(this._isxdiShow);
        if (this._subtotalName == null) {
            littleEndianOutput.writeShort(65535);
        } else {
            littleEndianOutput.writeShort(this._subtotalName.length());
        }
        littleEndianOutput.writeInt(this._reserved1);
        littleEndianOutput.writeInt(this._reserved2);
        if (this._subtotalName != null) {
            StringUtil.putUnicodeLE(this._subtotalName, littleEndianOutput);
        }
    }

    protected int getDataSize() {
        return 20 + (this._subtotalName == null ? 0 : 2 * this._subtotalName.length());
    }

    public short getSid() {
        return 256;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SXVDEX]\n");
        stringBuffer.append("    .grbit1 =").append(HexDump.intToHex(this._grbit1)).append("\n");
        stringBuffer.append("    .grbit2 =").append(HexDump.byteToHex(this._grbit2)).append("\n");
        stringBuffer.append("    .citmShow =").append(HexDump.byteToHex(this._citmShow)).append("\n");
        stringBuffer.append("    .isxdiSort =").append(HexDump.shortToHex(this._isxdiSort)).append("\n");
        stringBuffer.append("    .isxdiShow =").append(HexDump.shortToHex(this._isxdiShow)).append("\n");
        stringBuffer.append("    .subtotalName =").append(this._subtotalName).append("\n");
        stringBuffer.append("[/SXVDEX]\n");
        return stringBuffer.toString();
    }
}

