/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.crypto;

import ai.org.apache.poi.hssf.record.crypto.Biff8Cipher;
import ai.org.apache.poi.hssf.record.crypto.Biff8XORKey;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Biff8XOR
implements Biff8Cipher {
    private final Biff8XORKey _key;
    private ByteBuffer _buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
    private boolean _shouldSkipEncryptionOnCurrentRecord;
    private final int _initialOffset;
    private int _dataLength = 0;
    private int _xorArrayIndex = 0;

    public Biff8XOR(int n, Biff8XORKey biff8XORKey) {
        this._key = biff8XORKey;
        this._initialOffset = n;
    }

    public void startRecord(int n) {
        this._shouldSkipEncryptionOnCurrentRecord = Biff8XOR.isNeverEncryptedRecord(n);
    }

    public void setNextRecordSize(int n) {
        this._xorArrayIndex = (this._initialOffset + this._dataLength + n) % 16;
    }

    private static boolean isNeverEncryptedRecord(int n) {
        switch (n) {
            case 47: 
            case 225: 
            case 2057: {
                return true;
            }
        }
        return false;
    }

    public void skipTwoBytes() {
        this._dataLength += 2;
    }

    public void xor(byte[] byArray, int n, int n2) {
        if (this._shouldSkipEncryptionOnCurrentRecord) {
            this._dataLength += n2;
            return;
        }
        byte[] byArray2 = this._key._secretKey.getEncoded();
        for (int i = 0; i < n2; ++i) {
            byte by = byArray[n + i];
            by = Biff8XOR.rotateLeft(by, 3);
            byArray[n + i] = by = (byte)(by ^ byArray2[this._xorArrayIndex]);
            this._xorArrayIndex = (this._xorArrayIndex + 1) % 16;
            ++this._dataLength;
        }
    }

    private static byte rotateLeft(byte by, int n) {
        return (byte)((by & 0xFF) << n | (by & 0xFF) >>> 8 - n);
    }

    public int xorByte(int n) {
        this._buffer.put(0, (byte)n);
        this.xor(this._buffer.array(), 0, 1);
        return this._buffer.get(0);
    }

    public int xorShort(int n) {
        this._buffer.putShort(0, (short)n);
        this.xor(this._buffer.array(), 0, 2);
        return this._buffer.getShort(0);
    }

    public int xorInt(int n) {
        this._buffer.putInt(0, n);
        this.xor(this._buffer.array(), 0, 4);
        return this._buffer.getInt(0);
    }

    public long xorLong(long l) {
        this._buffer.putLong(0, l);
        this.xor(this._buffer.array(), 0, 8);
        return this._buffer.getLong(0);
    }
}

