/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.crypto;

import ai.org.apache.poi.EncryptedDocumentException;
import ai.org.apache.poi.hssf.record.crypto.Biff8Cipher;
import ai.org.apache.poi.hssf.record.crypto.Biff8RC4Key;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;

final class Biff8RC4
implements Biff8Cipher {
    private static final int RC4_REKEYING_INTERVAL = 1024;
    private Cipher _rc4;
    private int _streamPos;
    private int _nextRC4BlockStart;
    private int _currentKeyIndex;
    private boolean _shouldSkipEncryptionOnCurrentRecord;
    private final Biff8RC4Key _key;
    private ByteBuffer _buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);

    public Biff8RC4(int n, Biff8RC4Key biff8RC4Key) {
        if (n >= 1024) {
            throw new RuntimeException("initialOffset (" + n + ")>" + 1024 + " not supported yet");
        }
        this._key = biff8RC4Key;
        this._rc4 = this._key.getCipher();
        this._streamPos = 0;
        this.rekeyForNextBlock();
        this._streamPos = n;
        this._shouldSkipEncryptionOnCurrentRecord = false;
        this.encryptBytes(new byte[n], 0, n);
    }

    private void rekeyForNextBlock() {
        this._currentKeyIndex = this._streamPos / 1024;
        this._key.initCipherForBlock(this._rc4, this._currentKeyIndex);
        this._nextRC4BlockStart = (this._currentKeyIndex + 1) * 1024;
    }

    private void encryptBytes(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (this._shouldSkipEncryptionOnCurrentRecord) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            byArray = byArray2;
            n = 0;
        }
        try {
            this._rc4.update(byArray, n, n2, byArray, n);
        }
        catch (ShortBufferException shortBufferException) {
            throw new EncryptedDocumentException("input buffer too small", shortBufferException);
        }
    }

    public void startRecord(int n) {
        this._shouldSkipEncryptionOnCurrentRecord = Biff8RC4.isNeverEncryptedRecord(n);
    }

    private static boolean isNeverEncryptedRecord(int n) {
        switch (n) {
            case 47: 
            case 225: 
            case 2057: {
                return true;
            }
        }
        return false;
    }

    public void skipTwoBytes() {
        this.xor(this._buffer.array(), 0, 2);
    }

    public void xor(byte[] byArray, int n, int n2) {
        int n3 = this._nextRC4BlockStart - this._streamPos;
        if (n2 <= n3) {
            this.encryptBytes(byArray, n, n2);
            this._streamPos += n2;
            return;
        }
        int n4 = n;
        int n5 = n2;
        if (n5 > n3) {
            if (n3 > 0) {
                this.encryptBytes(byArray, n4, n3);
                this._streamPos += n3;
                n4 += n3;
                n5 -= n3;
            }
            this.rekeyForNextBlock();
        }
        while (n5 > 1024) {
            this.encryptBytes(byArray, n4, 1024);
            this._streamPos += 1024;
            n4 += 1024;
            n5 -= 1024;
            this.rekeyForNextBlock();
        }
        this.encryptBytes(byArray, n4, n5);
        this._streamPos += n5;
    }

    public int xorByte(int n) {
        this._buffer.put(0, (byte)n);
        this.xor(this._buffer.array(), 0, 1);
        return this._buffer.get(0);
    }

    public int xorShort(int n) {
        this._buffer.putShort(0, (short)n);
        this.xor(this._buffer.array(), 0, 2);
        return this._buffer.getShort(0);
    }

    public int xorInt(int n) {
        this._buffer.putInt(0, n);
        this.xor(this._buffer.array(), 0, 4);
        return this._buffer.getInt(0);
    }

    public long xorLong(long l) {
        this._buffer.putLong(0, l);
        this.xor(this._buffer.array(), 0, 8);
        return this._buffer.getLong(0);
    }

    public void setNextRecordSize(int n) {
    }
}

