/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.chart;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.ss.formula.Formula;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import ai.org.apache.poi.util.BitField;
import ai.org.apache.poi.util.BitFieldFactory;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class LinkedDataRecord
extends StandardRecord {
    public static final short sid = 4177;
    private static final BitField customNumberFormat = BitFieldFactory.getInstance(1);
    private byte field_1_linkType;
    public static final byte LINK_TYPE_TITLE_OR_TEXT = 0;
    public static final byte LINK_TYPE_VALUES = 1;
    public static final byte LINK_TYPE_CATEGORIES = 2;
    private byte field_2_referenceType;
    public static final byte REFERENCE_TYPE_DEFAULT_CATEGORIES = 0;
    public static final byte REFERENCE_TYPE_DIRECT = 1;
    public static final byte REFERENCE_TYPE_WORKSHEET = 2;
    public static final byte REFERENCE_TYPE_NOT_USED = 3;
    public static final byte REFERENCE_TYPE_ERROR_REPORTED = 4;
    private short field_3_options;
    private short field_4_indexNumberFmtRecord;
    private Formula field_5_formulaOfLink;

    public LinkedDataRecord() {
    }

    public LinkedDataRecord(RecordInputStream recordInputStream) {
        this.field_1_linkType = recordInputStream.readByte();
        this.field_2_referenceType = recordInputStream.readByte();
        this.field_3_options = recordInputStream.readShort();
        this.field_4_indexNumberFmtRecord = recordInputStream.readShort();
        int n = recordInputStream.readUShort();
        this.field_5_formulaOfLink = Formula.read(n, recordInputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[AI]\n");
        stringBuffer.append("    .linkType             = ").append(HexDump.byteToHex(this.getLinkType())).append('\n');
        stringBuffer.append("    .referenceType        = ").append(HexDump.byteToHex(this.getReferenceType())).append('\n');
        stringBuffer.append("    .options              = ").append(HexDump.shortToHex(this.getOptions())).append('\n');
        stringBuffer.append("    .customNumberFormat   = ").append(this.isCustomNumberFormat()).append('\n');
        stringBuffer.append("    .indexNumberFmtRecord = ").append(HexDump.shortToHex(this.getIndexNumberFmtRecord())).append('\n');
        stringBuffer.append("    .formulaOfLink        = ").append('\n');
        Ptg[] ptgArray = this.field_5_formulaOfLink.getTokens();
        for (int i = 0; i < ptgArray.length; ++i) {
            Ptg ptg = ptgArray[i];
            stringBuffer.append(ptg.toString()).append(ptg.getRVAType()).append('\n');
        }
        stringBuffer.append("[/AI]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(this.field_1_linkType);
        littleEndianOutput.writeByte(this.field_2_referenceType);
        littleEndianOutput.writeShort(this.field_3_options);
        littleEndianOutput.writeShort(this.field_4_indexNumberFmtRecord);
        this.field_5_formulaOfLink.serialize(littleEndianOutput);
    }

    protected int getDataSize() {
        return 6 + this.field_5_formulaOfLink.getEncodedSize();
    }

    public short getSid() {
        return 4177;
    }

    public Object clone() {
        LinkedDataRecord linkedDataRecord = new LinkedDataRecord();
        linkedDataRecord.field_1_linkType = this.field_1_linkType;
        linkedDataRecord.field_2_referenceType = this.field_2_referenceType;
        linkedDataRecord.field_3_options = this.field_3_options;
        linkedDataRecord.field_4_indexNumberFmtRecord = this.field_4_indexNumberFmtRecord;
        linkedDataRecord.field_5_formulaOfLink = this.field_5_formulaOfLink.copy();
        return linkedDataRecord;
    }

    public byte getLinkType() {
        return this.field_1_linkType;
    }

    public void setLinkType(byte by) {
        this.field_1_linkType = by;
    }

    public byte getReferenceType() {
        return this.field_2_referenceType;
    }

    public void setReferenceType(byte by) {
        this.field_2_referenceType = by;
    }

    public short getOptions() {
        return this.field_3_options;
    }

    public void setOptions(short s) {
        this.field_3_options = s;
    }

    public short getIndexNumberFmtRecord() {
        return this.field_4_indexNumberFmtRecord;
    }

    public void setIndexNumberFmtRecord(short s) {
        this.field_4_indexNumberFmtRecord = s;
    }

    public Ptg[] getFormulaOfLink() {
        return this.field_5_formulaOfLink.getTokens();
    }

    public void setFormulaOfLink(Ptg[] ptgArray) {
        this.field_5_formulaOfLink = Formula.create(ptgArray);
    }

    public void setCustomNumberFormat(boolean bl) {
        this.field_3_options = customNumberFormat.setShortBoolean(this.field_3_options, bl);
    }

    public boolean isCustomNumberFormat() {
        return customNumberFormat.isSet(this.field_3_options);
    }
}

