/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.chart;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class ChartRecord
extends StandardRecord {
    public static final short sid = 4098;
    private int field_1_x;
    private int field_2_y;
    private int field_3_width;
    private int field_4_height;

    public ChartRecord() {
    }

    public ChartRecord(RecordInputStream recordInputStream) {
        this.field_1_x = recordInputStream.readInt();
        this.field_2_y = recordInputStream.readInt();
        this.field_3_width = recordInputStream.readInt();
        this.field_4_height = recordInputStream.readInt();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CHART]\n");
        stringBuffer.append("    .x     = ").append(this.getX()).append('\n');
        stringBuffer.append("    .y     = ").append(this.getY()).append('\n');
        stringBuffer.append("    .width = ").append(this.getWidth()).append('\n');
        stringBuffer.append("    .height= ").append(this.getHeight()).append('\n');
        stringBuffer.append("[/CHART]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this.field_1_x);
        littleEndianOutput.writeInt(this.field_2_y);
        littleEndianOutput.writeInt(this.field_3_width);
        littleEndianOutput.writeInt(this.field_4_height);
    }

    protected int getDataSize() {
        return 16;
    }

    public short getSid() {
        return 4098;
    }

    public Object clone() {
        ChartRecord chartRecord = new ChartRecord();
        chartRecord.field_1_x = this.field_1_x;
        chartRecord.field_2_y = this.field_2_y;
        chartRecord.field_3_width = this.field_3_width;
        chartRecord.field_4_height = this.field_4_height;
        return chartRecord;
    }

    public int getX() {
        return this.field_1_x;
    }

    public void setX(int n) {
        this.field_1_x = n;
    }

    public int getY() {
        return this.field_2_y;
    }

    public void setY(int n) {
        this.field_2_y = n;
    }

    public int getWidth() {
        return this.field_3_width;
    }

    public void setWidth(int n) {
        this.field_3_width = n;
    }

    public int getHeight() {
        return this.field_4_height;
    }

    public void setHeight(int n) {
        this.field_4_height = n;
    }
}

