/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.chart;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.BitField;
import ai.org.apache.poi.util.BitFieldFactory;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class AxisOptionsRecord
extends StandardRecord {
    public static final short sid = 4194;
    private static final BitField defaultMinimum = BitFieldFactory.getInstance(1);
    private static final BitField defaultMaximum = BitFieldFactory.getInstance(2);
    private static final BitField defaultMajor = BitFieldFactory.getInstance(4);
    private static final BitField defaultMinorUnit = BitFieldFactory.getInstance(8);
    private static final BitField isDate = BitFieldFactory.getInstance(16);
    private static final BitField defaultBase = BitFieldFactory.getInstance(32);
    private static final BitField defaultCross = BitFieldFactory.getInstance(64);
    private static final BitField defaultDateSettings = BitFieldFactory.getInstance(128);
    private short field_1_minimumCategory;
    private short field_2_maximumCategory;
    private short field_3_majorUnitValue;
    private short field_4_majorUnit;
    private short field_5_minorUnitValue;
    private short field_6_minorUnit;
    private short field_7_baseUnit;
    private short field_8_crossingPoint;
    private short field_9_options;

    public AxisOptionsRecord() {
    }

    public AxisOptionsRecord(RecordInputStream recordInputStream) {
        this.field_1_minimumCategory = recordInputStream.readShort();
        this.field_2_maximumCategory = recordInputStream.readShort();
        this.field_3_majorUnitValue = recordInputStream.readShort();
        this.field_4_majorUnit = recordInputStream.readShort();
        this.field_5_minorUnitValue = recordInputStream.readShort();
        this.field_6_minorUnit = recordInputStream.readShort();
        this.field_7_baseUnit = recordInputStream.readShort();
        this.field_8_crossingPoint = recordInputStream.readShort();
        this.field_9_options = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[AXCEXT]\n");
        stringBuffer.append("    .minimumCategory      = ").append("0x").append(HexDump.toHex(this.getMinimumCategory())).append(" (").append(this.getMinimumCategory()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .maximumCategory      = ").append("0x").append(HexDump.toHex(this.getMaximumCategory())).append(" (").append(this.getMaximumCategory()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .majorUnitValue       = ").append("0x").append(HexDump.toHex(this.getMajorUnitValue())).append(" (").append(this.getMajorUnitValue()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .majorUnit            = ").append("0x").append(HexDump.toHex(this.getMajorUnit())).append(" (").append(this.getMajorUnit()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .minorUnitValue       = ").append("0x").append(HexDump.toHex(this.getMinorUnitValue())).append(" (").append(this.getMinorUnitValue()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .minorUnit            = ").append("0x").append(HexDump.toHex(this.getMinorUnit())).append(" (").append(this.getMinorUnit()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .baseUnit             = ").append("0x").append(HexDump.toHex(this.getBaseUnit())).append(" (").append(this.getBaseUnit()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .crossingPoint        = ").append("0x").append(HexDump.toHex(this.getCrossingPoint())).append(" (").append(this.getCrossingPoint()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .defaultMinimum           = ").append(this.isDefaultMinimum()).append('\n');
        stringBuffer.append("         .defaultMaximum           = ").append(this.isDefaultMaximum()).append('\n');
        stringBuffer.append("         .defaultMajor             = ").append(this.isDefaultMajor()).append('\n');
        stringBuffer.append("         .defaultMinorUnit         = ").append(this.isDefaultMinorUnit()).append('\n');
        stringBuffer.append("         .isDate                   = ").append(this.isIsDate()).append('\n');
        stringBuffer.append("         .defaultBase              = ").append(this.isDefaultBase()).append('\n');
        stringBuffer.append("         .defaultCross             = ").append(this.isDefaultCross()).append('\n');
        stringBuffer.append("         .defaultDateSettings      = ").append(this.isDefaultDateSettings()).append('\n');
        stringBuffer.append("[/AXCEXT]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_minimumCategory);
        littleEndianOutput.writeShort(this.field_2_maximumCategory);
        littleEndianOutput.writeShort(this.field_3_majorUnitValue);
        littleEndianOutput.writeShort(this.field_4_majorUnit);
        littleEndianOutput.writeShort(this.field_5_minorUnitValue);
        littleEndianOutput.writeShort(this.field_6_minorUnit);
        littleEndianOutput.writeShort(this.field_7_baseUnit);
        littleEndianOutput.writeShort(this.field_8_crossingPoint);
        littleEndianOutput.writeShort(this.field_9_options);
    }

    protected int getDataSize() {
        return 18;
    }

    public short getSid() {
        return 4194;
    }

    public Object clone() {
        AxisOptionsRecord axisOptionsRecord = new AxisOptionsRecord();
        axisOptionsRecord.field_1_minimumCategory = this.field_1_minimumCategory;
        axisOptionsRecord.field_2_maximumCategory = this.field_2_maximumCategory;
        axisOptionsRecord.field_3_majorUnitValue = this.field_3_majorUnitValue;
        axisOptionsRecord.field_4_majorUnit = this.field_4_majorUnit;
        axisOptionsRecord.field_5_minorUnitValue = this.field_5_minorUnitValue;
        axisOptionsRecord.field_6_minorUnit = this.field_6_minorUnit;
        axisOptionsRecord.field_7_baseUnit = this.field_7_baseUnit;
        axisOptionsRecord.field_8_crossingPoint = this.field_8_crossingPoint;
        axisOptionsRecord.field_9_options = this.field_9_options;
        return axisOptionsRecord;
    }

    public short getMinimumCategory() {
        return this.field_1_minimumCategory;
    }

    public void setMinimumCategory(short s) {
        this.field_1_minimumCategory = s;
    }

    public short getMaximumCategory() {
        return this.field_2_maximumCategory;
    }

    public void setMaximumCategory(short s) {
        this.field_2_maximumCategory = s;
    }

    public short getMajorUnitValue() {
        return this.field_3_majorUnitValue;
    }

    public void setMajorUnitValue(short s) {
        this.field_3_majorUnitValue = s;
    }

    public short getMajorUnit() {
        return this.field_4_majorUnit;
    }

    public void setMajorUnit(short s) {
        this.field_4_majorUnit = s;
    }

    public short getMinorUnitValue() {
        return this.field_5_minorUnitValue;
    }

    public void setMinorUnitValue(short s) {
        this.field_5_minorUnitValue = s;
    }

    public short getMinorUnit() {
        return this.field_6_minorUnit;
    }

    public void setMinorUnit(short s) {
        this.field_6_minorUnit = s;
    }

    public short getBaseUnit() {
        return this.field_7_baseUnit;
    }

    public void setBaseUnit(short s) {
        this.field_7_baseUnit = s;
    }

    public short getCrossingPoint() {
        return this.field_8_crossingPoint;
    }

    public void setCrossingPoint(short s) {
        this.field_8_crossingPoint = s;
    }

    public short getOptions() {
        return this.field_9_options;
    }

    public void setOptions(short s) {
        this.field_9_options = s;
    }

    public void setDefaultMinimum(boolean bl) {
        this.field_9_options = defaultMinimum.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isDefaultMinimum() {
        return defaultMinimum.isSet(this.field_9_options);
    }

    public void setDefaultMaximum(boolean bl) {
        this.field_9_options = defaultMaximum.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isDefaultMaximum() {
        return defaultMaximum.isSet(this.field_9_options);
    }

    public void setDefaultMajor(boolean bl) {
        this.field_9_options = defaultMajor.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isDefaultMajor() {
        return defaultMajor.isSet(this.field_9_options);
    }

    public void setDefaultMinorUnit(boolean bl) {
        this.field_9_options = defaultMinorUnit.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isDefaultMinorUnit() {
        return defaultMinorUnit.isSet(this.field_9_options);
    }

    public void setIsDate(boolean bl) {
        this.field_9_options = isDate.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isIsDate() {
        return isDate.isSet(this.field_9_options);
    }

    public void setDefaultBase(boolean bl) {
        this.field_9_options = defaultBase.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isDefaultBase() {
        return defaultBase.isSet(this.field_9_options);
    }

    public void setDefaultCross(boolean bl) {
        this.field_9_options = defaultCross.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isDefaultCross() {
        return defaultCross.isSet(this.field_9_options);
    }

    public void setDefaultDateSettings(boolean bl) {
        this.field_9_options = defaultDateSettings.setShortBoolean(this.field_9_options, bl);
    }

    public boolean isDefaultDateSettings() {
        return defaultDateSettings.isSet(this.field_9_options);
    }
}

