/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.cf;

import ai.org.apache.poi.ss.util.CellRangeAddress;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CellRangeUtil {
    public static final int NO_INTERSECTION = 1;
    public static final int OVERLAP = 2;
    public static final int INSIDE = 3;
    public static final int ENCLOSES = 4;

    private CellRangeUtil() {
    }

    public static int intersect(CellRangeAddress cellRangeAddress, CellRangeAddress cellRangeAddress2) {
        int n = cellRangeAddress2.getFirstRow();
        int n2 = cellRangeAddress2.getLastRow();
        int n3 = cellRangeAddress2.getFirstColumn();
        int n4 = cellRangeAddress2.getLastColumn();
        if (CellRangeUtil.gt(cellRangeAddress.getFirstRow(), n2) || CellRangeUtil.lt(cellRangeAddress.getLastRow(), n) || CellRangeUtil.gt(cellRangeAddress.getFirstColumn(), n4) || CellRangeUtil.lt(cellRangeAddress.getLastColumn(), n3)) {
            return 1;
        }
        if (CellRangeUtil.contains(cellRangeAddress, cellRangeAddress2)) {
            return 3;
        }
        if (CellRangeUtil.contains(cellRangeAddress2, cellRangeAddress)) {
            return 4;
        }
        return 2;
    }

    public static CellRangeAddress[] mergeCellRanges(CellRangeAddress[] cellRangeAddressArray) {
        if (cellRangeAddressArray.length < 1) {
            return cellRangeAddressArray;
        }
        ArrayList<CellRangeAddress> arrayList = new ArrayList<CellRangeAddress>();
        for (CellRangeAddress cellRangeAddress : cellRangeAddressArray) {
            arrayList.add(cellRangeAddress);
        }
        List<CellRangeAddress> list = CellRangeUtil.mergeCellRanges(arrayList);
        return CellRangeUtil.toArray(list);
    }

    private static List<CellRangeAddress> mergeCellRanges(List<CellRangeAddress> list) {
        while (list.size() > 1) {
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                CellRangeAddress cellRangeAddress = list.get(i);
                for (int j = i + 1; j < list.size(); ++j) {
                    CellRangeAddress cellRangeAddress2 = list.get(j);
                    CellRangeAddress[] cellRangeAddressArray = CellRangeUtil.mergeRanges(cellRangeAddress, cellRangeAddress2);
                    if (cellRangeAddressArray == null) continue;
                    bl = true;
                    list.set(i, cellRangeAddressArray[0]);
                    list.remove(j--);
                    for (int k = 1; k < cellRangeAddressArray.length; ++k) {
                        list.add(++j, cellRangeAddressArray[k]);
                    }
                }
            }
            if (bl) continue;
            break;
        }
        return list;
    }

    private static CellRangeAddress[] mergeRanges(CellRangeAddress cellRangeAddress, CellRangeAddress cellRangeAddress2) {
        int n = CellRangeUtil.intersect(cellRangeAddress, cellRangeAddress2);
        switch (n) {
            case 1: {
                if (CellRangeUtil.hasExactSharedBorder(cellRangeAddress, cellRangeAddress2)) {
                    return new CellRangeAddress[]{CellRangeUtil.createEnclosingCellRange(cellRangeAddress, cellRangeAddress2)};
                }
                return null;
            }
            case 2: {
                return null;
            }
            case 3: {
                return new CellRangeAddress[]{cellRangeAddress};
            }
            case 4: {
                return new CellRangeAddress[]{cellRangeAddress2};
            }
        }
        throw new RuntimeException("unexpected intersection result (" + n + ")");
    }

    private static CellRangeAddress[] toArray(List<CellRangeAddress> list) {
        CellRangeAddress[] cellRangeAddressArray = new CellRangeAddress[list.size()];
        list.toArray(cellRangeAddressArray);
        return cellRangeAddressArray;
    }

    public static boolean contains(CellRangeAddress cellRangeAddress, CellRangeAddress cellRangeAddress2) {
        int n = cellRangeAddress2.getFirstRow();
        int n2 = cellRangeAddress2.getLastRow();
        int n3 = cellRangeAddress2.getFirstColumn();
        int n4 = cellRangeAddress2.getLastColumn();
        return CellRangeUtil.le(cellRangeAddress.getFirstRow(), n) && CellRangeUtil.ge(cellRangeAddress.getLastRow(), n2) && CellRangeUtil.le(cellRangeAddress.getFirstColumn(), n3) && CellRangeUtil.ge(cellRangeAddress.getLastColumn(), n4);
    }

    public static boolean hasExactSharedBorder(CellRangeAddress cellRangeAddress, CellRangeAddress cellRangeAddress2) {
        int n = cellRangeAddress2.getFirstRow();
        int n2 = cellRangeAddress2.getLastRow();
        int n3 = cellRangeAddress2.getFirstColumn();
        int n4 = cellRangeAddress2.getLastColumn();
        if (cellRangeAddress.getFirstRow() > 0 && cellRangeAddress.getFirstRow() - 1 == n2 || n > 0 && n - 1 == cellRangeAddress.getLastRow()) {
            return cellRangeAddress.getFirstColumn() == n3 && cellRangeAddress.getLastColumn() == n4;
        }
        if (cellRangeAddress.getFirstColumn() > 0 && cellRangeAddress.getFirstColumn() - 1 == n4 || n3 > 0 && cellRangeAddress.getLastColumn() == n3 - 1) {
            return cellRangeAddress.getFirstRow() == n && cellRangeAddress.getLastRow() == n2;
        }
        return false;
    }

    public static CellRangeAddress createEnclosingCellRange(CellRangeAddress cellRangeAddress, CellRangeAddress cellRangeAddress2) {
        if (cellRangeAddress2 == null) {
            return cellRangeAddress.copy();
        }
        return new CellRangeAddress(CellRangeUtil.lt(cellRangeAddress2.getFirstRow(), cellRangeAddress.getFirstRow()) ? cellRangeAddress2.getFirstRow() : cellRangeAddress.getFirstRow(), CellRangeUtil.gt(cellRangeAddress2.getLastRow(), cellRangeAddress.getLastRow()) ? cellRangeAddress2.getLastRow() : cellRangeAddress.getLastRow(), CellRangeUtil.lt(cellRangeAddress2.getFirstColumn(), cellRangeAddress.getFirstColumn()) ? cellRangeAddress2.getFirstColumn() : cellRangeAddress.getFirstColumn(), CellRangeUtil.gt(cellRangeAddress2.getLastColumn(), cellRangeAddress.getLastColumn()) ? cellRangeAddress2.getLastColumn() : cellRangeAddress.getLastColumn());
    }

    private static boolean lt(int n, int n2) {
        return n == -1 ? false : (n2 == -1 ? true : n < n2);
    }

    private static boolean le(int n, int n2) {
        return n == n2 || CellRangeUtil.lt(n, n2);
    }

    private static boolean gt(int n, int n2) {
        return CellRangeUtil.lt(n2, n);
    }

    private static boolean ge(int n, int n2) {
        return !CellRangeUtil.lt(n, n2);
    }
}

