/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.aggregates;

import ai.org.apache.poi.hssf.model.RecordStream;
import ai.org.apache.poi.hssf.record.CFHeaderRecord;
import ai.org.apache.poi.hssf.record.CFRuleRecord;
import ai.org.apache.poi.hssf.record.Record;
import ai.org.apache.poi.hssf.record.aggregates.RecordAggregate;
import ai.org.apache.poi.ss.formula.FormulaShifter;
import ai.org.apache.poi.ss.formula.ptg.AreaErrPtg;
import ai.org.apache.poi.ss.formula.ptg.AreaPtg;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import ai.org.apache.poi.ss.util.CellRangeAddress;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import java.util.ArrayList;
import java.util.List;

public final class CFRecordsAggregate
extends RecordAggregate {
    private static final int MAX_97_2003_CONDTIONAL_FORMAT_RULES = 3;
    private static final POILogger logger = POILogFactory.getLogger(CFRecordsAggregate.class);
    private final CFHeaderRecord header;
    private final List<CFRuleRecord> rules;

    private CFRecordsAggregate(CFHeaderRecord cFHeaderRecord, CFRuleRecord[] cFRuleRecordArray) {
        if (cFHeaderRecord == null) {
            throw new IllegalArgumentException("header must not be null");
        }
        if (cFRuleRecordArray == null) {
            throw new IllegalArgumentException("rules must not be null");
        }
        if (cFRuleRecordArray.length > 3) {
            logger.log(5, "Excel versions before 2007 require that No more than 3 rules may be specified, " + cFRuleRecordArray.length + " were found," + " this file will cause problems with old Excel versions");
        }
        if (cFRuleRecordArray.length != cFHeaderRecord.getNumberOfConditionalFormats()) {
            throw new RuntimeException("Mismatch number of rules");
        }
        this.header = cFHeaderRecord;
        this.rules = new ArrayList<CFRuleRecord>(3);
        for (int i = 0; i < cFRuleRecordArray.length; ++i) {
            this.rules.add(cFRuleRecordArray[i]);
        }
    }

    public CFRecordsAggregate(CellRangeAddress[] cellRangeAddressArray, CFRuleRecord[] cFRuleRecordArray) {
        this(new CFHeaderRecord(cellRangeAddressArray, cFRuleRecordArray.length), cFRuleRecordArray);
    }

    public static CFRecordsAggregate createCFAggregate(RecordStream recordStream) {
        Record record = recordStream.getNext();
        if (record.getSid() != 432) {
            throw new IllegalStateException("next record sid was " + record.getSid() + " instead of " + 432 + " as expected");
        }
        CFHeaderRecord cFHeaderRecord = (CFHeaderRecord)record;
        int n = cFHeaderRecord.getNumberOfConditionalFormats();
        CFRuleRecord[] cFRuleRecordArray = new CFRuleRecord[n];
        for (int i = 0; i < cFRuleRecordArray.length; ++i) {
            cFRuleRecordArray[i] = (CFRuleRecord)recordStream.getNext();
        }
        return new CFRecordsAggregate(cFHeaderRecord, cFRuleRecordArray);
    }

    public CFRecordsAggregate cloneCFAggregate() {
        CFRuleRecord[] cFRuleRecordArray = new CFRuleRecord[this.rules.size()];
        for (int i = 0; i < cFRuleRecordArray.length; ++i) {
            cFRuleRecordArray[i] = (CFRuleRecord)this.getRule(i).clone();
        }
        return new CFRecordsAggregate((CFHeaderRecord)this.header.clone(), cFRuleRecordArray);
    }

    public CFHeaderRecord getHeader() {
        return this.header;
    }

    private void checkRuleIndex(int n) {
        if (n < 0 || n >= this.rules.size()) {
            throw new IllegalArgumentException("Bad rule record index (" + n + ") nRules=" + this.rules.size());
        }
    }

    public CFRuleRecord getRule(int n) {
        this.checkRuleIndex(n);
        return this.rules.get(n);
    }

    public void setRule(int n, CFRuleRecord cFRuleRecord) {
        if (cFRuleRecord == null) {
            throw new IllegalArgumentException("r must not be null");
        }
        this.checkRuleIndex(n);
        this.rules.set(n, cFRuleRecord);
    }

    public void addRule(CFRuleRecord cFRuleRecord) {
        if (cFRuleRecord == null) {
            throw new IllegalArgumentException("r must not be null");
        }
        if (this.rules.size() >= 3) {
            logger.log(5, "Excel versions before 2007 cannot cope with any more than 3 - this file will cause problems with old Excel versions");
        }
        this.rules.add(cFRuleRecord);
        this.header.setNumberOfConditionalFormats(this.rules.size());
    }

    public int getNumberOfRules() {
        return this.rules.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CF]\n");
        if (this.header != null) {
            stringBuffer.append(this.header.toString());
        }
        for (int i = 0; i < this.rules.size(); ++i) {
            CFRuleRecord cFRuleRecord = this.rules.get(i);
            stringBuffer.append(cFRuleRecord.toString());
        }
        stringBuffer.append("[/CF]\n");
        return stringBuffer.toString();
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        recordVisitor.visitRecord(this.header);
        for (int i = 0; i < this.rules.size(); ++i) {
            CFRuleRecord cFRuleRecord = this.rules.get(i);
            recordVisitor.visitRecord(cFRuleRecord);
        }
    }

    public boolean updateFormulasAfterCellShift(FormulaShifter formulaShifter, int n) {
        Ptg[] ptgArray;
        Object object;
        int n2;
        CellRangeAddress[] cellRangeAddressArray = this.header.getCellRanges();
        boolean bl = false;
        ArrayList<Ptg[]> arrayList = new ArrayList<Ptg[]>();
        for (n2 = 0; n2 < cellRangeAddressArray.length; ++n2) {
            object = cellRangeAddressArray[n2];
            ptgArray = CFRecordsAggregate.shiftRange(formulaShifter, (CellRangeAddress)object, n);
            if (ptgArray == null) {
                bl = true;
                continue;
            }
            arrayList.add(ptgArray);
            if (ptgArray == object) continue;
            bl = true;
        }
        if (bl) {
            n2 = arrayList.size();
            if (n2 == 0) {
                return false;
            }
            object = new CellRangeAddress[n2];
            arrayList.toArray((T[])object);
            this.header.setCellRanges((CellRangeAddress[])object);
        }
        for (n2 = 0; n2 < this.rules.size(); ++n2) {
            object = this.rules.get(n2);
            ptgArray = ((CFRuleRecord)object).getParsedExpression1();
            if (ptgArray != null && formulaShifter.adjustFormula(ptgArray, n)) {
                ((CFRuleRecord)object).setParsedExpression1(ptgArray);
            }
            if ((ptgArray = ((CFRuleRecord)object).getParsedExpression2()) == null || !formulaShifter.adjustFormula(ptgArray, n)) continue;
            ((CFRuleRecord)object).setParsedExpression2(ptgArray);
        }
        return true;
    }

    private static CellRangeAddress shiftRange(FormulaShifter formulaShifter, CellRangeAddress cellRangeAddress, int n) {
        AreaPtg areaPtg = new AreaPtg(cellRangeAddress.getFirstRow(), cellRangeAddress.getLastRow(), cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastColumn(), false, false, false, false);
        Ptg[] ptgArray = new Ptg[]{areaPtg};
        if (!formulaShifter.adjustFormula(ptgArray, n)) {
            return cellRangeAddress;
        }
        Ptg ptg = ptgArray[0];
        if (ptg instanceof AreaPtg) {
            AreaPtg areaPtg2 = (AreaPtg)ptg;
            return new CellRangeAddress(areaPtg2.getFirstRow(), areaPtg2.getLastRow(), areaPtg2.getFirstColumn(), areaPtg2.getLastColumn());
        }
        if (ptg instanceof AreaErrPtg) {
            return null;
        }
        throw new IllegalStateException("Unexpected shifted ptg class (" + ptg.getClass().getName() + ")");
    }
}

