/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.StringUtil;

public final class TableStylesRecord
extends StandardRecord {
    public static final short sid = 2190;
    private int rt;
    private int grbitFrt;
    private byte[] unused = new byte[8];
    private int cts;
    private String rgchDefListStyle;
    private String rgchDefPivotStyle;

    public TableStylesRecord(RecordInputStream recordInputStream) {
        this.rt = recordInputStream.readUShort();
        this.grbitFrt = recordInputStream.readUShort();
        recordInputStream.readFully(this.unused);
        this.cts = recordInputStream.readInt();
        int n = recordInputStream.readUShort();
        int n2 = recordInputStream.readUShort();
        this.rgchDefListStyle = recordInputStream.readUnicodeLEString(n);
        this.rgchDefPivotStyle = recordInputStream.readUnicodeLEString(n2);
    }

    protected void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.rt);
        littleEndianOutput.writeShort(this.grbitFrt);
        littleEndianOutput.write(this.unused);
        littleEndianOutput.writeInt(this.cts);
        littleEndianOutput.writeShort(this.rgchDefListStyle.length());
        littleEndianOutput.writeShort(this.rgchDefPivotStyle.length());
        StringUtil.putUnicodeLE(this.rgchDefListStyle, littleEndianOutput);
        StringUtil.putUnicodeLE(this.rgchDefPivotStyle, littleEndianOutput);
    }

    protected int getDataSize() {
        return 20 + 2 * this.rgchDefListStyle.length() + 2 * this.rgchDefPivotStyle.length();
    }

    public short getSid() {
        return 2190;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[TABLESTYLES]\n");
        stringBuffer.append("    .rt      =").append(HexDump.shortToHex(this.rt)).append('\n');
        stringBuffer.append("    .grbitFrt=").append(HexDump.shortToHex(this.grbitFrt)).append('\n');
        stringBuffer.append("    .unused  =").append(HexDump.toHex(this.unused)).append('\n');
        stringBuffer.append("    .cts=").append(HexDump.intToHex(this.cts)).append('\n');
        stringBuffer.append("    .rgchDefListStyle=").append(this.rgchDefListStyle).append('\n');
        stringBuffer.append("    .rgchDefPivotStyle=").append(this.rgchDefPivotStyle).append('\n');
        stringBuffer.append("[/TABLESTYLES]\n");
        return stringBuffer.toString();
    }
}

