/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.ExtSSTRecord;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.SSTDeserializer;
import ai.org.apache.poi.hssf.record.SSTSerializer;
import ai.org.apache.poi.hssf.record.common.UnicodeString;
import ai.org.apache.poi.hssf.record.cont.ContinuableRecord;
import ai.org.apache.poi.hssf.record.cont.ContinuableRecordOutput;
import ai.org.apache.poi.util.IntMapper;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SSTRecord
extends ContinuableRecord {
    public static final short sid = 252;
    private static final UnicodeString EMPTY_STRING = new UnicodeString("");
    static final int STD_RECORD_OVERHEAD = 4;
    static final int SST_RECORD_OVERHEAD = 12;
    static final int MAX_DATA_SPACE = 8216;
    private int field_1_num_strings;
    private int field_2_num_unique_strings;
    private IntMapper<UnicodeString> field_3_strings;
    private SSTDeserializer deserializer;
    int[] bucketAbsoluteOffsets;
    int[] bucketRelativeOffsets;

    public SSTRecord() {
        this.field_1_num_strings = 0;
        this.field_2_num_unique_strings = 0;
        this.field_3_strings = new IntMapper();
        this.deserializer = new SSTDeserializer(this.field_3_strings);
    }

    public int addString(UnicodeString unicodeString) {
        int n;
        ++this.field_1_num_strings;
        UnicodeString unicodeString2 = unicodeString == null ? EMPTY_STRING : unicodeString;
        int n2 = this.field_3_strings.getIndex(unicodeString2);
        if (n2 != -1) {
            n = n2;
        } else {
            n = this.field_3_strings.size();
            ++this.field_2_num_unique_strings;
            SSTDeserializer.addToStringTable(this.field_3_strings, unicodeString2);
        }
        return n;
    }

    public int getNumStrings() {
        return this.field_1_num_strings;
    }

    public int getNumUniqueStrings() {
        return this.field_2_num_unique_strings;
    }

    public UnicodeString getString(int n) {
        return this.field_3_strings.get(n);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SST]\n");
        stringBuffer.append("    .numstrings     = ").append(Integer.toHexString(this.getNumStrings())).append("\n");
        stringBuffer.append("    .uniquestrings  = ").append(Integer.toHexString(this.getNumUniqueStrings())).append("\n");
        for (int i = 0; i < this.field_3_strings.size(); ++i) {
            UnicodeString unicodeString = this.field_3_strings.get(i);
            stringBuffer.append("    .string_" + i + "      = ").append(unicodeString.getDebugInfo()).append("\n");
        }
        stringBuffer.append("[/SST]\n");
        return stringBuffer.toString();
    }

    @Override
    public short getSid() {
        return 252;
    }

    public SSTRecord(RecordInputStream recordInputStream) {
        this.field_1_num_strings = recordInputStream.readInt();
        this.field_2_num_unique_strings = recordInputStream.readInt();
        this.field_3_strings = new IntMapper();
        this.deserializer = new SSTDeserializer(this.field_3_strings);
        this.deserializer.manufactureStrings(this.field_2_num_unique_strings, recordInputStream);
    }

    Iterator<UnicodeString> getStrings() {
        return this.field_3_strings.iterator();
    }

    int countStrings() {
        return this.field_3_strings.size();
    }

    @Override
    protected void serialize(ContinuableRecordOutput continuableRecordOutput) {
        SSTSerializer sSTSerializer = new SSTSerializer(this.field_3_strings, this.getNumStrings(), this.getNumUniqueStrings());
        sSTSerializer.serialize(continuableRecordOutput);
        this.bucketAbsoluteOffsets = sSTSerializer.getBucketAbsoluteOffsets();
        this.bucketRelativeOffsets = sSTSerializer.getBucketRelativeOffsets();
    }

    SSTDeserializer getDeserializer() {
        return this.deserializer;
    }

    public ExtSSTRecord createExtSSTRecord(int n) {
        if (this.bucketAbsoluteOffsets == null || this.bucketAbsoluteOffsets == null) {
            throw new IllegalStateException("SST record has not yet been serialized.");
        }
        ExtSSTRecord extSSTRecord = new ExtSSTRecord();
        extSSTRecord.setNumStringsPerBucket((short)8);
        int[] nArray = (int[])this.bucketAbsoluteOffsets.clone();
        int[] nArray2 = (int[])this.bucketRelativeOffsets.clone();
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2++;
            nArray[n3] = nArray[n3] + n;
        }
        extSSTRecord.setBucketOffsets(nArray, nArray2);
        return extSSTRecord;
    }

    public int calcExtSSTRecordSize() {
        return ExtSSTRecord.getRecordSizeForStrings(this.field_3_strings.size());
    }
}

