/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class RecalcIdRecord
extends StandardRecord {
    public static final short sid = 449;
    private final int _reserved0;
    private int _engineId;

    public RecalcIdRecord() {
        this._reserved0 = 0;
        this._engineId = 0;
    }

    public RecalcIdRecord(RecordInputStream recordInputStream) {
        recordInputStream.readUShort();
        this._reserved0 = recordInputStream.readUShort();
        this._engineId = recordInputStream.readInt();
    }

    public boolean isNeeded() {
        return true;
    }

    public void setEngineId(int n) {
        this._engineId = n;
    }

    public int getEngineId() {
        return this._engineId;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[RECALCID]\n");
        stringBuffer.append("    .reserved = ").append(HexDump.shortToHex(this._reserved0)).append("\n");
        stringBuffer.append("    .engineId = ").append(HexDump.intToHex(this._engineId)).append("\n");
        stringBuffer.append("[/RECALCID]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(449);
        littleEndianOutput.writeShort(this._reserved0);
        littleEndianOutput.writeInt(this._engineId);
    }

    protected int getDataSize() {
        return 8;
    }

    public short getSid() {
        return 449;
    }
}

