/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.CellRecord;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.ss.util.NumberToTextConverter;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class NumberRecord
extends CellRecord {
    public static final short sid = 515;
    private double field_4_value;

    public NumberRecord() {
    }

    public NumberRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
        this.field_4_value = recordInputStream.readDouble();
    }

    public void setValue(double d) {
        this.field_4_value = d;
    }

    public double getValue() {
        return this.field_4_value;
    }

    protected String getRecordName() {
        return "NUMBER";
    }

    protected void appendValueText(StringBuilder stringBuilder) {
        stringBuilder.append("  .value= ").append(NumberToTextConverter.toText(this.field_4_value));
    }

    protected void serializeValue(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeDouble(this.getValue());
    }

    protected int getValueDataSize() {
        return 8;
    }

    public short getSid() {
        return 515;
    }

    public Object clone() {
        NumberRecord numberRecord = new NumberRecord();
        this.copyBaseFields(numberRecord);
        numberRecord.field_4_value = this.field_4_value;
        return numberRecord;
    }
}

