/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.StringUtil;

public final class NoteRecord
extends StandardRecord {
    public static final short sid = 28;
    public static final NoteRecord[] EMPTY_ARRAY = new NoteRecord[0];
    public static final short NOTE_HIDDEN = 0;
    public static final short NOTE_VISIBLE = 2;
    private static final Byte DEFAULT_PADDING = 0;
    private int field_1_row;
    private int field_2_col;
    private short field_3_flags;
    private int field_4_shapeid;
    private boolean field_5_hasMultibyte;
    private String field_6_author;
    private Byte field_7_padding;

    public NoteRecord() {
        this.field_6_author = "";
        this.field_3_flags = 0;
        this.field_7_padding = DEFAULT_PADDING;
    }

    public short getSid() {
        return 28;
    }

    public NoteRecord(RecordInputStream recordInputStream) {
        this.field_1_row = recordInputStream.readUShort();
        this.field_2_col = recordInputStream.readShort();
        this.field_3_flags = recordInputStream.readShort();
        this.field_4_shapeid = recordInputStream.readUShort();
        short s = recordInputStream.readShort();
        this.field_5_hasMultibyte = recordInputStream.readByte() != 0;
        this.field_6_author = this.field_5_hasMultibyte ? StringUtil.readUnicodeLE(recordInputStream, s) : StringUtil.readCompressedUnicode(recordInputStream, s);
        if (recordInputStream.available() == 1) {
            this.field_7_padding = recordInputStream.readByte();
        } else if (recordInputStream.available() == 2 && s == 0) {
            this.field_7_padding = recordInputStream.readByte();
            recordInputStream.readByte();
        }
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_row);
        littleEndianOutput.writeShort(this.field_2_col);
        littleEndianOutput.writeShort(this.field_3_flags);
        littleEndianOutput.writeShort(this.field_4_shapeid);
        littleEndianOutput.writeShort(this.field_6_author.length());
        littleEndianOutput.writeByte(this.field_5_hasMultibyte ? 1 : 0);
        if (this.field_5_hasMultibyte) {
            StringUtil.putUnicodeLE(this.field_6_author, littleEndianOutput);
        } else {
            StringUtil.putCompressedUnicode(this.field_6_author, littleEndianOutput);
        }
        if (this.field_7_padding != null) {
            littleEndianOutput.writeByte(this.field_7_padding.intValue());
        }
    }

    protected int getDataSize() {
        return 11 + this.field_6_author.length() * (this.field_5_hasMultibyte ? 2 : 1) + (this.field_7_padding == null ? 0 : 1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[NOTE]\n");
        stringBuffer.append("    .row    = ").append(this.field_1_row).append("\n");
        stringBuffer.append("    .col    = ").append(this.field_2_col).append("\n");
        stringBuffer.append("    .flags  = ").append(this.field_3_flags).append("\n");
        stringBuffer.append("    .shapeid= ").append(this.field_4_shapeid).append("\n");
        stringBuffer.append("    .author = ").append(this.field_6_author).append("\n");
        stringBuffer.append("[/NOTE]\n");
        return stringBuffer.toString();
    }

    public int getRow() {
        return this.field_1_row;
    }

    public void setRow(int n) {
        this.field_1_row = n;
    }

    public int getColumn() {
        return this.field_2_col;
    }

    public void setColumn(int n) {
        this.field_2_col = n;
    }

    public short getFlags() {
        return this.field_3_flags;
    }

    public void setFlags(short s) {
        this.field_3_flags = s;
    }

    protected boolean authorIsMultibyte() {
        return this.field_5_hasMultibyte;
    }

    public int getShapeId() {
        return this.field_4_shapeid;
    }

    public void setShapeId(int n) {
        this.field_4_shapeid = n;
    }

    public String getAuthor() {
        return this.field_6_author;
    }

    public void setAuthor(String string) {
        this.field_6_author = string;
        this.field_5_hasMultibyte = StringUtil.hasMultibyte(string);
    }

    public Object clone() {
        NoteRecord noteRecord = new NoteRecord();
        noteRecord.field_1_row = this.field_1_row;
        noteRecord.field_2_col = this.field_2_col;
        noteRecord.field_3_flags = this.field_3_flags;
        noteRecord.field_4_shapeid = this.field_4_shapeid;
        noteRecord.field_6_author = this.field_6_author;
        return noteRecord;
    }
}

