/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.StringUtil;

public abstract class HeaderFooterBase
extends StandardRecord {
    private boolean field_2_hasMultibyte;
    private String field_3_text;

    protected HeaderFooterBase(String string) {
        this.setText(string);
    }

    protected HeaderFooterBase(RecordInputStream recordInputStream) {
        if (recordInputStream.remaining() > 0) {
            short s = recordInputStream.readShort();
            boolean bl = this.field_2_hasMultibyte = recordInputStream.readByte() != 0;
            this.field_3_text = this.field_2_hasMultibyte ? recordInputStream.readUnicodeLEString(s) : recordInputStream.readCompressedUnicode(s);
        } else {
            this.field_3_text = "";
        }
    }

    public final void setText(String string) {
        if (string == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        this.field_2_hasMultibyte = StringUtil.hasMultibyte(string);
        this.field_3_text = string;
        if (this.getDataSize() > 8224) {
            throw new IllegalArgumentException("Header/Footer string too long (limit is 8224 bytes)");
        }
    }

    private int getTextLength() {
        return this.field_3_text.length();
    }

    public final String getText() {
        return this.field_3_text;
    }

    public final void serialize(LittleEndianOutput littleEndianOutput) {
        if (this.getTextLength() > 0) {
            littleEndianOutput.writeShort(this.getTextLength());
            littleEndianOutput.writeByte(this.field_2_hasMultibyte ? 1 : 0);
            if (this.field_2_hasMultibyte) {
                StringUtil.putUnicodeLE(this.field_3_text, littleEndianOutput);
            } else {
                StringUtil.putCompressedUnicode(this.field_3_text, littleEndianOutput);
            }
        }
    }

    protected final int getDataSize() {
        if (this.getTextLength() < 1) {
            return 0;
        }
        return 3 + this.getTextLength() * (this.field_2_hasMultibyte ? 2 : 1);
    }
}

