/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordFormatException;
import ai.org.apache.poi.hssf.record.SubRecord;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianInput;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class FtCfSubRecord
extends SubRecord {
    public static final short sid = 7;
    public static final short length = 2;
    public static final short METAFILE_BIT = 2;
    public static final short BITMAP_BIT = 9;
    public static final short UNSPECIFIED_BIT = -1;
    private short flags = 0;

    public FtCfSubRecord() {
    }

    public FtCfSubRecord(LittleEndianInput littleEndianInput, int n) {
        if (n != 2) {
            throw new RecordFormatException("Unexpected size (" + n + ")");
        }
        this.flags = littleEndianInput.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FtCf ]\n");
        stringBuffer.append("  size     = ").append(2).append("\n");
        stringBuffer.append("  flags    = ").append(HexDump.toHex(this.flags)).append("\n");
        stringBuffer.append("[/FtCf ]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(7);
        littleEndianOutput.writeShort(2);
        littleEndianOutput.writeShort(this.flags);
    }

    protected int getDataSize() {
        return 2;
    }

    public short getSid() {
        return 7;
    }

    public Object clone() {
        FtCfSubRecord ftCfSubRecord = new FtCfSubRecord();
        ftCfSubRecord.flags = this.flags;
        return ftCfSubRecord;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short s) {
        this.flags = s;
    }
}

