/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.StringUtil;

public final class FormatRecord
extends StandardRecord {
    public static final short sid = 1054;
    private final int field_1_index_code;
    private final boolean field_3_hasMultibyte;
    private final String field_4_formatstring;

    public FormatRecord(int n, String string) {
        this.field_1_index_code = n;
        this.field_4_formatstring = string;
        this.field_3_hasMultibyte = StringUtil.hasMultibyte(string);
    }

    public FormatRecord(RecordInputStream recordInputStream) {
        this.field_1_index_code = recordInputStream.readShort();
        int n = recordInputStream.readUShort();
        this.field_3_hasMultibyte = (recordInputStream.readByte() & 1) != 0;
        this.field_4_formatstring = this.field_3_hasMultibyte ? recordInputStream.readUnicodeLEString(n) : recordInputStream.readCompressedUnicode(n);
    }

    public int getIndexCode() {
        return this.field_1_index_code;
    }

    public String getFormatString() {
        return this.field_4_formatstring;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FORMAT]\n");
        stringBuffer.append("    .indexcode       = ").append(HexDump.shortToHex(this.getIndexCode())).append("\n");
        stringBuffer.append("    .isUnicode       = ").append(this.field_3_hasMultibyte).append("\n");
        stringBuffer.append("    .formatstring    = ").append(this.getFormatString()).append("\n");
        stringBuffer.append("[/FORMAT]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        String string = this.getFormatString();
        littleEndianOutput.writeShort(this.getIndexCode());
        littleEndianOutput.writeShort(string.length());
        littleEndianOutput.writeByte(this.field_3_hasMultibyte ? 1 : 0);
        if (this.field_3_hasMultibyte) {
            StringUtil.putUnicodeLE(string, littleEndianOutput);
        } else {
            StringUtil.putCompressedUnicode(string, littleEndianOutput);
        }
    }

    protected int getDataSize() {
        return 5 + this.getFormatString().length() * (this.field_3_hasMultibyte ? 2 : 1);
    }

    public short getSid() {
        return 1054;
    }

    public Object clone() {
        return this;
    }
}

