/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.hssf.record.common.FeatFormulaErr2;
import ai.org.apache.poi.hssf.record.common.FeatProtection;
import ai.org.apache.poi.hssf.record.common.FeatSmartTag;
import ai.org.apache.poi.hssf.record.common.FtrHeader;
import ai.org.apache.poi.hssf.record.common.SharedFeature;
import ai.org.apache.poi.ss.util.CellRangeAddress;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;

public final class FeatRecord
extends StandardRecord {
    private static POILogger logger = POILogFactory.getLogger(FeatRecord.class);
    public static final short sid = 2152;
    private FtrHeader futureHeader;
    private int isf_sharedFeatureType;
    private byte reserved1;
    private long reserved2;
    private long cbFeatData;
    private int reserved3;
    private CellRangeAddress[] cellRefs;
    private SharedFeature sharedFeature;

    public FeatRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2152);
    }

    public short getSid() {
        return 2152;
    }

    public FeatRecord(RecordInputStream recordInputStream) {
        this.futureHeader = new FtrHeader(recordInputStream);
        this.isf_sharedFeatureType = recordInputStream.readShort();
        this.reserved1 = recordInputStream.readByte();
        this.reserved2 = recordInputStream.readInt();
        int n = recordInputStream.readUShort();
        this.cbFeatData = recordInputStream.readInt();
        this.reserved3 = recordInputStream.readShort();
        this.cellRefs = new CellRangeAddress[n];
        for (int i = 0; i < this.cellRefs.length; ++i) {
            this.cellRefs[i] = new CellRangeAddress(recordInputStream);
        }
        switch (this.isf_sharedFeatureType) {
            case 2: {
                this.sharedFeature = new FeatProtection(recordInputStream);
                break;
            }
            case 3: {
                this.sharedFeature = new FeatFormulaErr2(recordInputStream);
                break;
            }
            case 4: {
                this.sharedFeature = new FeatSmartTag(recordInputStream);
                break;
            }
            default: {
                logger.log(7, "Unknown Shared Feature " + this.isf_sharedFeatureType + " found!");
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SHARED FEATURE]\n");
        stringBuffer.append("[/SHARED FEATURE]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        this.futureHeader.serialize(littleEndianOutput);
        littleEndianOutput.writeShort(this.isf_sharedFeatureType);
        littleEndianOutput.writeByte(this.reserved1);
        littleEndianOutput.writeInt((int)this.reserved2);
        littleEndianOutput.writeShort(this.cellRefs.length);
        littleEndianOutput.writeInt((int)this.cbFeatData);
        littleEndianOutput.writeShort(this.reserved3);
        for (int i = 0; i < this.cellRefs.length; ++i) {
            this.cellRefs[i].serialize(littleEndianOutput);
        }
        this.sharedFeature.serialize(littleEndianOutput);
    }

    protected int getDataSize() {
        return 27 + this.cellRefs.length * 8 + this.sharedFeature.getDataSize();
    }

    public int getIsf_sharedFeatureType() {
        return this.isf_sharedFeatureType;
    }

    public long getCbFeatData() {
        return this.cbFeatData;
    }

    public void setCbFeatData(long l) {
        this.cbFeatData = l;
    }

    public CellRangeAddress[] getCellRefs() {
        return this.cellRefs;
    }

    public void setCellRefs(CellRangeAddress[] cellRangeAddressArray) {
        this.cellRefs = cellRangeAddressArray;
    }

    public SharedFeature getSharedFeature() {
        return this.sharedFeature;
    }

    public void setSharedFeature(SharedFeature sharedFeature) {
        this.sharedFeature = sharedFeature;
        if (sharedFeature instanceof FeatProtection) {
            this.isf_sharedFeatureType = 2;
        }
        if (sharedFeature instanceof FeatFormulaErr2) {
            this.isf_sharedFeatureType = 3;
        }
        if (sharedFeature instanceof FeatSmartTag) {
            this.isf_sharedFeatureType = 4;
        }
        this.cbFeatData = this.isf_sharedFeatureType == 3 ? (long)this.sharedFeature.getDataSize() : 0L;
    }

    public Object clone() {
        return this.cloneViaReserialise();
    }
}

