/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.ss.formula.Formula;
import ai.org.apache.poi.ss.formula.constant.ConstantValueParser;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.StringUtil;

public final class ExternalNameRecord
extends StandardRecord {
    public static final short sid = 35;
    private static final int OPT_BUILTIN_NAME = 1;
    private static final int OPT_AUTOMATIC_LINK = 2;
    private static final int OPT_PICTURE_LINK = 4;
    private static final int OPT_STD_DOCUMENT_NAME = 8;
    private static final int OPT_OLE_LINK = 16;
    private static final int OPT_ICONIFIED_PICTURE_LINK = 32768;
    private short field_1_option_flag;
    private short field_2_ixals;
    private short field_3_not_used;
    private String field_4_name;
    private Formula field_5_name_definition;
    private Object[] _ddeValues;
    private int _nColumns;
    private int _nRows;

    public boolean isBuiltInName() {
        return (this.field_1_option_flag & 1) != 0;
    }

    public boolean isAutomaticLink() {
        return (this.field_1_option_flag & 2) != 0;
    }

    public boolean isPicureLink() {
        return (this.field_1_option_flag & 4) != 0;
    }

    public boolean isStdDocumentNameIdentifier() {
        return (this.field_1_option_flag & 8) != 0;
    }

    public boolean isOLELink() {
        return (this.field_1_option_flag & 0x10) != 0;
    }

    public boolean isIconifiedPictureLink() {
        return (this.field_1_option_flag & 0x8000) != 0;
    }

    public String getText() {
        return this.field_4_name;
    }

    public void setText(String string) {
        this.field_4_name = string;
    }

    public short getIx() {
        return this.field_2_ixals;
    }

    public void setIx(short s) {
        this.field_2_ixals = s;
    }

    public Ptg[] getParsedExpression() {
        return Formula.getTokens(this.field_5_name_definition);
    }

    public void setParsedExpression(Ptg[] ptgArray) {
        this.field_5_name_definition = Formula.create(ptgArray);
    }

    protected int getDataSize() {
        int n = 6;
        n += StringUtil.getEncodedSize(this.field_4_name) - 1;
        if (!this.isOLELink() && !this.isStdDocumentNameIdentifier()) {
            if (this.isAutomaticLink()) {
                if (this._ddeValues != null) {
                    n += 3;
                    n += ConstantValueParser.getEncodedSize(this._ddeValues);
                }
            } else {
                n += this.field_5_name_definition.getEncodedSize();
            }
        }
        return n;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_option_flag);
        littleEndianOutput.writeShort(this.field_2_ixals);
        littleEndianOutput.writeShort(this.field_3_not_used);
        littleEndianOutput.writeByte(this.field_4_name.length());
        StringUtil.writeUnicodeStringFlagAndData(littleEndianOutput, this.field_4_name);
        if (!this.isOLELink() && !this.isStdDocumentNameIdentifier()) {
            if (this.isAutomaticLink()) {
                if (this._ddeValues != null) {
                    littleEndianOutput.writeByte(this._nColumns - 1);
                    littleEndianOutput.writeShort(this._nRows - 1);
                    ConstantValueParser.encode(littleEndianOutput, this._ddeValues);
                }
            } else {
                this.field_5_name_definition.serialize(littleEndianOutput);
            }
        }
    }

    public ExternalNameRecord() {
        this.field_2_ixals = 0;
    }

    public ExternalNameRecord(RecordInputStream recordInputStream) {
        this.field_1_option_flag = recordInputStream.readShort();
        this.field_2_ixals = recordInputStream.readShort();
        this.field_3_not_used = recordInputStream.readShort();
        int n = recordInputStream.readUByte();
        this.field_4_name = StringUtil.readUnicodeString(recordInputStream, n);
        if (!this.isOLELink() && !this.isStdDocumentNameIdentifier()) {
            if (this.isAutomaticLink()) {
                if (recordInputStream.available() > 0) {
                    int n2 = recordInputStream.readUByte() + 1;
                    int n3 = recordInputStream.readShort() + 1;
                    int n4 = n3 * n2;
                    this._ddeValues = ConstantValueParser.parse(recordInputStream, n4);
                    this._nColumns = n2;
                    this._nRows = n3;
                }
            } else {
                int n5 = recordInputStream.readUShort();
                this.field_5_name_definition = Formula.read(n5, recordInputStream);
            }
        }
    }

    public short getSid() {
        return 35;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[EXTERNALNAME]\n");
        stringBuffer.append("    .options      = ").append(this.field_1_option_flag).append("\n");
        stringBuffer.append("    .ix      = ").append(this.field_2_ixals).append("\n");
        stringBuffer.append("    .name    = ").append(this.field_4_name).append("\n");
        if (this.field_5_name_definition != null) {
            Ptg[] ptgArray = this.field_5_name_definition.getTokens();
            for (int i = 0; i < ptgArray.length; ++i) {
                Ptg ptg = ptgArray[i];
                stringBuffer.append(ptg.toString()).append(ptg.getRVAType()).append("\n");
            }
        }
        stringBuffer.append("[/EXTERNALNAME]\n");
        return stringBuffer.toString();
    }
}

