/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordFormatException;
import ai.org.apache.poi.hssf.record.SubRecord;
import ai.org.apache.poi.util.BitField;
import ai.org.apache.poi.util.BitFieldFactory;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianInput;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class CommonObjectDataSubRecord
extends SubRecord {
    public static final short sid = 21;
    private static final BitField locked = BitFieldFactory.getInstance(1);
    private static final BitField printable = BitFieldFactory.getInstance(16);
    private static final BitField autofill = BitFieldFactory.getInstance(8192);
    private static final BitField autoline = BitFieldFactory.getInstance(16384);
    public static final short OBJECT_TYPE_GROUP = 0;
    public static final short OBJECT_TYPE_LINE = 1;
    public static final short OBJECT_TYPE_RECTANGLE = 2;
    public static final short OBJECT_TYPE_OVAL = 3;
    public static final short OBJECT_TYPE_ARC = 4;
    public static final short OBJECT_TYPE_CHART = 5;
    public static final short OBJECT_TYPE_TEXT = 6;
    public static final short OBJECT_TYPE_BUTTON = 7;
    public static final short OBJECT_TYPE_PICTURE = 8;
    public static final short OBJECT_TYPE_POLYGON = 9;
    public static final short OBJECT_TYPE_RESERVED1 = 10;
    public static final short OBJECT_TYPE_CHECKBOX = 11;
    public static final short OBJECT_TYPE_OPTION_BUTTON = 12;
    public static final short OBJECT_TYPE_EDIT_BOX = 13;
    public static final short OBJECT_TYPE_LABEL = 14;
    public static final short OBJECT_TYPE_DIALOG_BOX = 15;
    public static final short OBJECT_TYPE_SPINNER = 16;
    public static final short OBJECT_TYPE_SCROLL_BAR = 17;
    public static final short OBJECT_TYPE_LIST_BOX = 18;
    public static final short OBJECT_TYPE_GROUP_BOX = 19;
    public static final short OBJECT_TYPE_COMBO_BOX = 20;
    public static final short OBJECT_TYPE_RESERVED2 = 21;
    public static final short OBJECT_TYPE_RESERVED3 = 22;
    public static final short OBJECT_TYPE_RESERVED4 = 23;
    public static final short OBJECT_TYPE_RESERVED5 = 24;
    public static final short OBJECT_TYPE_COMMENT = 25;
    public static final short OBJECT_TYPE_RESERVED6 = 26;
    public static final short OBJECT_TYPE_RESERVED7 = 27;
    public static final short OBJECT_TYPE_RESERVED8 = 28;
    public static final short OBJECT_TYPE_RESERVED9 = 29;
    public static final short OBJECT_TYPE_MICROSOFT_OFFICE_DRAWING = 30;
    private short field_1_objectType;
    private int field_2_objectId;
    private short field_3_option;
    private int field_4_reserved1;
    private int field_5_reserved2;
    private int field_6_reserved3;

    public CommonObjectDataSubRecord() {
    }

    public CommonObjectDataSubRecord(LittleEndianInput littleEndianInput, int n) {
        if (n != 18) {
            throw new RecordFormatException("Expected size 18 but got (" + n + ")");
        }
        this.field_1_objectType = littleEndianInput.readShort();
        this.field_2_objectId = littleEndianInput.readUShort();
        this.field_3_option = littleEndianInput.readShort();
        this.field_4_reserved1 = littleEndianInput.readInt();
        this.field_5_reserved2 = littleEndianInput.readInt();
        this.field_6_reserved3 = littleEndianInput.readInt();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ftCmo]\n");
        stringBuffer.append("    .objectType           = ").append("0x").append(HexDump.toHex(this.getObjectType())).append(" (").append(this.getObjectType()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .objectId             = ").append("0x").append(HexDump.toHex(this.getObjectId())).append(" (").append(this.getObjectId()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .option               = ").append("0x").append(HexDump.toHex(this.getOption())).append(" (").append(this.getOption()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .locked                   = ").append(this.isLocked()).append('\n');
        stringBuffer.append("         .printable                = ").append(this.isPrintable()).append('\n');
        stringBuffer.append("         .autofill                 = ").append(this.isAutofill()).append('\n');
        stringBuffer.append("         .autoline                 = ").append(this.isAutoline()).append('\n');
        stringBuffer.append("    .reserved1            = ").append("0x").append(HexDump.toHex(this.getReserved1())).append(" (").append(this.getReserved1()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .reserved2            = ").append("0x").append(HexDump.toHex(this.getReserved2())).append(" (").append(this.getReserved2()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .reserved3            = ").append("0x").append(HexDump.toHex(this.getReserved3())).append(" (").append(this.getReserved3()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("[/ftCmo]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(21);
        littleEndianOutput.writeShort(this.getDataSize());
        littleEndianOutput.writeShort(this.field_1_objectType);
        littleEndianOutput.writeShort(this.field_2_objectId);
        littleEndianOutput.writeShort(this.field_3_option);
        littleEndianOutput.writeInt(this.field_4_reserved1);
        littleEndianOutput.writeInt(this.field_5_reserved2);
        littleEndianOutput.writeInt(this.field_6_reserved3);
    }

    protected int getDataSize() {
        return 18;
    }

    public short getSid() {
        return 21;
    }

    public Object clone() {
        CommonObjectDataSubRecord commonObjectDataSubRecord = new CommonObjectDataSubRecord();
        commonObjectDataSubRecord.field_1_objectType = this.field_1_objectType;
        commonObjectDataSubRecord.field_2_objectId = this.field_2_objectId;
        commonObjectDataSubRecord.field_3_option = this.field_3_option;
        commonObjectDataSubRecord.field_4_reserved1 = this.field_4_reserved1;
        commonObjectDataSubRecord.field_5_reserved2 = this.field_5_reserved2;
        commonObjectDataSubRecord.field_6_reserved3 = this.field_6_reserved3;
        return commonObjectDataSubRecord;
    }

    public short getObjectType() {
        return this.field_1_objectType;
    }

    public void setObjectType(short s) {
        this.field_1_objectType = s;
    }

    public int getObjectId() {
        return this.field_2_objectId;
    }

    public void setObjectId(int n) {
        this.field_2_objectId = n;
    }

    public short getOption() {
        return this.field_3_option;
    }

    public void setOption(short s) {
        this.field_3_option = s;
    }

    public int getReserved1() {
        return this.field_4_reserved1;
    }

    public void setReserved1(int n) {
        this.field_4_reserved1 = n;
    }

    public int getReserved2() {
        return this.field_5_reserved2;
    }

    public void setReserved2(int n) {
        this.field_5_reserved2 = n;
    }

    public int getReserved3() {
        return this.field_6_reserved3;
    }

    public void setReserved3(int n) {
        this.field_6_reserved3 = n;
    }

    public void setLocked(boolean bl) {
        this.field_3_option = locked.setShortBoolean(this.field_3_option, bl);
    }

    public boolean isLocked() {
        return locked.isSet(this.field_3_option);
    }

    public void setPrintable(boolean bl) {
        this.field_3_option = printable.setShortBoolean(this.field_3_option, bl);
    }

    public boolean isPrintable() {
        return printable.isSet(this.field_3_option);
    }

    public void setAutofill(boolean bl) {
        this.field_3_option = autofill.setShortBoolean(this.field_3_option, bl);
    }

    public boolean isAutofill() {
        return autofill.isSet(this.field_3_option);
    }

    public void setAutoline(boolean bl) {
        this.field_3_option = autoline.setShortBoolean(this.field_3_option, bl);
    }

    public boolean isAutoline() {
        return autoline.isSet(this.field_3_option);
    }
}

