/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.CellValueRecordInterface;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;

public abstract class CellRecord
extends StandardRecord
implements CellValueRecordInterface {
    private int _rowIndex;
    private int _columnIndex;
    private int _formatIndex;

    protected CellRecord() {
    }

    protected CellRecord(RecordInputStream recordInputStream) {
        this._rowIndex = recordInputStream.readUShort();
        this._columnIndex = recordInputStream.readUShort();
        this._formatIndex = recordInputStream.readUShort();
    }

    public final void setRow(int n) {
        this._rowIndex = n;
    }

    public final void setColumn(short s) {
        this._columnIndex = s;
    }

    public final void setXFIndex(short s) {
        this._formatIndex = s;
    }

    public final int getRow() {
        return this._rowIndex;
    }

    public final short getColumn() {
        return (short)this._columnIndex;
    }

    public final short getXFIndex() {
        return (short)this._formatIndex;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getRecordName();
        stringBuilder.append("[").append(string).append("]\n");
        stringBuilder.append("    .row    = ").append(HexDump.shortToHex(this.getRow())).append("\n");
        stringBuilder.append("    .col    = ").append(HexDump.shortToHex(this.getColumn())).append("\n");
        stringBuilder.append("    .xfindex= ").append(HexDump.shortToHex(this.getXFIndex())).append("\n");
        this.appendValueText(stringBuilder);
        stringBuilder.append("\n");
        stringBuilder.append("[/").append(string).append("]\n");
        return stringBuilder.toString();
    }

    protected abstract void appendValueText(StringBuilder var1);

    protected abstract String getRecordName();

    protected abstract void serializeValue(LittleEndianOutput var1);

    protected abstract int getValueDataSize();

    public final void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.getRow());
        littleEndianOutput.writeShort(this.getColumn());
        littleEndianOutput.writeShort(this.getXFIndex());
        this.serializeValue(littleEndianOutput);
    }

    protected final int getDataSize() {
        return 6 + this.getValueDataSize();
    }

    protected final void copyBaseFields(CellRecord cellRecord) {
        cellRecord._rowIndex = this._rowIndex;
        cellRecord._columnIndex = this._columnIndex;
        cellRecord._formatIndex = this._formatIndex;
    }
}

