/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.CellValueRecordInterface;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class BlankRecord
extends StandardRecord
implements CellValueRecordInterface {
    public static final short sid = 513;
    private int field_1_row;
    private short field_2_col;
    private short field_3_xf;

    public BlankRecord() {
    }

    public BlankRecord(RecordInputStream recordInputStream) {
        this.field_1_row = recordInputStream.readUShort();
        this.field_2_col = recordInputStream.readShort();
        this.field_3_xf = recordInputStream.readShort();
    }

    public void setRow(int n) {
        this.field_1_row = n;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_col;
    }

    public void setXFIndex(short s) {
        this.field_3_xf = s;
    }

    public short getXFIndex() {
        return this.field_3_xf;
    }

    public void setColumn(short s) {
        this.field_2_col = s;
    }

    public short getSid() {
        return 513;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[BLANK]\n");
        stringBuffer.append("    row= ").append(HexDump.shortToHex(this.getRow())).append("\n");
        stringBuffer.append("    col= ").append(HexDump.shortToHex(this.getColumn())).append("\n");
        stringBuffer.append("    xf = ").append(HexDump.shortToHex(this.getXFIndex())).append("\n");
        stringBuffer.append("[/BLANK]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.getRow());
        littleEndianOutput.writeShort(this.getColumn());
        littleEndianOutput.writeShort(this.getXFIndex());
    }

    protected int getDataSize() {
        return 6;
    }

    public Object clone() {
        BlankRecord blankRecord = new BlankRecord();
        blankRecord.field_1_row = this.field_1_row;
        blankRecord.field_2_col = this.field_2_col;
        blankRecord.field_3_xf = this.field_3_xf;
        return blankRecord;
    }
}

