/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.extractor;

import ai.org.apache.poi.hssf.OldExcelFormatException;
import ai.org.apache.poi.hssf.record.CodepageRecord;
import ai.org.apache.poi.hssf.record.FormulaRecord;
import ai.org.apache.poi.hssf.record.NumberRecord;
import ai.org.apache.poi.hssf.record.OldFormulaRecord;
import ai.org.apache.poi.hssf.record.OldLabelRecord;
import ai.org.apache.poi.hssf.record.OldSheetRecord;
import ai.org.apache.poi.hssf.record.OldStringRecord;
import ai.org.apache.poi.hssf.record.RKRecord;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai.org.apache.poi.poifs.filesystem.DocumentNode;
import ai.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai.org.apache.poi.poifs.filesystem.NotOLE2FileException;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OldExcelExtractor {
    private RecordInputStream ris;
    private Closeable input;
    private int biffVersion;

    public OldExcelExtractor(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 8);
        if (NPOIFSFileSystem.hasPOIFSHeader(bufferedInputStream)) {
            this.open(new NPOIFSFileSystem(bufferedInputStream));
        } else {
            this.open(bufferedInputStream);
        }
    }

    public OldExcelExtractor(File file) throws IOException {
        try {
            this.open(new NPOIFSFileSystem(file));
        }
        catch (OldExcelFormatException oldExcelFormatException) {
            this.open(new FileInputStream(file));
        }
        catch (NotOLE2FileException notOLE2FileException) {
            this.open(new FileInputStream(file));
        }
    }

    public OldExcelExtractor(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this.open(nPOIFSFileSystem);
    }

    public OldExcelExtractor(DirectoryNode directoryNode) throws IOException {
        this.open(directoryNode);
    }

    private void open(InputStream inputStream) {
        this.input = inputStream;
        this.ris = new RecordInputStream(inputStream);
    }

    private void open(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this.input = nPOIFSFileSystem;
        this.open(nPOIFSFileSystem.getRoot());
    }

    private void open(DirectoryNode directoryNode) throws IOException {
        DocumentNode documentNode = (DocumentNode)directoryNode.getEntry("Book");
        if (documentNode == null) {
            throw new IOException("No Excel 5/95 Book stream found");
        }
        this.ris = new RecordInputStream(directoryNode.createDocumentInputStream(documentNode));
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Use:");
            System.err.println("   OldExcelExtractor <filename>");
            System.exit(1);
        }
        OldExcelExtractor oldExcelExtractor = new OldExcelExtractor(new File(stringArray[0]));
        System.out.println(oldExcelExtractor.getText());
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.ris.getNextSid();
        switch (n) {
            case 9: {
                this.biffVersion = 2;
                break;
            }
            case 521: {
                this.biffVersion = 3;
                break;
            }
            case 1033: {
                this.biffVersion = 4;
                break;
            }
            case 2057: {
                this.biffVersion = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException("File does not begin with a BOF, found sid of " + n);
            }
        }
        CodepageRecord codepageRecord = null;
        block17: while (this.ris.hasNextRecord()) {
            int n2 = this.ris.getNextSid();
            this.ris.nextRecord();
            switch (n2) {
                case 133: {
                    OldSheetRecord oldSheetRecord = new OldSheetRecord(this.ris);
                    oldSheetRecord.setCodePage(codepageRecord);
                    stringBuffer.append("Sheet: ");
                    stringBuffer.append(oldSheetRecord.getSheetname());
                    stringBuffer.append('\n');
                    break;
                }
                case 4: 
                case 516: {
                    OldLabelRecord oldLabelRecord = new OldLabelRecord(this.ris);
                    oldLabelRecord.setCodePage(codepageRecord);
                    stringBuffer.append(oldLabelRecord.getValue());
                    stringBuffer.append('\n');
                    break;
                }
                case 7: 
                case 519: {
                    OldStringRecord oldStringRecord = new OldStringRecord(this.ris);
                    oldStringRecord.setCodePage(codepageRecord);
                    stringBuffer.append(oldStringRecord.getString());
                    stringBuffer.append('\n');
                    break;
                }
                case 515: {
                    NumberRecord numberRecord = new NumberRecord(this.ris);
                    this.handleNumericCell(stringBuffer, numberRecord.getValue());
                    break;
                }
                case 6: 
                case 518: 
                case 1030: {
                    Object object;
                    if (this.biffVersion == 5) {
                        object = new FormulaRecord(this.ris);
                        if (((FormulaRecord)object).getCachedResultType() != 0) continue block17;
                        this.handleNumericCell(stringBuffer, ((FormulaRecord)object).getValue());
                        break;
                    }
                    object = new OldFormulaRecord(this.ris);
                    if (((OldFormulaRecord)object).getCachedResultType() != 0) continue block17;
                    this.handleNumericCell(stringBuffer, ((OldFormulaRecord)object).getValue());
                    break;
                }
                case 638: {
                    Object object = new RKRecord(this.ris);
                    this.handleNumericCell(stringBuffer, ((RKRecord)object).getRKNumber());
                    break;
                }
                case 66: {
                    codepageRecord = new CodepageRecord(this.ris);
                    break;
                }
                default: {
                    this.ris.readFully(new byte[this.ris.remaining()]);
                }
            }
        }
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.input = null;
        }
        this.ris = null;
        return stringBuffer.toString();
    }

    protected void handleNumericCell(StringBuffer stringBuffer, double d) {
        stringBuffer.append(d);
        stringBuffer.append('\n');
    }
}

