/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.extractor;

import ai.org.apache.poi.POIOLE2TextExtractor;
import ai.org.apache.poi.hssf.usermodel.HSSFCell;
import ai.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import ai.org.apache.poi.hssf.usermodel.HSSFComment;
import ai.org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import ai.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import ai.org.apache.poi.hssf.usermodel.HSSFRow;
import ai.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.usermodel.HeaderFooter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class ExcelExtractor
extends POIOLE2TextExtractor
implements ai.org.apache.poi.ss.extractor.ExcelExtractor {
    private HSSFWorkbook _wb;
    private HSSFDataFormatter _formatter;
    private boolean _includeSheetNames = true;
    private boolean _shouldEvaluateFormulas = true;
    private boolean _includeCellComments = false;
    private boolean _includeBlankCells = false;
    private boolean _includeHeadersFooters = true;

    public ExcelExtractor(HSSFWorkbook hSSFWorkbook) {
        super(hSSFWorkbook);
        this._wb = hSSFWorkbook;
        this._formatter = new HSSFDataFormatter();
    }

    public ExcelExtractor(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem.getRoot());
    }

    @Deprecated
    public ExcelExtractor(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(directoryNode);
    }

    public ExcelExtractor(DirectoryNode directoryNode) throws IOException {
        this(new HSSFWorkbook(directoryNode, true));
    }

    private static void printUsageMessage(PrintStream printStream) {
        printStream.println("Use:");
        printStream.println("    " + ExcelExtractor.class.getName() + " [<flag> <value> [<flag> <value> [...]]] [-i <filename.xls>]");
        printStream.println("       -i <filename.xls> specifies input file (default is to use stdin)");
        printStream.println("       Flags can be set on or off by using the values 'Y' or 'N'.");
        printStream.println("       Following are available flags and their default values:");
        printStream.println("       --show-sheet-names  Y");
        printStream.println("       --evaluate-formulas Y");
        printStream.println("       --show-comments     N");
        printStream.println("       --show-blanks       Y");
        printStream.println("       --headers-footers   Y");
    }

    public static void main(String[] stringArray) {
        CommandArgs commandArgs;
        try {
            commandArgs = new CommandArgs(stringArray);
        }
        catch (CommandParseException commandParseException) {
            System.err.println(commandParseException.getMessage());
            ExcelExtractor.printUsageMessage(System.err);
            System.exit(1);
            return;
        }
        if (commandArgs.isRequestHelp()) {
            ExcelExtractor.printUsageMessage(System.out);
            return;
        }
        try {
            InputStream inputStream = commandArgs.getInputFile() == null ? System.in : new FileInputStream(commandArgs.getInputFile());
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(inputStream);
            ExcelExtractor excelExtractor = new ExcelExtractor(hSSFWorkbook);
            excelExtractor.setIncludeSheetNames(commandArgs.shouldShowSheetNames());
            excelExtractor.setFormulasNotResults(!commandArgs.shouldEvaluateFormulas());
            excelExtractor.setIncludeCellComments(commandArgs.shouldShowCellComments());
            excelExtractor.setIncludeBlankCells(commandArgs.shouldShowBlankCells());
            excelExtractor.setIncludeHeadersFooters(commandArgs.shouldIncludeHeadersFooters());
            System.out.println(excelExtractor.getText());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void setIncludeSheetNames(boolean bl) {
        this._includeSheetNames = bl;
    }

    public void setFormulasNotResults(boolean bl) {
        this._shouldEvaluateFormulas = !bl;
    }

    public void setIncludeCellComments(boolean bl) {
        this._includeCellComments = bl;
    }

    public void setIncludeBlankCells(boolean bl) {
        this._includeBlankCells = bl;
    }

    public void setIncludeHeadersFooters(boolean bl) {
        this._includeHeadersFooters = bl;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        this._wb.setMissingCellPolicy(HSSFRow.RETURN_BLANK_AS_NULL);
        for (int i = 0; i < this._wb.getNumberOfSheets(); ++i) {
            String string;
            HSSFSheet hSSFSheet = this._wb.getSheetAt(i);
            if (hSSFSheet == null) continue;
            if (this._includeSheetNames && (string = this._wb.getSheetName(i)) != null) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            if (this._includeHeadersFooters) {
                stringBuffer.append(ExcelExtractor._extractHeaderFooter(hSSFSheet.getHeader()));
            }
            int n = hSSFSheet.getFirstRowNum();
            int n2 = hSSFSheet.getLastRowNum();
            for (int j = n; j <= n2; ++j) {
                HSSFRow hSSFRow = hSSFSheet.getRow(j);
                if (hSSFRow == null) continue;
                int n3 = hSSFRow.getFirstCellNum();
                short s = hSSFRow.getLastCellNum();
                if (this._includeBlankCells) {
                    n3 = 0;
                }
                for (int k = n3; k < s; ++k) {
                    HSSFCell hSSFCell = hSSFRow.getCell(k);
                    boolean bl = true;
                    if (hSSFCell == null) {
                        bl = this._includeBlankCells;
                    } else {
                        Object object;
                        Object object2;
                        switch (hSSFCell.getCellType()) {
                            case 1: {
                                stringBuffer.append(hSSFCell.getRichStringCellValue().getString());
                                break;
                            }
                            case 0: {
                                stringBuffer.append(this._formatter.formatCellValue(hSSFCell));
                                break;
                            }
                            case 4: {
                                stringBuffer.append(hSSFCell.getBooleanCellValue());
                                break;
                            }
                            case 5: {
                                stringBuffer.append(ErrorEval.getText(hSSFCell.getErrorCellValue()));
                                break;
                            }
                            case 2: {
                                if (!this._shouldEvaluateFormulas) {
                                    stringBuffer.append(hSSFCell.getCellFormula());
                                    break;
                                }
                                switch (hSSFCell.getCachedFormulaResultType()) {
                                    case 1: {
                                        object2 = hSSFCell.getRichStringCellValue();
                                        if (object2 == null || ((HSSFRichTextString)object2).length() <= 0) break;
                                        stringBuffer.append(((HSSFRichTextString)object2).toString());
                                        break;
                                    }
                                    case 0: {
                                        object = hSSFCell.getCellStyle();
                                        if (object == null) {
                                            stringBuffer.append(hSSFCell.getNumericCellValue());
                                            break;
                                        }
                                        stringBuffer.append(this._formatter.formatRawCellContents(hSSFCell.getNumericCellValue(), ((HSSFCellStyle)object).getDataFormat(), ((HSSFCellStyle)object).getDataFormatString()));
                                        break;
                                    }
                                    case 4: {
                                        stringBuffer.append(hSSFCell.getBooleanCellValue());
                                        break;
                                    }
                                    case 5: {
                                        stringBuffer.append(ErrorEval.getText(hSSFCell.getErrorCellValue()));
                                    }
                                }
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unexpected cell type (" + hSSFCell.getCellType() + ")");
                            }
                        }
                        object2 = hSSFCell.getCellComment();
                        if (this._includeCellComments && object2 != null) {
                            object = ((HSSFRichTextString)((HSSFComment)object2).getString()).getString().replace('\n', ' ');
                            stringBuffer.append(" Comment by " + ((HSSFComment)object2).getAuthor() + ": " + (String)object);
                        }
                    }
                    if (!bl || k >= s - 1) continue;
                    stringBuffer.append("\t");
                }
                stringBuffer.append("\n");
            }
            if (!this._includeHeadersFooters) continue;
            stringBuffer.append(ExcelExtractor._extractHeaderFooter(hSSFSheet.getFooter()));
        }
        return stringBuffer.toString();
    }

    public static String _extractHeaderFooter(HeaderFooter headerFooter) {
        StringBuffer stringBuffer = new StringBuffer();
        if (headerFooter.getLeft() != null) {
            stringBuffer.append(headerFooter.getLeft());
        }
        if (headerFooter.getCenter() != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(headerFooter.getCenter());
        }
        if (headerFooter.getRight() != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(headerFooter.getRight());
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static final class CommandArgs {
        private final boolean _requestHelp;
        private final File _inputFile;
        private final boolean _showSheetNames;
        private final boolean _evaluateFormulas;
        private final boolean _showCellComments;
        private final boolean _showBlankCells;
        private final boolean _headersFooters;

        public CommandArgs(String[] stringArray) throws CommandParseException {
            int n = stringArray.length;
            File file = null;
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = true;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                if ("-help".equalsIgnoreCase(string)) {
                    bl = true;
                    break;
                }
                if ("-i".equals(string)) {
                    if (++i >= n) {
                        throw new CommandParseException("Expected filename after '-i'");
                    }
                    string = stringArray[i];
                    if (file != null) {
                        throw new CommandParseException("Only one input file can be supplied");
                    }
                    file = new File(string);
                    if (!file.exists()) {
                        throw new CommandParseException("Specified input file '" + string + "' does not exist");
                    }
                    if (!file.isDirectory()) continue;
                    throw new CommandParseException("Specified input file '" + string + "' is a directory");
                }
                if ("--show-sheet-names".equals(string)) {
                    bl2 = CommandArgs.parseBoolArg(stringArray, ++i);
                    continue;
                }
                if ("--evaluate-formulas".equals(string)) {
                    bl3 = CommandArgs.parseBoolArg(stringArray, ++i);
                    continue;
                }
                if ("--show-comments".equals(string)) {
                    bl4 = CommandArgs.parseBoolArg(stringArray, ++i);
                    continue;
                }
                if ("--show-blanks".equals(string)) {
                    bl5 = CommandArgs.parseBoolArg(stringArray, ++i);
                    continue;
                }
                if ("--headers-footers".equals(string)) {
                    bl6 = CommandArgs.parseBoolArg(stringArray, ++i);
                    continue;
                }
                throw new CommandParseException("Invalid argument '" + string + "'");
            }
            this._requestHelp = bl;
            this._inputFile = file;
            this._showSheetNames = bl2;
            this._evaluateFormulas = bl3;
            this._showCellComments = bl4;
            this._showBlankCells = bl5;
            this._headersFooters = bl6;
        }

        private static boolean parseBoolArg(String[] stringArray, int n) throws CommandParseException {
            if (n >= stringArray.length) {
                throw new CommandParseException("Expected value after '" + stringArray[n - 1] + "'");
            }
            String string = stringArray[n].toUpperCase();
            if ("Y".equals(string) || "YES".equals(string) || "ON".equals(string) || "TRUE".equals(string)) {
                return true;
            }
            if ("N".equals(string) || "NO".equals(string) || "OFF".equals(string) || "FALSE".equals(string)) {
                return false;
            }
            throw new CommandParseException("Invalid value '" + stringArray[n] + "' for '" + stringArray[n - 1] + "'. Expected 'Y' or 'N'");
        }

        public boolean isRequestHelp() {
            return this._requestHelp;
        }

        public File getInputFile() {
            return this._inputFile;
        }

        public boolean shouldShowSheetNames() {
            return this._showSheetNames;
        }

        public boolean shouldEvaluateFormulas() {
            return this._evaluateFormulas;
        }

        public boolean shouldShowCellComments() {
            return this._showCellComments;
        }

        public boolean shouldShowBlankCells() {
            return this._showBlankCells;
        }

        public boolean shouldIncludeHeadersFooters() {
            return this._headersFooters;
        }
    }

    private static final class CommandParseException
    extends Exception {
        public CommandParseException(String string) {
            super(string);
        }
    }
}

