/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.dev;

import ai.org.apache.poi.hssf.record.ArrayRecord;
import ai.org.apache.poi.hssf.record.AutoFilterInfoRecord;
import ai.org.apache.poi.hssf.record.BOFRecord;
import ai.org.apache.poi.hssf.record.BackupRecord;
import ai.org.apache.poi.hssf.record.BlankRecord;
import ai.org.apache.poi.hssf.record.BookBoolRecord;
import ai.org.apache.poi.hssf.record.BoolErrRecord;
import ai.org.apache.poi.hssf.record.BottomMarginRecord;
import ai.org.apache.poi.hssf.record.BoundSheetRecord;
import ai.org.apache.poi.hssf.record.CFHeaderRecord;
import ai.org.apache.poi.hssf.record.CFRuleRecord;
import ai.org.apache.poi.hssf.record.CalcCountRecord;
import ai.org.apache.poi.hssf.record.CalcModeRecord;
import ai.org.apache.poi.hssf.record.CodepageRecord;
import ai.org.apache.poi.hssf.record.ColumnInfoRecord;
import ai.org.apache.poi.hssf.record.ContinueRecord;
import ai.org.apache.poi.hssf.record.CountryRecord;
import ai.org.apache.poi.hssf.record.DBCellRecord;
import ai.org.apache.poi.hssf.record.DConRefRecord;
import ai.org.apache.poi.hssf.record.DSFRecord;
import ai.org.apache.poi.hssf.record.DVALRecord;
import ai.org.apache.poi.hssf.record.DVRecord;
import ai.org.apache.poi.hssf.record.DateWindow1904Record;
import ai.org.apache.poi.hssf.record.DefaultColWidthRecord;
import ai.org.apache.poi.hssf.record.DefaultRowHeightRecord;
import ai.org.apache.poi.hssf.record.DeltaRecord;
import ai.org.apache.poi.hssf.record.DimensionsRecord;
import ai.org.apache.poi.hssf.record.DrawingGroupRecord;
import ai.org.apache.poi.hssf.record.DrawingRecordForBiffViewer;
import ai.org.apache.poi.hssf.record.DrawingSelectionRecord;
import ai.org.apache.poi.hssf.record.EOFRecord;
import ai.org.apache.poi.hssf.record.ExtSSTRecord;
import ai.org.apache.poi.hssf.record.ExtendedFormatRecord;
import ai.org.apache.poi.hssf.record.ExternSheetRecord;
import ai.org.apache.poi.hssf.record.ExternalNameRecord;
import ai.org.apache.poi.hssf.record.FeatHdrRecord;
import ai.org.apache.poi.hssf.record.FeatRecord;
import ai.org.apache.poi.hssf.record.FilePassRecord;
import ai.org.apache.poi.hssf.record.FileSharingRecord;
import ai.org.apache.poi.hssf.record.FnGroupCountRecord;
import ai.org.apache.poi.hssf.record.FontRecord;
import ai.org.apache.poi.hssf.record.FooterRecord;
import ai.org.apache.poi.hssf.record.FormatRecord;
import ai.org.apache.poi.hssf.record.FormulaRecord;
import ai.org.apache.poi.hssf.record.GridsetRecord;
import ai.org.apache.poi.hssf.record.GutsRecord;
import ai.org.apache.poi.hssf.record.HCenterRecord;
import ai.org.apache.poi.hssf.record.HeaderRecord;
import ai.org.apache.poi.hssf.record.HideObjRecord;
import ai.org.apache.poi.hssf.record.HorizontalPageBreakRecord;
import ai.org.apache.poi.hssf.record.HyperlinkRecord;
import ai.org.apache.poi.hssf.record.IndexRecord;
import ai.org.apache.poi.hssf.record.InterfaceEndRecord;
import ai.org.apache.poi.hssf.record.InterfaceHdrRecord;
import ai.org.apache.poi.hssf.record.IterationRecord;
import ai.org.apache.poi.hssf.record.LabelRecord;
import ai.org.apache.poi.hssf.record.LabelSSTRecord;
import ai.org.apache.poi.hssf.record.LeftMarginRecord;
import ai.org.apache.poi.hssf.record.MMSRecord;
import ai.org.apache.poi.hssf.record.MergeCellsRecord;
import ai.org.apache.poi.hssf.record.MulBlankRecord;
import ai.org.apache.poi.hssf.record.MulRKRecord;
import ai.org.apache.poi.hssf.record.NameCommentRecord;
import ai.org.apache.poi.hssf.record.NameRecord;
import ai.org.apache.poi.hssf.record.NoteRecord;
import ai.org.apache.poi.hssf.record.NumberRecord;
import ai.org.apache.poi.hssf.record.ObjRecord;
import ai.org.apache.poi.hssf.record.PaletteRecord;
import ai.org.apache.poi.hssf.record.PaneRecord;
import ai.org.apache.poi.hssf.record.PasswordRecord;
import ai.org.apache.poi.hssf.record.PasswordRev4Record;
import ai.org.apache.poi.hssf.record.PrecisionRecord;
import ai.org.apache.poi.hssf.record.PrintGridlinesRecord;
import ai.org.apache.poi.hssf.record.PrintHeadersRecord;
import ai.org.apache.poi.hssf.record.PrintSetupRecord;
import ai.org.apache.poi.hssf.record.ProtectRecord;
import ai.org.apache.poi.hssf.record.ProtectionRev4Record;
import ai.org.apache.poi.hssf.record.RKRecord;
import ai.org.apache.poi.hssf.record.RecalcIdRecord;
import ai.org.apache.poi.hssf.record.Record;
import ai.org.apache.poi.hssf.record.RecordFormatException;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.RefModeRecord;
import ai.org.apache.poi.hssf.record.RefreshAllRecord;
import ai.org.apache.poi.hssf.record.RightMarginRecord;
import ai.org.apache.poi.hssf.record.RowRecord;
import ai.org.apache.poi.hssf.record.SCLRecord;
import ai.org.apache.poi.hssf.record.SSTRecord;
import ai.org.apache.poi.hssf.record.SaveRecalcRecord;
import ai.org.apache.poi.hssf.record.SelectionRecord;
import ai.org.apache.poi.hssf.record.SharedFormulaRecord;
import ai.org.apache.poi.hssf.record.StringRecord;
import ai.org.apache.poi.hssf.record.StyleRecord;
import ai.org.apache.poi.hssf.record.SupBookRecord;
import ai.org.apache.poi.hssf.record.TabIdRecord;
import ai.org.apache.poi.hssf.record.TableRecord;
import ai.org.apache.poi.hssf.record.TableStylesRecord;
import ai.org.apache.poi.hssf.record.TextObjectRecord;
import ai.org.apache.poi.hssf.record.TopMarginRecord;
import ai.org.apache.poi.hssf.record.UncalcedRecord;
import ai.org.apache.poi.hssf.record.UnknownRecord;
import ai.org.apache.poi.hssf.record.UseSelFSRecord;
import ai.org.apache.poi.hssf.record.VCenterRecord;
import ai.org.apache.poi.hssf.record.VerticalPageBreakRecord;
import ai.org.apache.poi.hssf.record.WSBoolRecord;
import ai.org.apache.poi.hssf.record.WindowOneRecord;
import ai.org.apache.poi.hssf.record.WindowProtectRecord;
import ai.org.apache.poi.hssf.record.WindowTwoRecord;
import ai.org.apache.poi.hssf.record.WriteAccessRecord;
import ai.org.apache.poi.hssf.record.WriteProtectRecord;
import ai.org.apache.poi.hssf.record.chart.AreaFormatRecord;
import ai.org.apache.poi.hssf.record.chart.AreaRecord;
import ai.org.apache.poi.hssf.record.chart.AxisLineFormatRecord;
import ai.org.apache.poi.hssf.record.chart.AxisOptionsRecord;
import ai.org.apache.poi.hssf.record.chart.AxisParentRecord;
import ai.org.apache.poi.hssf.record.chart.AxisRecord;
import ai.org.apache.poi.hssf.record.chart.AxisUsedRecord;
import ai.org.apache.poi.hssf.record.chart.BarRecord;
import ai.org.apache.poi.hssf.record.chart.BeginRecord;
import ai.org.apache.poi.hssf.record.chart.CatLabRecord;
import ai.org.apache.poi.hssf.record.chart.CategorySeriesAxisRecord;
import ai.org.apache.poi.hssf.record.chart.ChartEndBlockRecord;
import ai.org.apache.poi.hssf.record.chart.ChartEndObjectRecord;
import ai.org.apache.poi.hssf.record.chart.ChartFRTInfoRecord;
import ai.org.apache.poi.hssf.record.chart.ChartFormatRecord;
import ai.org.apache.poi.hssf.record.chart.ChartRecord;
import ai.org.apache.poi.hssf.record.chart.ChartStartBlockRecord;
import ai.org.apache.poi.hssf.record.chart.ChartStartObjectRecord;
import ai.org.apache.poi.hssf.record.chart.DatRecord;
import ai.org.apache.poi.hssf.record.chart.DataFormatRecord;
import ai.org.apache.poi.hssf.record.chart.DefaultDataLabelTextPropertiesRecord;
import ai.org.apache.poi.hssf.record.chart.EndRecord;
import ai.org.apache.poi.hssf.record.chart.FontBasisRecord;
import ai.org.apache.poi.hssf.record.chart.FontIndexRecord;
import ai.org.apache.poi.hssf.record.chart.FrameRecord;
import ai.org.apache.poi.hssf.record.chart.LegendRecord;
import ai.org.apache.poi.hssf.record.chart.LineFormatRecord;
import ai.org.apache.poi.hssf.record.chart.LinkedDataRecord;
import ai.org.apache.poi.hssf.record.chart.ObjectLinkRecord;
import ai.org.apache.poi.hssf.record.chart.PlotAreaRecord;
import ai.org.apache.poi.hssf.record.chart.PlotGrowthRecord;
import ai.org.apache.poi.hssf.record.chart.SeriesIndexRecord;
import ai.org.apache.poi.hssf.record.chart.SeriesListRecord;
import ai.org.apache.poi.hssf.record.chart.SeriesRecord;
import ai.org.apache.poi.hssf.record.chart.SeriesTextRecord;
import ai.org.apache.poi.hssf.record.chart.SeriesToChartGroupRecord;
import ai.org.apache.poi.hssf.record.chart.SheetPropertiesRecord;
import ai.org.apache.poi.hssf.record.chart.TextRecord;
import ai.org.apache.poi.hssf.record.chart.TickRecord;
import ai.org.apache.poi.hssf.record.chart.UnitsRecord;
import ai.org.apache.poi.hssf.record.chart.ValueRangeRecord;
import ai.org.apache.poi.hssf.record.pivottable.DataItemRecord;
import ai.org.apache.poi.hssf.record.pivottable.ExtendedPivotTableViewFieldsRecord;
import ai.org.apache.poi.hssf.record.pivottable.PageItemRecord;
import ai.org.apache.poi.hssf.record.pivottable.StreamIDRecord;
import ai.org.apache.poi.hssf.record.pivottable.ViewDefinitionRecord;
import ai.org.apache.poi.hssf.record.pivottable.ViewFieldsRecord;
import ai.org.apache.poi.hssf.record.pivottable.ViewSourceRecord;
import ai.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndian;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class BiffViewer {
    static final char[] NEW_LINE_CHARS = System.getProperty("line.separator").toCharArray();
    private static final int DUMP_LINE_LEN = 16;
    private static final char[] COLUMN_SEPARATOR = " | ".toCharArray();

    private BiffViewer() {
    }

    public static Record[] createRecords(InputStream inputStream, PrintStream printStream, BiffRecordListener biffRecordListener, boolean bl) throws RecordFormatException {
        ArrayList<Record> arrayList = new ArrayList<Record>();
        RecordInputStream recordInputStream = new RecordInputStream(inputStream);
        while (true) {
            boolean bl2;
            try {
                bl2 = recordInputStream.hasNextRecord();
            }
            catch (RecordInputStream.LeftoverDataException leftoverDataException) {
                leftoverDataException.printStackTrace();
                System.err.println("Discarding " + recordInputStream.remaining() + " bytes and continuing");
                recordInputStream.readRemainder();
                bl2 = recordInputStream.hasNextRecord();
            }
            if (!bl2) break;
            recordInputStream.nextRecord();
            if (recordInputStream.getSid() == 0) continue;
            if (bl) {
                Record record = BiffViewer.createRecord(recordInputStream);
                if (record.getSid() == 60) continue;
                arrayList.add(record);
                if (bl) {
                    for (String string : biffRecordListener.getRecentHeaders()) {
                        printStream.println(string);
                    }
                    printStream.print(record.toString());
                }
            } else {
                recordInputStream.readRemainder();
            }
            printStream.println();
        }
        Record[] recordArray = new Record[arrayList.size()];
        arrayList.toArray(recordArray);
        return recordArray;
    }

    private static Record createRecord(RecordInputStream recordInputStream) {
        switch (recordInputStream.getSid()) {
            case 4106: {
                return new AreaFormatRecord(recordInputStream);
            }
            case 4122: {
                return new AreaRecord(recordInputStream);
            }
            case 545: {
                return new ArrayRecord(recordInputStream);
            }
            case 4129: {
                return new AxisLineFormatRecord(recordInputStream);
            }
            case 4194: {
                return new AxisOptionsRecord(recordInputStream);
            }
            case 4161: {
                return new AxisParentRecord(recordInputStream);
            }
            case 4125: {
                return new AxisRecord(recordInputStream);
            }
            case 4166: {
                return new AxisUsedRecord(recordInputStream);
            }
            case 157: {
                return new AutoFilterInfoRecord(recordInputStream);
            }
            case 2057: {
                return new BOFRecord(recordInputStream);
            }
            case 64: {
                return new BackupRecord(recordInputStream);
            }
            case 4119: {
                return new BarRecord(recordInputStream);
            }
            case 4147: {
                return new BeginRecord(recordInputStream);
            }
            case 513: {
                return new BlankRecord(recordInputStream);
            }
            case 218: {
                return new BookBoolRecord(recordInputStream);
            }
            case 517: {
                return new BoolErrRecord(recordInputStream);
            }
            case 41: {
                return new BottomMarginRecord(recordInputStream);
            }
            case 133: {
                return new BoundSheetRecord(recordInputStream);
            }
            case 432: {
                return new CFHeaderRecord(recordInputStream);
            }
            case 433: {
                return new CFRuleRecord(recordInputStream);
            }
            case 12: {
                return new CalcCountRecord(recordInputStream);
            }
            case 13: {
                return new CalcModeRecord(recordInputStream);
            }
            case 4128: {
                return new CategorySeriesAxisRecord(recordInputStream);
            }
            case 4116: {
                return new ChartFormatRecord(recordInputStream);
            }
            case 4098: {
                return new ChartRecord(recordInputStream);
            }
            case 66: {
                return new CodepageRecord(recordInputStream);
            }
            case 125: {
                return new ColumnInfoRecord(recordInputStream);
            }
            case 60: {
                return new ContinueRecord(recordInputStream);
            }
            case 140: {
                return new CountryRecord(recordInputStream);
            }
            case 215: {
                return new DBCellRecord(recordInputStream);
            }
            case 353: {
                return new DSFRecord(recordInputStream);
            }
            case 4195: {
                return new DatRecord(recordInputStream);
            }
            case 4102: {
                return new DataFormatRecord(recordInputStream);
            }
            case 34: {
                return new DateWindow1904Record(recordInputStream);
            }
            case 81: {
                return new DConRefRecord(recordInputStream);
            }
            case 85: {
                return new DefaultColWidthRecord(recordInputStream);
            }
            case 4132: {
                return new DefaultDataLabelTextPropertiesRecord(recordInputStream);
            }
            case 549: {
                return new DefaultRowHeightRecord(recordInputStream);
            }
            case 16: {
                return new DeltaRecord(recordInputStream);
            }
            case 512: {
                return new DimensionsRecord(recordInputStream);
            }
            case 235: {
                return new DrawingGroupRecord(recordInputStream);
            }
            case 236: {
                return new DrawingRecordForBiffViewer(recordInputStream);
            }
            case 237: {
                return new DrawingSelectionRecord(recordInputStream);
            }
            case 446: {
                return new DVRecord(recordInputStream);
            }
            case 434: {
                return new DVALRecord(recordInputStream);
            }
            case 10: {
                return new EOFRecord(recordInputStream);
            }
            case 4148: {
                return new EndRecord(recordInputStream);
            }
            case 255: {
                return new ExtSSTRecord(recordInputStream);
            }
            case 224: {
                return new ExtendedFormatRecord(recordInputStream);
            }
            case 23: {
                return new ExternSheetRecord(recordInputStream);
            }
            case 35: {
                return new ExternalNameRecord(recordInputStream);
            }
            case 2152: {
                return new FeatRecord(recordInputStream);
            }
            case 2151: {
                return new FeatHdrRecord(recordInputStream);
            }
            case 47: {
                return new FilePassRecord(recordInputStream);
            }
            case 91: {
                return new FileSharingRecord(recordInputStream);
            }
            case 156: {
                return new FnGroupCountRecord(recordInputStream);
            }
            case 4192: {
                return new FontBasisRecord(recordInputStream);
            }
            case 4134: {
                return new FontIndexRecord(recordInputStream);
            }
            case 49: {
                return new FontRecord(recordInputStream);
            }
            case 21: {
                return new FooterRecord(recordInputStream);
            }
            case 1054: {
                return new FormatRecord(recordInputStream);
            }
            case 6: {
                return new FormulaRecord(recordInputStream);
            }
            case 4146: {
                return new FrameRecord(recordInputStream);
            }
            case 130: {
                return new GridsetRecord(recordInputStream);
            }
            case 128: {
                return new GutsRecord(recordInputStream);
            }
            case 131: {
                return new HCenterRecord(recordInputStream);
            }
            case 20: {
                return new HeaderRecord(recordInputStream);
            }
            case 141: {
                return new HideObjRecord(recordInputStream);
            }
            case 27: {
                return new HorizontalPageBreakRecord(recordInputStream);
            }
            case 440: {
                return new HyperlinkRecord(recordInputStream);
            }
            case 523: {
                return new IndexRecord(recordInputStream);
            }
            case 226: {
                return InterfaceEndRecord.create(recordInputStream);
            }
            case 225: {
                return new InterfaceHdrRecord(recordInputStream);
            }
            case 17: {
                return new IterationRecord(recordInputStream);
            }
            case 516: {
                return new LabelRecord(recordInputStream);
            }
            case 253: {
                return new LabelSSTRecord(recordInputStream);
            }
            case 38: {
                return new LeftMarginRecord(recordInputStream);
            }
            case 4117: {
                return new LegendRecord(recordInputStream);
            }
            case 4103: {
                return new LineFormatRecord(recordInputStream);
            }
            case 4177: {
                return new LinkedDataRecord(recordInputStream);
            }
            case 193: {
                return new MMSRecord(recordInputStream);
            }
            case 229: {
                return new MergeCellsRecord(recordInputStream);
            }
            case 190: {
                return new MulBlankRecord(recordInputStream);
            }
            case 189: {
                return new MulRKRecord(recordInputStream);
            }
            case 24: {
                return new NameRecord(recordInputStream);
            }
            case 2196: {
                return new NameCommentRecord(recordInputStream);
            }
            case 28: {
                return new NoteRecord(recordInputStream);
            }
            case 515: {
                return new NumberRecord(recordInputStream);
            }
            case 93: {
                return new ObjRecord(recordInputStream);
            }
            case 4135: {
                return new ObjectLinkRecord(recordInputStream);
            }
            case 146: {
                return new PaletteRecord(recordInputStream);
            }
            case 65: {
                return new PaneRecord(recordInputStream);
            }
            case 19: {
                return new PasswordRecord(recordInputStream);
            }
            case 444: {
                return new PasswordRev4Record(recordInputStream);
            }
            case 4149: {
                return new PlotAreaRecord(recordInputStream);
            }
            case 4196: {
                return new PlotGrowthRecord(recordInputStream);
            }
            case 14: {
                return new PrecisionRecord(recordInputStream);
            }
            case 43: {
                return new PrintGridlinesRecord(recordInputStream);
            }
            case 42: {
                return new PrintHeadersRecord(recordInputStream);
            }
            case 161: {
                return new PrintSetupRecord(recordInputStream);
            }
            case 18: {
                return new ProtectRecord(recordInputStream);
            }
            case 431: {
                return new ProtectionRev4Record(recordInputStream);
            }
            case 638: {
                return new RKRecord(recordInputStream);
            }
            case 449: {
                return new RecalcIdRecord(recordInputStream);
            }
            case 15: {
                return new RefModeRecord(recordInputStream);
            }
            case 439: {
                return new RefreshAllRecord(recordInputStream);
            }
            case 39: {
                return new RightMarginRecord(recordInputStream);
            }
            case 520: {
                return new RowRecord(recordInputStream);
            }
            case 160: {
                return new SCLRecord(recordInputStream);
            }
            case 252: {
                return new SSTRecord(recordInputStream);
            }
            case 95: {
                return new SaveRecalcRecord(recordInputStream);
            }
            case 29: {
                return new SelectionRecord(recordInputStream);
            }
            case 4197: {
                return new SeriesIndexRecord(recordInputStream);
            }
            case 4118: {
                return new SeriesListRecord(recordInputStream);
            }
            case 4099: {
                return new SeriesRecord(recordInputStream);
            }
            case 4109: {
                return new SeriesTextRecord(recordInputStream);
            }
            case 4165: {
                return new SeriesToChartGroupRecord(recordInputStream);
            }
            case 1212: {
                return new SharedFormulaRecord(recordInputStream);
            }
            case 4164: {
                return new SheetPropertiesRecord(recordInputStream);
            }
            case 519: {
                return new StringRecord(recordInputStream);
            }
            case 659: {
                return new StyleRecord(recordInputStream);
            }
            case 430: {
                return new SupBookRecord(recordInputStream);
            }
            case 317: {
                return new TabIdRecord(recordInputStream);
            }
            case 2190: {
                return new TableStylesRecord(recordInputStream);
            }
            case 566: {
                return new TableRecord(recordInputStream);
            }
            case 438: {
                return new TextObjectRecord(recordInputStream);
            }
            case 4133: {
                return new TextRecord(recordInputStream);
            }
            case 4126: {
                return new TickRecord(recordInputStream);
            }
            case 40: {
                return new TopMarginRecord(recordInputStream);
            }
            case 94: {
                return new UncalcedRecord(recordInputStream);
            }
            case 4097: {
                return new UnitsRecord(recordInputStream);
            }
            case 352: {
                return new UseSelFSRecord(recordInputStream);
            }
            case 132: {
                return new VCenterRecord(recordInputStream);
            }
            case 4127: {
                return new ValueRangeRecord(recordInputStream);
            }
            case 26: {
                return new VerticalPageBreakRecord(recordInputStream);
            }
            case 129: {
                return new WSBoolRecord(recordInputStream);
            }
            case 61: {
                return new WindowOneRecord(recordInputStream);
            }
            case 25: {
                return new WindowProtectRecord(recordInputStream);
            }
            case 574: {
                return new WindowTwoRecord(recordInputStream);
            }
            case 92: {
                return new WriteAccessRecord(recordInputStream);
            }
            case 134: {
                return new WriteProtectRecord(recordInputStream);
            }
            case 2134: {
                return new CatLabRecord(recordInputStream);
            }
            case 2131: {
                return new ChartEndBlockRecord(recordInputStream);
            }
            case 2133: {
                return new ChartEndObjectRecord(recordInputStream);
            }
            case 2128: {
                return new ChartFRTInfoRecord(recordInputStream);
            }
            case 2130: {
                return new ChartStartBlockRecord(recordInputStream);
            }
            case 2132: {
                return new ChartStartObjectRecord(recordInputStream);
            }
            case 213: {
                return new StreamIDRecord(recordInputStream);
            }
            case 227: {
                return new ViewSourceRecord(recordInputStream);
            }
            case 182: {
                return new PageItemRecord(recordInputStream);
            }
            case 176: {
                return new ViewDefinitionRecord(recordInputStream);
            }
            case 177: {
                return new ViewFieldsRecord(recordInputStream);
            }
            case 197: {
                return new DataItemRecord(recordInputStream);
            }
            case 256: {
                return new ExtendedPivotTableViewFieldsRecord(recordInputStream);
            }
        }
        return new UnknownRecord(recordInputStream);
    }

    public static void main(String[] stringArray) {
        CommandArgs commandArgs;
        try {
            commandArgs = CommandArgs.parse(stringArray);
        }
        catch (CommandParseException commandParseException) {
            commandParseException.printStackTrace();
            return;
        }
        try {
            PrintStream printStream;
            Closeable closeable;
            if (commandArgs.shouldOutputToFile()) {
                closeable = new FileOutputStream(commandArgs.getFile().getAbsolutePath() + ".out");
                printStream = new PrintStream((OutputStream)closeable);
            } else {
                printStream = System.out;
            }
            closeable = BiffViewer.getPOIFSInputStream(commandArgs.getFile());
            if (commandArgs.shouldOutputRawHexOnly()) {
                int n = ((InputStream)closeable).available();
                byte[] byArray = new byte[n];
                ((InputStream)closeable).read(byArray);
                HexDump.dump(byArray, 0L, System.out, 0);
            } else {
                boolean bl = commandArgs.shouldDumpRecordInterpretations();
                boolean bl2 = commandArgs.shouldDumpBiffHex();
                boolean bl3 = bl;
                BiffViewer.runBiffViewer(printStream, (InputStream)closeable, bl, bl2, bl3, commandArgs.suppressHeader());
            }
            printStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static InputStream getPOIFSInputStream(File file) throws IOException, FileNotFoundException {
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(new FileInputStream(file));
        String string = HSSFWorkbook.getWorkbookDirEntryName(pOIFSFileSystem.getRoot());
        return pOIFSFileSystem.createDocumentInputStream(string);
    }

    protected static void runBiffViewer(PrintStream printStream, InputStream inputStream, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        BiffRecordListener biffRecordListener = new BiffRecordListener(bl2 ? new OutputStreamWriter(printStream) : null, bl3, bl4);
        inputStream = new BiffDumpingStream(inputStream, biffRecordListener);
        BiffViewer.createRecords(inputStream, printStream, biffRecordListener, bl);
    }

    static void hexDumpAligned(Writer writer, byte[] byArray, int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = n2 + n5;
        int n7 = n2 + n5 + n;
        int n8 = n6 % 16;
        int n9 = n7 % 16;
        if (bl) {
            if ((n9 -= n8) < 0) {
                n9 += 16;
            }
            n8 = 0;
        }
        if (bl) {
            n4 = n7 - n9 - (n6 - n8);
            n3 = 0;
        } else {
            n3 = n6 - n8;
            n4 = n7 - n9;
        }
        int n10 = n5 - n8;
        int n11 = n3;
        if (n3 == n4) {
            BiffViewer.hexDumpLine(writer, byArray, n11, n10, n8, n9);
            return;
        }
        BiffViewer.hexDumpLine(writer, byArray, n11, n10, n8, 16);
        while (true) {
            n10 += 16;
            if ((n11 += 16) >= n4) break;
            BiffViewer.hexDumpLine(writer, byArray, n11, n10, 0, 16);
        }
        if (n9 != 0) {
            BiffViewer.hexDumpLine(writer, byArray, n11, n10, 0, n9);
        }
    }

    private static void hexDumpLine(Writer writer, byte[] byArray, int n, int n2, int n3, int n4) {
        if (n3 >= n4) {
            throw new IllegalArgumentException("Bad start/end delta");
        }
        try {
            int n5;
            BiffViewer.writeHex(writer, n, 8);
            writer.write(COLUMN_SEPARATOR);
            for (n5 = 0; n5 < 16; ++n5) {
                if (n5 > 0) {
                    writer.write(" ");
                }
                if (n5 >= n3 && n5 < n4) {
                    BiffViewer.writeHex(writer, byArray[n2 + n5], 2);
                    continue;
                }
                writer.write("  ");
            }
            writer.write(COLUMN_SEPARATOR);
            for (n5 = 0; n5 < 16; ++n5) {
                if (n5 >= n3 && n5 < n4) {
                    writer.write(BiffViewer.getPrintableChar(byArray[n2 + n5]));
                    continue;
                }
                writer.write(" ");
            }
            writer.write(NEW_LINE_CHARS);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static char getPrintableChar(byte by) {
        char c = (char)(by & 0xFF);
        if (c < ' ' || c > '~') {
            return '.';
        }
        return c;
    }

    private static void writeHex(Writer writer, int n, int n2) throws IOException {
        char[] cArray = new char[n2];
        int n3 = n;
        for (int i = n2 - 1; i >= 0; --i) {
            int n4 = n3 & 0xF;
            cArray[i] = (char)(n4 < 10 ? 48 + n4 : 65 + n4 - 10);
            n3 >>= 4;
        }
        writer.write(cArray);
    }

    private static final class BiffDumpingStream
    extends InputStream {
        private final DataInputStream _is;
        private final IBiffRecordListener _listener;
        private final byte[] _data;
        private int _recordCounter;
        private int _overallStreamPos;
        private int _currentPos;
        private int _currentSize;
        private boolean _innerHasReachedEOF;

        public BiffDumpingStream(InputStream inputStream, IBiffRecordListener iBiffRecordListener) {
            this._is = new DataInputStream(inputStream);
            this._listener = iBiffRecordListener;
            this._data = new byte[8228];
            this._recordCounter = 0;
            this._overallStreamPos = 0;
            this._currentSize = 0;
            this._currentPos = 0;
        }

        public int read() throws IOException {
            if (this._currentPos >= this._currentSize) {
                this.fillNextBuffer();
            }
            if (this._currentPos >= this._currentSize) {
                return -1;
            }
            int n = this._data[this._currentPos] & 0xFF;
            ++this._currentPos;
            ++this._overallStreamPos;
            this.formatBufferIfAtEndOfRec();
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (this._currentPos >= this._currentSize) {
                this.fillNextBuffer();
            }
            if (this._currentPos >= this._currentSize) {
                return -1;
            }
            int n4 = this._currentSize - this._currentPos;
            if (n2 > n4) {
                System.err.println("Unexpected request to read past end of current biff record");
                n3 = n4;
            } else {
                n3 = n2;
            }
            System.arraycopy(this._data, this._currentPos, byArray, n, n3);
            this._currentPos += n3;
            this._overallStreamPos += n3;
            this.formatBufferIfAtEndOfRec();
            return n3;
        }

        public int available() throws IOException {
            return this._currentSize - this._currentPos + this._is.available();
        }

        private void fillNextBuffer() throws IOException {
            if (this._innerHasReachedEOF) {
                return;
            }
            int n = this._is.read();
            if (n == -1) {
                this._innerHasReachedEOF = true;
                return;
            }
            this._data[0] = (byte)n;
            this._is.readFully(this._data, 1, 3);
            short s = LittleEndian.getShort(this._data, 2);
            this._is.readFully(this._data, 4, s);
            this._currentPos = 0;
            this._currentSize = s + 4;
            ++this._recordCounter;
        }

        private void formatBufferIfAtEndOfRec() {
            if (this._currentPos != this._currentSize) {
                return;
            }
            int n = this._currentSize - 4;
            short s = LittleEndian.getShort(this._data, 0);
            int n2 = this._overallStreamPos - this._currentSize;
            this._listener.processRecord(n2, this._recordCounter, s, n, this._data);
        }

        public void close() throws IOException {
            this._is.close();
        }
    }

    private static interface IBiffRecordListener {
        public void processRecord(int var1, int var2, int var3, int var4, byte[] var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BiffRecordListener
    implements IBiffRecordListener {
        private final Writer _hexDumpWriter;
        private List<String> _headers;
        private final boolean _zeroAlignEachRecord;
        private final boolean _noHeader;

        public BiffRecordListener(Writer writer, boolean bl, boolean bl2) {
            this._hexDumpWriter = writer;
            this._zeroAlignEachRecord = bl;
            this._noHeader = bl2;
            this._headers = new ArrayList<String>();
        }

        @Override
        public void processRecord(int n, int n2, int n3, int n4, byte[] byArray) {
            Writer writer;
            String string = BiffRecordListener.formatRecordDetails(n, n3, n4, n2);
            if (!this._noHeader) {
                this._headers.add(string);
            }
            if ((writer = this._hexDumpWriter) != null) {
                try {
                    writer.write(string);
                    writer.write(NEW_LINE_CHARS);
                    BiffViewer.hexDumpAligned(writer, byArray, n4 + 4, n, this._zeroAlignEachRecord);
                    writer.flush();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }

        public List<String> getRecentHeaders() {
            List<String> list = this._headers;
            this._headers = new ArrayList<String>();
            return list;
        }

        private static String formatRecordDetails(int n, int n2, int n3, int n4) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("Offset=").append(HexDump.intToHex(n)).append("(").append(n).append(")");
            stringBuffer.append(" recno=").append(n4);
            stringBuffer.append(" sid=").append(HexDump.shortToHex(n2));
            stringBuffer.append(" size=").append(HexDump.shortToHex(n3)).append("(").append(n3).append(")");
            return stringBuffer.toString();
        }
    }

    private static final class CommandParseException
    extends Exception {
        public CommandParseException(String string) {
            super(string);
        }
    }

    private static final class CommandArgs {
        private final boolean _biffhex;
        private final boolean _noint;
        private final boolean _out;
        private final boolean _rawhex;
        private final boolean _noHeader;
        private final File _file;

        private CommandArgs(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, File file) {
            this._biffhex = bl;
            this._noint = bl2;
            this._out = bl3;
            this._rawhex = bl4;
            this._file = file;
            this._noHeader = bl5;
        }

        public static CommandArgs parse(String[] stringArray) throws CommandParseException {
            int n = stringArray.length;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            File file = null;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                if (string.startsWith("--")) {
                    if ("--biffhex".equals(string)) {
                        bl = true;
                        continue;
                    }
                    if ("--noint".equals(string)) {
                        bl2 = true;
                        continue;
                    }
                    if ("--out".equals(string)) {
                        bl3 = true;
                        continue;
                    }
                    if ("--escher".equals(string)) {
                        System.setProperty("poi.deserialize.escher", "true");
                        continue;
                    }
                    if ("--rawhex".equals(string)) {
                        bl4 = true;
                        continue;
                    }
                    if ("--noheader".equals(string)) {
                        bl5 = true;
                        continue;
                    }
                    throw new CommandParseException("Unexpected option '" + string + "'");
                }
                file = new File(string);
                if (!file.exists()) {
                    throw new CommandParseException("Specified file '" + string + "' does not exist");
                }
                if (i + 1 >= n) continue;
                throw new CommandParseException("File name must be the last arg");
            }
            if (file == null) {
                throw new CommandParseException("Biff viewer needs a filename");
            }
            return new CommandArgs(bl, bl2, bl3, bl4, bl5, file);
        }

        public boolean shouldDumpBiffHex() {
            return this._biffhex;
        }

        public boolean shouldDumpRecordInterpretations() {
            return !this._noint;
        }

        public boolean shouldOutputToFile() {
            return this._out;
        }

        public boolean shouldOutputRawHexOnly() {
            return this._rawhex;
        }

        public boolean suppressHeader() {
            return this._noHeader;
        }

        public File getFile() {
            return this._file;
        }
    }
}

