/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hpsf;

import ai.org.apache.poi.hpsf.IllegalPropertySetDataException;
import ai.org.apache.poi.util.Internal;
import ai.org.apache.poi.util.LittleEndian;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import ai.org.apache.poi.util.StringUtil;

@Internal
class UnicodeString {
    private static final POILogger logger = POILogFactory.getLogger(UnicodeString.class);
    private byte[] _value;

    UnicodeString(byte[] byArray, int n) {
        int n2 = LittleEndian.getInt(byArray, n);
        int n3 = n + 4;
        if (!this.validLength(n2, byArray, n3)) {
            boolean bl = false;
            int n4 = n % 4;
            if (n4 != 0) {
                n2 = LittleEndian.getInt(byArray, n += n4);
                n3 = n + 4;
                bl = this.validLength(n2, byArray, n3);
            }
            if (!bl) {
                throw new IllegalPropertySetDataException("UnicodeString started at offset #" + n + " is not NULL-terminated");
            }
        }
        if (n2 == 0) {
            this._value = new byte[0];
            return;
        }
        this._value = LittleEndian.getByteArray(byArray, n3, n2 * 2);
    }

    boolean validLength(int n, byte[] byArray, int n2) {
        if (n == 0) {
            return true;
        }
        int n3 = n2 + n * 2;
        return n3 <= byArray.length && byArray[n3 - 1] == 0 && byArray[n3 - 2] == 0;
    }

    int getSize() {
        return 4 + this._value.length;
    }

    byte[] getValue() {
        return this._value;
    }

    String toJavaString() {
        if (this._value.length == 0) {
            return null;
        }
        String string = StringUtil.getFromUnicodeLE(this._value, 0, this._value.length >> 1);
        int n = string.indexOf(0);
        if (n == -1) {
            logger.log(5, "String terminator (\\0) for UnicodeString property value not found.Continue without trimming and hope for the best.");
            return string;
        }
        if (n != string.length() - 1) {
            logger.log(5, "String terminator (\\0) for UnicodeString property value occured before the end of string. Trimming and hope for the best.");
        }
        return string.substring(0, n);
    }
}

