/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hpsf;

import ai.org.apache.poi.hpsf.Array;
import ai.org.apache.poi.hpsf.Blob;
import ai.org.apache.poi.hpsf.ClipboardData;
import ai.org.apache.poi.hpsf.CodePageString;
import ai.org.apache.poi.hpsf.Currency;
import ai.org.apache.poi.hpsf.Date;
import ai.org.apache.poi.hpsf.Decimal;
import ai.org.apache.poi.hpsf.Filetime;
import ai.org.apache.poi.hpsf.GUID;
import ai.org.apache.poi.hpsf.IndirectPropertyName;
import ai.org.apache.poi.hpsf.UnicodeString;
import ai.org.apache.poi.hpsf.VariantBool;
import ai.org.apache.poi.hpsf.Vector;
import ai.org.apache.poi.hpsf.VersionedStream;
import ai.org.apache.poi.util.Internal;
import ai.org.apache.poi.util.LittleEndian;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;

@Internal
class TypedPropertyValue {
    private static final POILogger logger = POILogFactory.getLogger(TypedPropertyValue.class);
    private int _type;
    private Object _value;

    TypedPropertyValue() {
    }

    TypedPropertyValue(byte[] byArray, int n) {
        this.read(byArray, n);
    }

    TypedPropertyValue(int n, Object object) {
        this._type = n;
        this._value = object;
    }

    Object getValue() {
        return this._value;
    }

    int read(byte[] byArray, int n) {
        int n2 = n;
        this._type = LittleEndian.getShort(byArray, n2);
        short s = LittleEndian.getShort(byArray, n2 += 2);
        n2 += 2;
        if (s != 0) {
            logger.log(5, "TypedPropertyValue padding at offset " + n2 + " MUST be 0, but it's value is " + s);
        }
        n2 += this.readValue(byArray, n2);
        return n2 - n;
    }

    int readValue(byte[] byArray, int n) {
        switch (this._type) {
            case 0: 
            case 1: {
                this._value = null;
                return 0;
            }
            case 2: {
                this._value = LittleEndian.getShort(byArray, n);
                return 4;
            }
            case 3: {
                this._value = LittleEndian.getInt(byArray, n);
                return 4;
            }
            case 4: {
                this._value = LittleEndian.getShort(byArray, n);
                return 4;
            }
            case 5: {
                this._value = LittleEndian.getDouble(byArray, n);
                return 8;
            }
            case 6: {
                this._value = new Currency(byArray, n);
                return 8;
            }
            case 7: {
                this._value = new Date(byArray, n);
                return 8;
            }
            case 8: {
                this._value = new CodePageString(byArray, n);
                return ((CodePageString)this._value).getSize();
            }
            case 10: {
                this._value = LittleEndian.getUInt(byArray, n);
                return 4;
            }
            case 11: {
                this._value = new VariantBool(byArray, n);
                return 2;
            }
            case 14: {
                this._value = new Decimal(byArray, n);
                return 16;
            }
            case 16: {
                this._value = byArray[n];
                return 1;
            }
            case 17: {
                this._value = LittleEndian.getUByte(byArray, n);
                return 2;
            }
            case 18: {
                this._value = LittleEndian.getUShort(byArray, n);
                return 4;
            }
            case 19: {
                this._value = LittleEndian.getUInt(byArray, n);
                return 4;
            }
            case 20: {
                this._value = LittleEndian.getLong(byArray, n);
                return 8;
            }
            case 21: {
                this._value = LittleEndian.getByteArray(byArray, n, 8);
                return 8;
            }
            case 22: {
                this._value = LittleEndian.getInt(byArray, n);
                return 4;
            }
            case 23: {
                this._value = LittleEndian.getUInt(byArray, n);
                return 4;
            }
            case 30: {
                this._value = new CodePageString(byArray, n);
                return ((CodePageString)this._value).getSize();
            }
            case 31: {
                this._value = new UnicodeString(byArray, n);
                return ((UnicodeString)this._value).getSize();
            }
            case 64: {
                this._value = new Filetime(byArray, n);
                return 8;
            }
            case 65: {
                this._value = new Blob(byArray, n);
                return ((Blob)this._value).getSize();
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                this._value = new IndirectPropertyName(byArray, n);
                return ((IndirectPropertyName)this._value).getSize();
            }
            case 70: {
                this._value = new Blob(byArray, n);
                return ((Blob)this._value).getSize();
            }
            case 71: {
                this._value = new ClipboardData(byArray, n);
                return ((ClipboardData)this._value).getSize();
            }
            case 72: {
                this._value = new GUID(byArray, n);
                return 16;
            }
            case 73: {
                this._value = new VersionedStream(byArray, n);
                return ((VersionedStream)this._value).getSize();
            }
            case 4098: 
            case 4099: 
            case 4100: 
            case 4101: 
            case 4102: 
            case 4103: 
            case 4104: 
            case 4106: 
            case 4107: 
            case 4108: 
            case 4112: 
            case 4113: 
            case 4114: 
            case 4115: 
            case 4116: 
            case 4117: 
            case 4126: 
            case 4127: 
            case 4160: 
            case 4167: 
            case 4168: {
                this._value = new Vector((short)(this._type & 0xFFF));
                return ((Vector)this._value).read(byArray, n);
            }
            case 8194: 
            case 8195: 
            case 8196: 
            case 8197: 
            case 8198: 
            case 8199: 
            case 8200: 
            case 8202: 
            case 8203: 
            case 8204: 
            case 8206: 
            case 8208: 
            case 8209: 
            case 8210: 
            case 8211: 
            case 8214: 
            case 8215: {
                this._value = new Array();
                return ((Array)this._value).read(byArray, n);
            }
        }
        throw new UnsupportedOperationException("Unknown (possibly, incorrect) TypedPropertyValue type: " + this._type);
    }

    int readValuePadded(byte[] byArray, int n) {
        int n2 = this.readValue(byArray, n);
        return (n2 & 3) == 0 ? n2 : n2 + (4 - (n2 & 3));
    }
}

