/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hpsf;

import ai.org.apache.poi.hpsf.ClassID;
import ai.org.apache.poi.hpsf.HPSFRuntimeException;
import ai.org.apache.poi.hpsf.Property;
import ai.org.apache.poi.hpsf.Util;
import ai.org.apache.poi.hpsf.wellknown.SectionIDMap;
import ai.org.apache.poi.util.LittleEndian;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Section {
    protected Map<Long, String> dictionary;
    protected ClassID formatID;
    protected long offset;
    protected int size;
    protected Property[] properties;
    private boolean wasNull;

    public ClassID getFormatID() {
        return this.formatID;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public int getPropertyCount() {
        return this.properties.length;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    protected Section() {
    }

    public Section(byte[] byArray, int n) throws UnsupportedEncodingException {
        Object object;
        PropertyListEntry propertyListEntry3;
        int n2;
        int n3 = n;
        this.formatID = new ClassID(byArray, n3);
        this.offset = LittleEndian.getUInt(byArray, n3 += 16);
        n3 = (int)this.offset;
        this.size = (int)LittleEndian.getUInt(byArray, n3);
        int n4 = (int)LittleEndian.getUInt(byArray, n3 += 4);
        this.properties = new Property[n4];
        int n5 = n3 += 4;
        ArrayList<PropertyListEntry> arrayList = new ArrayList<PropertyListEntry>(n4);
        for (n2 = 0; n2 < this.properties.length; ++n2) {
            propertyListEntry3 = new PropertyListEntry();
            propertyListEntry3.id = (int)LittleEndian.getUInt(byArray, n5);
            propertyListEntry3.offset = (int)LittleEndian.getUInt(byArray, n5 += 4);
            n5 += 4;
            arrayList.add(propertyListEntry3);
        }
        Collections.sort(arrayList);
        for (n2 = 0; n2 < n4 - 1; ++n2) {
            object = (PropertyListEntry)arrayList.get(n2);
            PropertyListEntry propertyListEntry2 = (PropertyListEntry)arrayList.get(n2 + 1);
            ((PropertyListEntry)object).length = propertyListEntry2.offset - ((PropertyListEntry)object).offset;
        }
        if (n4 > 0) {
            propertyListEntry3 = (PropertyListEntry)arrayList.get(n4 - 1);
            propertyListEntry3.length = this.size - propertyListEntry3.offset;
        }
        n2 = -1;
        object = arrayList.iterator();
        while (n2 == -1 && object.hasNext()) {
            propertyListEntry3 = (PropertyListEntry)object.next();
            if (propertyListEntry3.id != 1) continue;
            int n6 = (int)(this.offset + (long)propertyListEntry3.offset);
            long l = LittleEndian.getUInt(byArray, n6);
            n6 += 4;
            if (l != 2L) {
                throw new HPSFRuntimeException("Value type of property ID 1 is not VT_I2 but " + l + ".");
            }
            n2 = LittleEndian.getUShort(byArray, n6);
        }
        int n7 = 0;
        for (PropertyListEntry propertyListEntry3 : arrayList) {
            Property property = new Property(propertyListEntry3.id, byArray, this.offset + (long)propertyListEntry3.offset, propertyListEntry3.length, n2);
            if (property.getID() == 1L) {
                property = new Property(property.getID(), property.getType(), n2);
            }
            this.properties[n7++] = property;
        }
        this.dictionary = (Map)this.getProperty(0L);
    }

    public Object getProperty(long l) {
        this.wasNull = false;
        for (int i = 0; i < this.properties.length; ++i) {
            if (l != this.properties[i].getID()) continue;
            return this.properties[i].getValue();
        }
        this.wasNull = true;
        return null;
    }

    protected int getPropertyIntValue(long l) {
        Object object = this.getProperty(l);
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Long) && !(object instanceof Integer)) {
            throw new HPSFRuntimeException("This property is not an integer type, but " + object.getClass().getName() + ".");
        }
        Number number = (Number)object;
        return number.intValue();
    }

    protected boolean getPropertyBooleanValue(int n) {
        Boolean bl = (Boolean)this.getProperty(n);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public String getPIDString(long l) {
        String string = null;
        if (this.dictionary != null) {
            string = this.dictionary.get(l);
        }
        if (string == null) {
            string = SectionIDMap.getPIDString(this.getFormatID().getBytes(), l);
        }
        if (string == null) {
            string = "[undefined]";
        }
        return string;
    }

    public boolean equals(Object object) {
        long l;
        int n;
        if (object == null || !(object instanceof Section)) {
            return false;
        }
        Section section = (Section)object;
        if (!section.getFormatID().equals(this.getFormatID())) {
            return false;
        }
        Object[] objectArray = new Property[this.getProperties().length];
        Object[] objectArray2 = new Property[section.getProperties().length];
        System.arraycopy(this.getProperties(), 0, objectArray, 0, objectArray.length);
        System.arraycopy(section.getProperties(), 0, objectArray2, 0, objectArray2.length);
        Property property = null;
        Property property2 = null;
        for (n = 0; n < objectArray.length; ++n) {
            l = objectArray[n].getID();
            if (l == 0L) {
                property = objectArray[n];
                objectArray = this.remove((Property[])objectArray, n);
                --n;
            }
            if (l != 1L) continue;
            objectArray = this.remove((Property[])objectArray, n);
            --n;
        }
        for (n = 0; n < objectArray2.length; ++n) {
            l = objectArray2[n].getID();
            if (l == 0L) {
                property2 = objectArray2[n];
                objectArray2 = this.remove((Property[])objectArray2, n);
                --n;
            }
            if (l != 1L) continue;
            objectArray2 = this.remove((Property[])objectArray2, n);
            --n;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        n = 1;
        if (property != null && property2 != null) {
            n = property.getValue().equals(property2.getValue()) ? 1 : 0;
        } else if (property != null || property2 != null) {
            n = 0;
        }
        if (n != 0) {
            return Util.equals(objectArray, objectArray2);
        }
        return false;
    }

    private Property[] remove(Property[] propertyArray, int n) {
        Property[] propertyArray2 = new Property[propertyArray.length - 1];
        if (n > 0) {
            System.arraycopy(propertyArray, 0, propertyArray2, 0, n);
        }
        System.arraycopy(propertyArray, n + 1, propertyArray2, n, propertyArray2.length - n);
        return propertyArray2;
    }

    public int hashCode() {
        int n;
        long l = 0L;
        l += (long)this.getFormatID().hashCode();
        Property[] propertyArray = this.getProperties();
        for (n = 0; n < propertyArray.length; ++n) {
            l += (long)propertyArray[n].hashCode();
        }
        n = (int)(l & 0xFFFFFFFFL);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Property[] propertyArray = this.getProperties();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("formatID: ");
        stringBuffer.append(this.getFormatID());
        stringBuffer.append(", offset: ");
        stringBuffer.append(this.getOffset());
        stringBuffer.append(", propertyCount: ");
        stringBuffer.append(this.getPropertyCount());
        stringBuffer.append(", size: ");
        stringBuffer.append(this.getSize());
        stringBuffer.append(", properties: [\n");
        for (int i = 0; i < propertyArray.length; ++i) {
            stringBuffer.append(propertyArray[i].toString());
            stringBuffer.append(",\n");
        }
        stringBuffer.append(']');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Map<Long, String> getDictionary() {
        return this.dictionary;
    }

    public int getCodepage() {
        Integer n = (Integer)this.getProperty(1L);
        if (n == null) {
            return -1;
        }
        int n2 = n;
        return n2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyListEntry
    implements Comparable<PropertyListEntry> {
        int id;
        int offset;
        int length;

        PropertyListEntry() {
        }

        @Override
        public int compareTo(PropertyListEntry propertyListEntry) {
            int n = propertyListEntry.offset;
            if (this.offset < n) {
                return -1;
            }
            if (this.offset == n) {
                return 0;
            }
            return 1;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append("[id=");
            stringBuffer.append(this.id);
            stringBuffer.append(", offset=");
            stringBuffer.append(this.offset);
            stringBuffer.append(", length=");
            stringBuffer.append(this.length);
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

