/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hpsf;

import ai.org.apache.poi.util.Internal;
import ai.org.apache.poi.util.LittleEndian;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.io.OutputStream;

@Internal
class ClipboardData {
    private static final POILogger logger = POILogFactory.getLogger(ClipboardData.class);
    private int _format;
    private byte[] _value;

    ClipboardData(byte[] byArray, int n) {
        int n2 = LittleEndian.getInt(byArray, n);
        if (n2 < 4) {
            logger.log(5, (Object)"ClipboardData at offset ", (Object)n, " size less than 4 bytes (doesn't even have format field!). Setting to format == 0 and hope for the best");
            this._format = 0;
            this._value = new byte[0];
            return;
        }
        this._format = LittleEndian.getInt(byArray, n + 4);
        this._value = LittleEndian.getByteArray(byArray, n + 8, n2 - 4);
    }

    int getSize() {
        return 8 + this._value.length;
    }

    byte[] getValue() {
        return this._value;
    }

    byte[] toByteArray() {
        byte[] byArray = new byte[this.getSize()];
        LittleEndian.putInt(byArray, 0, 4 + this._value.length);
        LittleEndian.putInt(byArray, 4, this._format);
        System.arraycopy(this._value, 0, byArray, 8, this._value.length);
        return byArray;
    }

    int write(OutputStream outputStream) throws IOException {
        LittleEndian.putInt(4 + this._value.length, outputStream);
        LittleEndian.putInt(this._format, outputStream);
        outputStream.write(this._value);
        return 8 + this._value.length;
    }
}

