/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ddf;

import ai.org.apache.poi.ddf.EscherRecord;
import ai.org.apache.poi.ddf.EscherRecordFactory;
import ai.org.apache.poi.ddf.EscherSerializationListener;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndian;
import ai.org.apache.poi.util.RecordFormatException;

public class EscherSplitMenuColorsRecord
extends EscherRecord {
    public static final short RECORD_ID = -3810;
    public static final String RECORD_DESCRIPTION = "MsofbtSplitMenuColors";
    private int field_1_color1;
    private int field_2_color2;
    private int field_3_color3;
    private int field_4_color4;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        int n4 = 0;
        this.field_1_color1 = LittleEndian.getInt(byArray, n3 + n4);
        this.field_2_color2 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_3_color3 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_4_color4 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        if ((n2 -= (n4 += 4)) != 0) {
            throw new RecordFormatException("Expecting no remaining data but got " + n2 + " byte(s).");
        }
        return 8 + n4 + n2;
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        int n2 = n;
        LittleEndian.putShort(byArray, n2, this.getOptions());
        LittleEndian.putShort(byArray, n2 += 2, this.getRecordId());
        int n3 = this.getRecordSize() - 8;
        LittleEndian.putInt(byArray, n2 += 2, n3);
        LittleEndian.putInt(byArray, n2 += 4, this.field_1_color1);
        LittleEndian.putInt(byArray, n2 += 4, this.field_2_color2);
        LittleEndian.putInt(byArray, n2 += 4, this.field_3_color3);
        LittleEndian.putInt(byArray, n2 += 4, this.field_4_color4);
        escherSerializationListener.afterRecordSerialize(n2 += 4, this.getRecordId(), n2 - n, this);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 24;
    }

    public short getRecordId() {
        return -3810;
    }

    public String getRecordName() {
        return "SplitMenuColors";
    }

    public String toString() {
        return this.getClass().getName() + ":" + '\n' + "  RecordId: 0x" + HexDump.toHex((short)-3810) + '\n' + "  Version: 0x" + HexDump.toHex(this.getVersion()) + '\n' + "  Instance: 0x" + HexDump.toHex(this.getInstance()) + '\n' + "  Color1: 0x" + HexDump.toHex(this.field_1_color1) + '\n' + "  Color2: 0x" + HexDump.toHex(this.field_2_color2) + '\n' + "  Color3: 0x" + HexDump.toHex(this.field_3_color3) + '\n' + "  Color4: 0x" + HexDump.toHex(this.field_4_color4) + '\n' + "";
    }

    public String toXml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.formatXmlRecordHeader(this.getClass().getSimpleName(), HexDump.toHex(this.getRecordId()), HexDump.toHex(this.getVersion()), HexDump.toHex(this.getInstance()))).append(string).append("\t").append("<Color1>0x").append(HexDump.toHex(this.field_1_color1)).append("</Color1>\n").append(string).append("\t").append("<Color2>0x").append(HexDump.toHex(this.field_2_color2)).append("</Color2>\n").append(string).append("\t").append("<Color3>0x").append(HexDump.toHex(this.field_3_color3)).append("</Color3>\n").append(string).append("\t").append("<Color4>0x").append(HexDump.toHex(this.field_4_color4)).append("</Color4>\n");
        stringBuilder.append(string).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return stringBuilder.toString();
    }

    public int getColor1() {
        return this.field_1_color1;
    }

    public void setColor1(int n) {
        this.field_1_color1 = n;
    }

    public int getColor2() {
        return this.field_2_color2;
    }

    public void setColor2(int n) {
        this.field_2_color2 = n;
    }

    public int getColor3() {
        return this.field_3_color3;
    }

    public void setColor3(int n) {
        this.field_3_color3 = n;
    }

    public int getColor4() {
        return this.field_4_color4;
    }

    public void setColor4(int n) {
        this.field_4_color4 = n;
    }
}

