/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ddf;

import ai.org.apache.poi.ddf.EscherProperties;

public abstract class EscherProperty {
    private short _id;

    public EscherProperty(short s) {
        this._id = s;
    }

    public EscherProperty(short s, boolean bl, boolean bl2) {
        this._id = (short)(s + (bl ? 32768 : 0) + (bl2 ? 16384 : 0));
    }

    public short getId() {
        return this._id;
    }

    public short getPropertyNumber() {
        return (short)(this._id & 0x3FFF);
    }

    public boolean isComplex() {
        return (this._id & Short.MIN_VALUE) != 0;
    }

    public boolean isBlipId() {
        return (this._id & 0x4000) != 0;
    }

    public String getName() {
        return EscherProperties.getPropertyName(this.getPropertyNumber());
    }

    public int getPropertySize() {
        return 6;
    }

    public String toXml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("<").append(this.getClass().getSimpleName()).append(" id=\"").append(this.getId()).append("\" name=\"").append(this.getName()).append("\" blipId=\"").append(this.isBlipId()).append("\"/>\n");
        return stringBuilder.toString();
    }

    public abstract int serializeSimplePart(byte[] var1, int var2);

    public abstract int serializeComplexPart(byte[] var1, int var2);
}

