/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ddf;

import ai.org.apache.poi.ddf.EscherRecord;
import ai.org.apache.poi.ddf.EscherRecordFactory;
import ai.org.apache.poi.ddf.EscherSerializationListener;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndian;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EscherContainerRecord
extends EscherRecord {
    public static final short DGG_CONTAINER = -4096;
    public static final short BSTORE_CONTAINER = -4095;
    public static final short DG_CONTAINER = -4094;
    public static final short SPGR_CONTAINER = -4093;
    public static final short SP_CONTAINER = -4092;
    public static final short SOLVER_CONTAINER = -4091;
    private static POILogger log = POILogFactory.getLogger(EscherContainerRecord.class);
    private int _remainingLength;
    private final List<EscherRecord> _childRecords = new ArrayList<EscherRecord>();

    @Override
    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = 8;
        int n4 = n + 8;
        while (n2 > 0 && n4 < byArray.length) {
            EscherRecord escherRecord = escherRecordFactory.createRecord(byArray, n4);
            int n5 = escherRecord.fillFields(byArray, n4, escherRecordFactory);
            n3 += n5;
            this.addChildRecord(escherRecord);
            if ((n4 += n5) < byArray.length || (n2 -= n5) <= 0) continue;
            this._remainingLength = n2;
            if (!log.check(5)) continue;
            log.log(5, "Not enough Escher data: " + n2 + " bytes remaining but no space left");
        }
        return n3;
    }

    @Override
    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        int n2 = 0;
        for (EscherRecord escherRecord : this._childRecords) {
            n2 += escherRecord.getRecordSize();
        }
        LittleEndian.putInt(byArray, n + 4, n2 += this._remainingLength);
        int n3 = n + 8;
        for (EscherRecord escherRecord : this._childRecords) {
            n3 += escherRecord.serialize(n3, byArray, escherSerializationListener);
        }
        escherSerializationListener.afterRecordSerialize(n3, this.getRecordId(), n3 - n, this);
        return n3 - n;
    }

    @Override
    public int getRecordSize() {
        int n = 0;
        for (EscherRecord escherRecord : this._childRecords) {
            n += escherRecord.getRecordSize();
        }
        return 8 + n;
    }

    public boolean hasChildOfType(short s) {
        for (EscherRecord escherRecord : this._childRecords) {
            if (escherRecord.getRecordId() != s) continue;
            return true;
        }
        return false;
    }

    @Override
    public EscherRecord getChild(int n) {
        return this._childRecords.get(n);
    }

    @Override
    public List<EscherRecord> getChildRecords() {
        return new ArrayList<EscherRecord>(this._childRecords);
    }

    public Iterator<EscherRecord> getChildIterator() {
        return new ReadOnlyIterator(this._childRecords);
    }

    @Override
    public void setChildRecords(List<EscherRecord> list) {
        if (list == this._childRecords) {
            throw new IllegalStateException("Child records private data member has escaped");
        }
        this._childRecords.clear();
        this._childRecords.addAll(list);
    }

    public boolean removeChildRecord(EscherRecord escherRecord) {
        return this._childRecords.remove(escherRecord);
    }

    public List<EscherContainerRecord> getChildContainers() {
        ArrayList<EscherContainerRecord> arrayList = new ArrayList<EscherContainerRecord>();
        for (EscherRecord escherRecord : this._childRecords) {
            if (!(escherRecord instanceof EscherContainerRecord)) continue;
            arrayList.add((EscherContainerRecord)escherRecord);
        }
        return arrayList;
    }

    @Override
    public String getRecordName() {
        switch (this.getRecordId()) {
            case -4096: {
                return "DggContainer";
            }
            case -4095: {
                return "BStoreContainer";
            }
            case -4094: {
                return "DgContainer";
            }
            case -4093: {
                return "SpgrContainer";
            }
            case -4092: {
                return "SpContainer";
            }
            case -4091: {
                return "SolverContainer";
            }
        }
        return "Container 0x" + HexDump.toHex(this.getRecordId());
    }

    @Override
    public void display(PrintWriter printWriter, int n) {
        super.display(printWriter, n);
        for (EscherRecord escherRecord : this._childRecords) {
            escherRecord.display(printWriter, n + 1);
        }
    }

    public void addChildRecord(EscherRecord escherRecord) {
        this._childRecords.add(escherRecord);
    }

    public void addChildBefore(EscherRecord escherRecord, int n) {
        for (int i = 0; i < this._childRecords.size(); ++i) {
            EscherRecord escherRecord2 = this._childRecords.get(i);
            if (escherRecord2.getRecordId() != n) continue;
            this._childRecords.add(i++, escherRecord);
        }
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        if (this._childRecords.size() > 0) {
            stringBuffer.append("  children: " + string);
            int n = 0;
            for (EscherRecord escherRecord : this._childRecords) {
                stringBuffer.append("   Child " + n + ":" + string);
                String string2 = String.valueOf(escherRecord);
                string2 = string2.replaceAll("\n", "\n    ");
                stringBuffer.append("    ");
                stringBuffer.append(string2);
                stringBuffer.append(string);
                ++n;
            }
        }
        return this.getClass().getName() + " (" + this.getRecordName() + "):" + string + "  isContainer: " + this.isContainerRecord() + string + "  version: 0x" + HexDump.toHex(this.getVersion()) + string + "  instance: 0x" + HexDump.toHex(this.getInstance()) + string + "  recordId: 0x" + HexDump.toHex(this.getRecordId()) + string + "  numchildren: " + this._childRecords.size() + string + stringBuffer.toString();
    }

    @Override
    public String toXml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.formatXmlRecordHeader(this.getRecordName(), HexDump.toHex(this.getRecordId()), HexDump.toHex(this.getVersion()), HexDump.toHex(this.getInstance())));
        for (EscherRecord escherRecord : this._childRecords) {
            stringBuilder.append(escherRecord.toXml(string + "\t"));
        }
        stringBuilder.append(string).append("</").append(this.getRecordName()).append(">\n");
        return stringBuilder.toString();
    }

    public <T extends EscherRecord> T getChildById(short s) {
        for (EscherRecord escherRecord : this._childRecords) {
            if (escherRecord.getRecordId() != s) continue;
            EscherRecord escherRecord2 = escherRecord;
            return (T)escherRecord2;
        }
        return null;
    }

    public void getRecordsById(short s, List<EscherRecord> list) {
        for (EscherRecord escherRecord : this._childRecords) {
            if (escherRecord instanceof EscherContainerRecord) {
                EscherContainerRecord escherContainerRecord = (EscherContainerRecord)escherRecord;
                escherContainerRecord.getRecordsById(s, list);
                continue;
            }
            if (escherRecord.getRecordId() != s) continue;
            list.add(escherRecord);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReadOnlyIterator
    implements Iterator<EscherRecord> {
        private final List<EscherRecord> _list;
        private int _index;

        public ReadOnlyIterator(List<EscherRecord> list) {
            this._list = list;
            this._index = 0;
        }

        @Override
        public boolean hasNext() {
            return this._index < this._list.size();
        }

        @Override
        public EscherRecord next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this._list.get(this._index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

