/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ddf;

import ai.org.apache.poi.ddf.EscherRecord;
import ai.org.apache.poi.ddf.EscherRecordFactory;
import ai.org.apache.poi.ddf.EscherSerializationListener;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndian;

public class EscherChildAnchorRecord
extends EscherRecord {
    public static final short RECORD_ID = -4081;
    public static final String RECORD_DESCRIPTION = "MsofbtChildAnchor";
    private int field_1_dx1;
    private int field_2_dy1;
    private int field_3_dx2;
    private int field_4_dy2;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        int n4 = 0;
        this.field_1_dx1 = LittleEndian.getInt(byArray, n3 + n4);
        this.field_2_dy1 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_3_dx2 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        this.field_4_dy2 = LittleEndian.getInt(byArray, n3 + (n4 += 4));
        return 8 + (n4 += 4);
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        int n2 = n;
        LittleEndian.putShort(byArray, n2, this.getOptions());
        LittleEndian.putShort(byArray, n2 += 2, this.getRecordId());
        LittleEndian.putInt(byArray, n2 += 2, this.getRecordSize() - 8);
        LittleEndian.putInt(byArray, n2 += 4, this.field_1_dx1);
        LittleEndian.putInt(byArray, n2 += 4, this.field_2_dy1);
        LittleEndian.putInt(byArray, n2 += 4, this.field_3_dx2);
        LittleEndian.putInt(byArray, n2 += 4, this.field_4_dy2);
        escherSerializationListener.afterRecordSerialize(n2 += 4, this.getRecordId(), n2 - n, this);
        return n2 - n;
    }

    public int getRecordSize() {
        return 24;
    }

    public short getRecordId() {
        return -4081;
    }

    public String getRecordName() {
        return "ChildAnchor";
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return this.getClass().getName() + ":" + string + "  RecordId: 0x" + HexDump.toHex((short)-4081) + string + "  Version: 0x" + HexDump.toHex(this.getVersion()) + string + "  Instance: 0x" + HexDump.toHex(this.getInstance()) + string + "  X1: " + this.field_1_dx1 + string + "  Y1: " + this.field_2_dy1 + string + "  X2: " + this.field_3_dx2 + string + "  Y2: " + this.field_4_dy2 + string;
    }

    public String toXml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.formatXmlRecordHeader(this.getClass().getSimpleName(), HexDump.toHex(this.getRecordId()), HexDump.toHex(this.getVersion()), HexDump.toHex(this.getInstance()))).append(string).append("\t").append("<X1>").append(this.field_1_dx1).append("</X1>\n").append(string).append("\t").append("<Y1>").append(this.field_2_dy1).append("</Y1>\n").append(string).append("\t").append("<X2>").append(this.field_3_dx2).append("</X2>\n").append(string).append("\t").append("<Y2>").append(this.field_4_dy2).append("</Y2>\n");
        stringBuilder.append(string).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return stringBuilder.toString();
    }

    public int getDx1() {
        return this.field_1_dx1;
    }

    public void setDx1(int n) {
        this.field_1_dx1 = n;
    }

    public int getDy1() {
        return this.field_2_dy1;
    }

    public void setDy1(int n) {
        this.field_2_dy1 = n;
    }

    public int getDx2() {
        return this.field_3_dx2;
    }

    public void setDx2(int n) {
        this.field_3_dx2 = n;
    }

    public int getDy2() {
        return this.field_4_dy2;
    }

    public void setDy2(int n) {
        this.field_4_dy2 = n;
    }
}

