/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ddf;

import ai.org.apache.poi.ddf.EscherBSERecord;
import ai.org.apache.poi.ddf.EscherBitmapBlip;
import ai.org.apache.poi.ddf.EscherBlipRecord;
import ai.org.apache.poi.ddf.EscherChildAnchorRecord;
import ai.org.apache.poi.ddf.EscherClientAnchorRecord;
import ai.org.apache.poi.ddf.EscherClientDataRecord;
import ai.org.apache.poi.ddf.EscherContainerRecord;
import ai.org.apache.poi.ddf.EscherDgRecord;
import ai.org.apache.poi.ddf.EscherDggRecord;
import ai.org.apache.poi.ddf.EscherMetafileBlip;
import ai.org.apache.poi.ddf.EscherOptRecord;
import ai.org.apache.poi.ddf.EscherRecord;
import ai.org.apache.poi.ddf.EscherRecordFactory;
import ai.org.apache.poi.ddf.EscherSpRecord;
import ai.org.apache.poi.ddf.EscherSpgrRecord;
import ai.org.apache.poi.ddf.EscherSplitMenuColorsRecord;
import ai.org.apache.poi.ddf.EscherTertiaryOptRecord;
import ai.org.apache.poi.ddf.EscherTextboxRecord;
import ai.org.apache.poi.ddf.UnknownEscherRecord;
import ai.org.apache.poi.util.LittleEndian;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEscherRecordFactory
implements EscherRecordFactory {
    private static Class<?>[] escherRecordClasses = new Class[]{EscherBSERecord.class, EscherOptRecord.class, EscherTertiaryOptRecord.class, EscherClientAnchorRecord.class, EscherDgRecord.class, EscherSpgrRecord.class, EscherSpRecord.class, EscherClientDataRecord.class, EscherDggRecord.class, EscherSplitMenuColorsRecord.class, EscherChildAnchorRecord.class, EscherTextboxRecord.class};
    private static Map<Short, Constructor<? extends EscherRecord>> recordsMap = DefaultEscherRecordFactory.recordsToMap(escherRecordClasses);

    @Override
    public EscherRecord createRecord(byte[] byArray, int n) {
        short s;
        short s2 = LittleEndian.getShort(byArray, n);
        if (DefaultEscherRecordFactory.isContainer(s2, s = LittleEndian.getShort(byArray, n + 2))) {
            EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
            escherContainerRecord.setRecordId(s);
            escherContainerRecord.setOptions(s2);
            return escherContainerRecord;
        }
        if (s >= -4072 && s <= -3817) {
            EscherBlipRecord escherBlipRecord = s == -4065 || s == -4067 || s == -4066 ? new EscherBitmapBlip() : (s == -4070 || s == -4069 || s == -4068 ? new EscherMetafileBlip() : new EscherBlipRecord());
            escherBlipRecord.setRecordId(s);
            escherBlipRecord.setOptions(s2);
            return escherBlipRecord;
        }
        Constructor<? extends EscherRecord> constructor = recordsMap.get(s);
        EscherRecord escherRecord = null;
        if (constructor == null) {
            return new UnknownEscherRecord();
        }
        try {
            escherRecord = constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return new UnknownEscherRecord();
        }
        escherRecord.setRecordId(s);
        escherRecord.setOptions(s2);
        return escherRecord;
    }

    private static Map<Short, Constructor<? extends EscherRecord>> recordsToMap(Class<?>[] classArray) {
        HashMap<Short, Constructor<? extends EscherRecord>> hashMap = new HashMap<Short, Constructor<? extends EscherRecord>>();
        Class[] classArray2 = new Class[]{};
        for (int i = 0; i < classArray.length; ++i) {
            Constructor<?> constructor;
            short s;
            Class<?> clazz = classArray[i];
            try {
                s = clazz.getField("RECORD_ID").getShort(null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException);
            }
            try {
                constructor = clazz.getConstructor(classArray2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            hashMap.put(s, constructor);
        }
        return hashMap;
    }

    public static boolean isContainer(short s, short s2) {
        if (s2 >= -4096 && s2 <= -4091) {
            return true;
        }
        if (s2 == -4083) {
            return false;
        }
        return (s & 0xF) == 15;
    }
}

