/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.commons.codec.language.bm;

import ai.org.apache.commons.codec.language.bm.Languages;
import ai.org.apache.commons.codec.language.bm.NameType;
import ai.org.apache.commons.codec.language.bm.RuleType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule {
    public static final RPattern ALL_STRINGS_RMATCHER = new RPattern(){

        public boolean isMatch(CharSequence charSequence) {
            return true;
        }
    };
    public static final String ALL = "ALL";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String HASH_INCLUDE = "#include";
    private static final Map<NameType, Map<RuleType, Map<String, List<Rule>>>> RULES = new EnumMap<NameType, Map<RuleType, Map<String, List<Rule>>>>(NameType.class);
    private final RPattern lContext;
    private final String pattern;
    private final PhonemeExpr phoneme;
    private final RPattern rContext;

    private static boolean contains(CharSequence charSequence, char c) {
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    private static String createResourceName(NameType nameType, RuleType ruleType, String string) {
        return String.format("org/apache/commons/codec/language/bm/%s_%s_%s.txt", nameType.getName(), ruleType.getName(), string);
    }

    private static Scanner createScanner(NameType nameType, RuleType ruleType, String string) {
        String string2 = Rule.createResourceName(nameType, ruleType, string);
        InputStream inputStream = Languages.class.getClassLoader().getResourceAsStream(string2);
        if (inputStream == null) {
            throw new IllegalArgumentException("Unable to load resource: " + string2);
        }
        return new Scanner(inputStream, "UTF-8");
    }

    private static Scanner createScanner(String string) {
        String string2 = String.format("org/apache/commons/codec/language/bm/%s.txt", string);
        InputStream inputStream = Languages.class.getClassLoader().getResourceAsStream(string2);
        if (inputStream == null) {
            throw new IllegalArgumentException("Unable to load resource: " + string2);
        }
        return new Scanner(inputStream, "UTF-8");
    }

    private static boolean endsWith(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence2.length() > charSequence.length()) {
            return false;
        }
        int n = charSequence.length() - 1;
        for (int i = charSequence2.length() - 1; i >= 0; --i) {
            if (charSequence.charAt(n) != charSequence2.charAt(i)) {
                return false;
            }
            --n;
        }
        return true;
    }

    public static List<Rule> getInstance(NameType nameType, RuleType ruleType, Languages.LanguageSet languageSet) {
        return languageSet.isSingleton() ? Rule.getInstance(nameType, ruleType, languageSet.getAny()) : Rule.getInstance(nameType, ruleType, "any");
    }

    public static List<Rule> getInstance(NameType nameType, RuleType ruleType, String string) {
        List<Rule> list = RULES.get((Object)nameType).get((Object)ruleType).get(string);
        if (list == null) {
            throw new IllegalArgumentException(String.format("No rules found for %s, %s, %s.", nameType.getName(), ruleType.getName(), string));
        }
        return list;
    }

    private static Phoneme parsePhoneme(String string) {
        int n = string.indexOf("[");
        if (n >= 0) {
            if (!string.endsWith("]")) {
                throw new IllegalArgumentException("Phoneme expression contains a '[' but does not end in ']'");
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length() - 1);
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(string3.split("[+]")));
            return new Phoneme(string2, Languages.LanguageSet.from(hashSet));
        }
        return new Phoneme(string, Languages.ANY_LANGUAGE);
    }

    private static PhonemeExpr parsePhonemeExpr(String string) {
        if (string.startsWith("(")) {
            if (!string.endsWith(")")) {
                throw new IllegalArgumentException("Phoneme starts with '(' so must end with ')'");
            }
            ArrayList<Phoneme> arrayList = new ArrayList<Phoneme>();
            String string2 = string.substring(1, string.length() - 1);
            for (String string3 : string2.split("[|]")) {
                arrayList.add(Rule.parsePhoneme(string3));
            }
            if (string2.startsWith("|") || string2.endsWith("|")) {
                arrayList.add(new Phoneme("", Languages.ANY_LANGUAGE));
            }
            return new PhonemeList(arrayList);
        }
        return Rule.parsePhoneme(string);
    }

    private static List<Rule> parseRules(Scanner scanner, final String string) {
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        int n = 0;
        boolean bl = false;
        while (scanner.hasNextLine()) {
            Object object;
            String string2;
            ++n;
            String string3 = string2 = scanner.nextLine();
            if (bl) {
                if (!string3.endsWith("*/")) continue;
                bl = false;
                continue;
            }
            if (string3.startsWith("/*")) {
                bl = true;
                continue;
            }
            int n2 = string3.indexOf("//");
            if (n2 >= 0) {
                string3 = string3.substring(0, n2);
            }
            if ((string3 = string3.trim()).length() == 0) continue;
            if (string3.startsWith(HASH_INCLUDE)) {
                object = string3.substring(HASH_INCLUDE.length()).trim();
                if (((String)object).contains(" ")) {
                    System.err.println("Warining: malformed import statement: " + string2);
                    continue;
                }
                arrayList.addAll(Rule.parseRules(Rule.createScanner((String)object), string + "->" + (String)object));
                continue;
            }
            object = string3.split("\\s+");
            if (((String[])object).length != 4) {
                System.err.println("Warning: malformed rule statement split into " + ((Object)object).length + " parts: " + string2);
                continue;
            }
            try {
                String string4 = Rule.stripQuotes((String)object[0]);
                String string5 = Rule.stripQuotes((String)object[1]);
                String string6 = Rule.stripQuotes((String)object[2]);
                PhonemeExpr phonemeExpr = Rule.parsePhonemeExpr(Rule.stripQuotes((String)object[3]));
                final int n3 = n;
                Rule rule = new Rule(string4, string5, string6, phonemeExpr){
                    private final int myLine;
                    private final String loc;
                    {
                        super(string5, string2, string3, phonemeExpr);
                        this.myLine = n3;
                        this.loc = string;
                    }

                    public String toString() {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Rule");
                        stringBuilder.append("{line=").append(this.myLine);
                        stringBuilder.append(", loc='").append(this.loc).append('\'');
                        stringBuilder.append('}');
                        return stringBuilder.toString();
                    }
                };
                arrayList.add(rule);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException("Problem parsing line " + n, illegalArgumentException);
            }
        }
        return arrayList;
    }

    private static RPattern pattern(final String string) {
        boolean bl;
        boolean bl2 = string.startsWith("^");
        final String string2 = string.substring(bl2 ? 1 : 0, (bl = string.endsWith("$")) ? string.length() - 1 : string.length());
        boolean bl3 = string2.contains("[");
        if (!bl3) {
            if (bl2 && bl) {
                if (string2.length() == 0) {
                    return new RPattern(){

                        public boolean isMatch(CharSequence charSequence) {
                            return charSequence.length() == 0;
                        }
                    };
                }
                return new RPattern(){

                    public boolean isMatch(CharSequence charSequence) {
                        return charSequence.equals(string2);
                    }
                };
            }
            if ((bl2 || bl) && string2.length() == 0) {
                return ALL_STRINGS_RMATCHER;
            }
            if (bl2) {
                return new RPattern(){

                    public boolean isMatch(CharSequence charSequence) {
                        return Rule.startsWith(charSequence, string2);
                    }
                };
            }
            if (bl) {
                return new RPattern(){

                    public boolean isMatch(CharSequence charSequence) {
                        return Rule.endsWith(charSequence, string2);
                    }
                };
            }
        } else {
            String string3;
            boolean bl4 = string2.startsWith("[");
            boolean bl5 = string2.endsWith("]");
            if (bl4 && bl5 && !(string3 = string2.substring(1, string2.length() - 1)).contains("[")) {
                boolean bl6;
                boolean bl7 = string3.startsWith("^");
                if (bl7) {
                    string3 = string3.substring(1);
                }
                final String string4 = string3;
                boolean bl8 = bl6 = !bl7;
                if (bl2 && bl) {
                    return new RPattern(){

                        public boolean isMatch(CharSequence charSequence) {
                            return charSequence.length() == 1 && Rule.contains(string4, charSequence.charAt(0)) == bl6;
                        }
                    };
                }
                if (bl2) {
                    return new RPattern(){

                        public boolean isMatch(CharSequence charSequence) {
                            return charSequence.length() > 0 && Rule.contains(string4, charSequence.charAt(0)) == bl6;
                        }
                    };
                }
                if (bl) {
                    return new RPattern(){

                        public boolean isMatch(CharSequence charSequence) {
                            return charSequence.length() > 0 && Rule.contains(string4, charSequence.charAt(charSequence.length() - 1)) == bl6;
                        }
                    };
                }
            }
        }
        return new RPattern(){
            Pattern pattern;
            {
                this.pattern = Pattern.compile(string);
            }

            public boolean isMatch(CharSequence charSequence) {
                Matcher matcher = this.pattern.matcher(charSequence);
                return matcher.find();
            }
        };
    }

    private static boolean startsWith(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence2.length() > charSequence.length()) {
            return false;
        }
        for (int i = 0; i < charSequence2.length(); ++i) {
            if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static String stripQuotes(String string) {
        if (string.startsWith(DOUBLE_QUOTE)) {
            string = string.substring(1);
        }
        if (string.endsWith(DOUBLE_QUOTE)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public Rule(String string, String string2, String string3, PhonemeExpr phonemeExpr) {
        this.pattern = string;
        this.lContext = Rule.pattern(string2 + "$");
        this.rContext = Rule.pattern("^" + string3);
        this.phoneme = phonemeExpr;
    }

    public RPattern getLContext() {
        return this.lContext;
    }

    public String getPattern() {
        return this.pattern;
    }

    public PhonemeExpr getPhoneme() {
        return this.phoneme;
    }

    public RPattern getRContext() {
        return this.rContext;
    }

    public boolean patternAndContextMatches(CharSequence charSequence, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Can not match pattern at negative indexes");
        }
        int n2 = this.pattern.length();
        int n3 = n + n2;
        if (n3 > charSequence.length()) {
            return false;
        }
        boolean bl = charSequence.subSequence(n, n3).equals(this.pattern);
        boolean bl2 = this.rContext.isMatch(charSequence.subSequence(n3, charSequence.length()));
        boolean bl3 = this.lContext.isMatch(charSequence.subSequence(0, n));
        return bl && bl2 && bl3;
    }

    static {
        for (NameType nameType : NameType.values()) {
            EnumMap enumMap = new EnumMap(RuleType.class);
            for (RuleType ruleType : RuleType.values()) {
                HashMap<String, List<Rule>> hashMap = new HashMap<String, List<Rule>>();
                Languages languages = Languages.getInstance(nameType);
                for (String string : languages.getLanguages()) {
                    try {
                        hashMap.put(string, Rule.parseRules(Rule.createScanner(nameType, ruleType, string), Rule.createResourceName(nameType, ruleType, string)));
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw new IllegalStateException("Problem processing " + Rule.createResourceName(nameType, ruleType, string), illegalStateException);
                    }
                }
                if (!ruleType.equals((Object)RuleType.RULES)) {
                    hashMap.put("common", Rule.parseRules(Rule.createScanner(nameType, ruleType, "common"), Rule.createResourceName(nameType, ruleType, "common")));
                }
                enumMap.put(ruleType, Collections.unmodifiableMap(hashMap));
            }
            RULES.put(nameType, Collections.unmodifiableMap(enumMap));
        }
    }

    public static interface RPattern {
        public boolean isMatch(CharSequence var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PhonemeList
    implements PhonemeExpr {
        private final List<Phoneme> phonemes;

        public PhonemeList(List<Phoneme> list) {
            this.phonemes = list;
        }

        public List<Phoneme> getPhonemes() {
            return this.phonemes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PhonemeExpr {
        public Iterable<Phoneme> getPhonemes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Phoneme
    implements PhonemeExpr {
        public static final Comparator<Phoneme> COMPARATOR = new Comparator<Phoneme>(){

            @Override
            public int compare(Phoneme phoneme, Phoneme phoneme2) {
                for (int i = 0; i < phoneme.phonemeText.length(); ++i) {
                    if (i >= phoneme2.phonemeText.length()) {
                        return 1;
                    }
                    int n = phoneme.phonemeText.charAt(i) - phoneme2.phonemeText.charAt(i);
                    if (n == 0) continue;
                    return n;
                }
                if (phoneme.phonemeText.length() < phoneme2.phonemeText.length()) {
                    return -1;
                }
                return 0;
            }
        };
        private final CharSequence phonemeText;
        private final Languages.LanguageSet languages;

        public Phoneme(CharSequence charSequence, Languages.LanguageSet languageSet) {
            this.phonemeText = charSequence;
            this.languages = languageSet;
        }

        public Phoneme append(CharSequence charSequence) {
            return new Phoneme(this.phonemeText.toString() + charSequence.toString(), this.languages);
        }

        public Languages.LanguageSet getLanguages() {
            return this.languages;
        }

        @Override
        public Iterable<Phoneme> getPhonemes() {
            return Collections.singleton(this);
        }

        public CharSequence getPhonemeText() {
            return this.phonemeText;
        }

        public Phoneme join(Phoneme phoneme) {
            return new Phoneme(this.phonemeText.toString() + phoneme.phonemeText.toString(), this.languages.restrictTo(phoneme.languages));
        }
    }
}

