/*
 * Decompiled with CFR 0.152.
 */
package ai.net.sourceforge.barbecue.twod.pdf417;

import ai.net.sourceforge.barbecue.Module;
import ai.net.sourceforge.barbecue.output.Output;
import ai.net.sourceforge.barbecue.output.OutputException;
import ai.net.sourceforge.barbecue.twod.pdf417.PDF417Data;

public class PDF417Module
extends Module {
    private static final int DATACOLS = 12;
    private final String data;
    private int[] out;
    private int outlen;
    private int outrows;
    private int col = 0;
    private int xp;
    private int yp;
    private int startX;
    private int wsize = 0;
    private int barWidth;

    public PDF417Module(String string) {
        super(new int[0]);
        this.data = string;
    }

    private int getBarcodeWidth() {
        return this.wsize - this.startX;
    }

    int getBarcodeHeight() {
        return this.yp;
    }

    protected int draw(Output output, int n, int n2, int n3, int n4) throws OutputException {
        this.xp = n;
        this.startX = n;
        this.yp = n2;
        this.barWidth = n3;
        this.createCodewords(this.data.toCharArray(), this.data.length());
        this.createBits(this.out, this.outlen, this.outrows);
        this.encode(this.out, this.outrows, output);
        return this.getBarcodeWidth();
    }

    private void generateEC(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 27;
        int n6 = 917;
        nArray[n] = 0;
        nArray[n + 1] = 0;
        if (n2 != 2) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            int n7 = (n4 + nArray[i]) % 929;
            if (n7 != 0) {
                n7 = 929 - n7;
            }
            n4 = (n3 + n6 * n7) % 929;
            n3 = (0 + n5 * n7) % 929;
        }
        if (n3 != 0) {
            n3 = 929 - n3;
        }
        if (n4 != 0) {
            n4 = 929 - n4;
        }
        nArray[n] = n4;
        nArray[n + 1] = n3;
    }

    private void outbit(int n, Output output) throws OutputException {
        output.drawBar(this.xp, this.yp, 1, 1, n == 1);
        this.xp += this.barWidth;
        if (this.col++ == this.wsize - 1) {
            this.col = 0;
            ++this.yp;
            this.xp = this.startX;
        }
    }

    private void createCodewords(char[] cArray, int n) {
        int n2 = 2;
        this.outlen = 2 + n / 6 * 5 + n % 6 + n2;
        this.outrows = this.outlen / 12;
        if (this.outlen % 12 != 0) {
            ++this.outrows;
        }
        if (this.outrows < 3) {
            this.outrows = 3;
        }
        if (this.outrows > 90) {
            return;
        }
        this.outlen = this.outrows * 12;
        if (this.outlen > 928) {
            return;
        }
        this.out = new int[this.outlen];
        this.out[0] = 2 + n / 6 * 5 + n % 6;
        this.out[1] = n % 6 != 0 ? 901 : 924;
        int n3 = 0;
        int n4 = 2;
        while (n3 + 5 < n) {
            int n5;
            long l = 0L;
            for (n5 = 0; n5 < 6; ++n5) {
                l <<= 8;
                l += (long)cArray[n3++];
            }
            for (n5 = 0; n5 < 5; ++n5) {
                this.out[n4 + 4 - n5] = new Long(l % 900L).intValue();
                l /= 900L;
            }
            n4 += 5;
        }
        while (n3 < n) {
            this.out[n4++] = cArray[n3++];
        }
        while (n4 < this.outlen - n2) {
            this.out[n4++] = 900;
        }
        this.generateEC(this.out, n4, n2);
    }

    private void createBits(int[] nArray, int n, int n2) {
        if (n2 < 3 || n2 > 90 || n != 12 * n2) {
            return;
        }
        int n3 = n2 * 16;
        int[] nArray2 = new int[n3];
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6 = 11;
            int n7 = i % 3;
            int n8 = i / 3;
            int n9 = n2 / 3;
            int n10 = 0 + n2 % 3;
            nArray2[n4++] = 130472;
            switch (n7) {
                case 0: {
                    nArray2[n4++] = PDF417Data.PDF417_BITS[n7][30 * n8 + n9];
                    break;
                }
                case 1: {
                    nArray2[n4++] = PDF417Data.PDF417_BITS[n7][30 * n8 + n10];
                    break;
                }
                case 2: {
                    nArray2[n4++] = PDF417Data.PDF417_BITS[n7][30 * n8 + n6];
                }
            }
            for (int j = 0; j < 12; ++j) {
                nArray2[n4++] = PDF417Data.PDF417_BITS[n7][nArray[n5++]];
            }
            switch (n7) {
                case 0: {
                    nArray2[n4++] = PDF417Data.PDF417_BITS[n7][30 * n8 + n6];
                    break;
                }
                case 1: {
                    nArray2[n4++] = PDF417Data.PDF417_BITS[n7][30 * n8 + n9];
                    break;
                }
                case 2: {
                    nArray2[n4++] = PDF417Data.PDF417_BITS[n7][30 * n8 + n10];
                }
            }
            nArray2[n4++] = 130324;
        }
        this.out = nArray2;
        this.outlen = n3;
    }

    private void encode(int[] nArray, int n, Output output) throws OutputException {
        int n2;
        int n3;
        int n4 = 7;
        int n5 = 2;
        this.wsize = (272 + this.barWidth + 4) * n5;
        for (n3 = 0; n3 < 2 * n5; ++n3) {
            for (n2 = 0; n2 < 277 * n5; ++n2) {
                this.outbit(0, output);
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                int n6;
                for (n6 = 0; n6 < 2 * n5; ++n6) {
                    this.outbit(0, output);
                }
                for (n6 = 0; n6 < 16; ++n6) {
                    int n7 = nArray[16 * n3 + n6];
                    for (int i = 16; i >= 0; --i) {
                        for (int j = 0; j < n5; ++j) {
                            if ((n7 & 1 << i) != 0) {
                                this.outbit(1, output);
                                continue;
                            }
                            this.outbit(0, output);
                        }
                    }
                }
                for (n6 = 0; n6 < n5; ++n6) {
                    this.outbit(1, output);
                }
                for (n6 = 0; n6 < 2 * n5; ++n6) {
                    this.outbit(0, output);
                }
            }
        }
        for (n3 = 0; n3 < 2 * n5; ++n3) {
            for (n2 = 0; n2 < 277 * n5; ++n2) {
                this.outbit(0, output);
            }
        }
    }
}

